/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.gui.immersiveLibrary;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import forge.net.mca.Config;
import forge.net.mca.client.gui.immersiveLibrary.Auth;
import forge.net.mca.client.gui.immersiveLibrary.RecordTypeAdapterFactory;
import forge.net.mca.client.gui.immersiveLibrary.responses.ContentIdResponse;
import forge.net.mca.client.gui.immersiveLibrary.responses.ContentListResponse;
import forge.net.mca.client.gui.immersiveLibrary.responses.ErrorResponse;
import forge.net.mca.client.gui.immersiveLibrary.responses.Response;
import forge.net.mca.client.gui.immersiveLibrary.responses.UserResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;

public class Api {
    private static final Gson gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new RecordTypeAdapterFactory()).create();

    public static Response request(HttpMethod httpMethod, Class<? extends Response> expectedAnswer, String url) {
        return Api.request(httpMethod, expectedAnswer, url, null, null);
    }

    public static Response request(HttpMethod httpMethod, Class<? extends Response> expectedAnswer, String url, Map<String, String> queryParams) {
        return Api.request(httpMethod, expectedAnswer, url, queryParams, null);
    }

    public static Response request(HttpMethod httpMethod, Class<? extends Response> expectedAnswer, String url, Map<String, String> queryParams, Map<String, String> body) {
        try {
            Object fullUrl = Config.getServerConfig().immersiveLibraryUrl + "/v1/" + url;
            if (queryParams != null) {
                fullUrl = queryParams.keySet().stream().map(key -> key + "=" + URLEncoder.encode((String)queryParams.get(key), StandardCharsets.UTF_8)).collect(Collectors.joining("&", (String)fullUrl + "?", ""));
            }
            HttpURLConnection con = (HttpURLConnection)new URL((String)fullUrl).openConnection();
            con.setRequestMethod(httpMethod.name());
            con.setRequestProperty("Content-Type", "application/json");
            con.setRequestProperty("Accept-Encoding", "gzip");
            con.setRequestProperty("Accept", "application/json");
            if (body != null && !body.isEmpty()) {
                con.setDoOutput(true);
                Gson gson = new Gson();
                String jsonBody = gson.toJson(body);
                con.getOutputStream().write(jsonBody.getBytes(StandardCharsets.UTF_8));
            }
            if (con.getErrorStream() != null) {
                int responseCode = con.getResponseCode();
                String error = IOUtils.toString((InputStream)con.getErrorStream(), (Charset)StandardCharsets.UTF_8);
                JsonObject object = (JsonObject)gson.fromJson(error, JsonObject.class);
                return new ErrorResponse(responseCode, object.get("message").getAsString());
            }
            String response = "gzip".equals(con.getContentEncoding()) ? IOUtils.toString((InputStream)new GZIPInputStream(con.getInputStream()), (Charset)StandardCharsets.UTF_8) : IOUtils.toString((InputStream)con.getInputStream(), (Charset)StandardCharsets.UTF_8);
            return (Response)gson.fromJson(response, expectedAnswer);
        }
        catch (IOException e) {
            return new ErrorResponse(-1, e.toString());
        }
    }

    public static void main(String[] args) {
        if (Auth.getToken() == null) {
            Auth.authenticate("Carl");
            return;
        }
        System.out.println(Api.request(HttpMethod.GET, ContentListResponse.class, "content/mca"));
        System.out.println(Api.request(HttpMethod.GET, UserResponse.class, "user/mca/me", Map.of("token", Auth.getToken())));
        System.out.println(Api.request(HttpMethod.POST, ContentIdResponse.class, "content/mca", Map.of("token", Auth.getToken()), Map.of("title", "Carl", "meta", "{}", "data", "12345")));
    }

    public static enum HttpMethod {
        POST,
        GET,
        DELETE,
        PUT;

    }
}

