/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.brain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import forge.net.mca.Config;
import forge.net.mca.ProfessionsMCA;
import forge.net.mca.entity.EntitiesMCA;
import forge.net.mca.entity.EquipmentSet;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.ActivityMCA;
import forge.net.mca.entity.ai.MemoryModuleTypeMCA;
import forge.net.mca.entity.ai.SchedulesMCA;
import forge.net.mca.entity.ai.brain.tasks.BowTask;
import forge.net.mca.entity.ai.brain.tasks.DeliverMessageTask;
import forge.net.mca.entity.ai.brain.tasks.EnterBuildingTask;
import forge.net.mca.entity.ai.brain.tasks.EnterFavoredBuildingTask;
import forge.net.mca.entity.ai.brain.tasks.EquipmentTask;
import forge.net.mca.entity.ai.brain.tasks.ExtendedFindPointOfInterestTask;
import forge.net.mca.entity.ai.brain.tasks.ExtendedForgetCompletedPointOfInterestTask;
import forge.net.mca.entity.ai.brain.tasks.ExtendedMeleeAttackTask;
import forge.net.mca.entity.ai.brain.tasks.ExtendedWalkTowardsTask;
import forge.net.mca.entity.ai.brain.tasks.FollowTask;
import forge.net.mca.entity.ai.brain.tasks.GreetPlayerTask;
import forge.net.mca.entity.ai.brain.tasks.GrieveTask;
import forge.net.mca.entity.ai.brain.tasks.HoldItemTask;
import forge.net.mca.entity.ai.brain.tasks.InteractTask;
import forge.net.mca.entity.ai.brain.tasks.LambdaTask;
import forge.net.mca.entity.ai.brain.tasks.LoseUnimportantJobTask;
import forge.net.mca.entity.ai.brain.tasks.PatrolVillageTask;
import forge.net.mca.entity.ai.brain.tasks.SayTask;
import forge.net.mca.entity.ai.brain.tasks.SequenceTask;
import forge.net.mca.entity.ai.brain.tasks.SmarterOpenDoorsTask;
import forge.net.mca.entity.ai.brain.tasks.StayTask;
import forge.net.mca.entity.ai.brain.tasks.WanderOrTeleportToTargetTask;
import forge.net.mca.entity.ai.brain.tasks.chore.ChoppingTask;
import forge.net.mca.entity.ai.brain.tasks.chore.FishingTask;
import forge.net.mca.entity.ai.brain.tasks.chore.HarvestingTask;
import forge.net.mca.entity.ai.brain.tasks.chore.HuntingTask;
import forge.net.mca.entity.ai.relationship.AgeState;
import forge.net.mca.server.world.data.VillageManager;
import forge.net.mca.server.world.data.villageComponents.VillageGuardsManager;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AcquirePoi;
import net.minecraft.world.entity.ai.behavior.AssignProfessionFromJobSite;
import net.minecraft.world.entity.ai.behavior.BackUpIfTooClose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.CelebrateVillagersSurvivedRaid;
import net.minecraft.world.entity.ai.behavior.CrossbowAttack;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.behavior.GiveGiftToHero;
import net.minecraft.world.entity.ai.behavior.GoOutsideToCelebrate;
import net.minecraft.world.entity.ai.behavior.GoToClosestVillage;
import net.minecraft.world.entity.ai.behavior.GoToPotentialJobSite;
import net.minecraft.world.entity.ai.behavior.GoToWantedItem;
import net.minecraft.world.entity.ai.behavior.HarvestFarmland;
import net.minecraft.world.entity.ai.behavior.InsideBrownianWalk;
import net.minecraft.world.entity.ai.behavior.InteractWith;
import net.minecraft.world.entity.ai.behavior.InteractWithDoor;
import net.minecraft.world.entity.ai.behavior.JumpOnBed;
import net.minecraft.world.entity.ai.behavior.LocateHidingPlace;
import net.minecraft.world.entity.ai.behavior.LocateHidingPlaceDuringRaid;
import net.minecraft.world.entity.ai.behavior.LookAndFollowTradingPlayerSink;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.PlayTagWithOtherKids;
import net.minecraft.world.entity.ai.behavior.PoiCompetitorScan;
import net.minecraft.world.entity.ai.behavior.ReactToBell;
import net.minecraft.world.entity.ai.behavior.ResetRaidStatus;
import net.minecraft.world.entity.ai.behavior.RingBell;
import net.minecraft.world.entity.ai.behavior.RunIf;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetClosestHomeAsWalkTarget;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetHiddenState;
import net.minecraft.world.entity.ai.behavior.SetLookAndInteract;
import net.minecraft.world.entity.ai.behavior.SetRaidStatus;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromBlockMemory;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.ShowTradesToPlayer;
import net.minecraft.world.entity.ai.behavior.SleepInBed;
import net.minecraft.world.entity.ai.behavior.SocializeAtBell;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.StrollAroundPoi;
import net.minecraft.world.entity.ai.behavior.StrollToPoi;
import net.minecraft.world.entity.ai.behavior.StrollToPoiList;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.behavior.TradeWithVillager;
import net.minecraft.world.entity.ai.behavior.UpdateActivityFromSchedule;
import net.minecraft.world.entity.ai.behavior.UseBonemeal;
import net.minecraft.world.entity.ai.behavior.ValidateNearbyPoi;
import net.minecraft.world.entity.ai.behavior.VictoryStroll;
import net.minecraft.world.entity.ai.behavior.VillageBoundRandomStroll;
import net.minecraft.world.entity.ai.behavior.VillagerCalmDown;
import net.minecraft.world.entity.ai.behavior.VillagerPanicTrigger;
import net.minecraft.world.entity.ai.behavior.WakeUp;
import net.minecraft.world.entity.ai.behavior.WorkAtComposter;
import net.minecraft.world.entity.ai.behavior.WorkAtPoi;
import net.minecraft.world.entity.ai.behavior.YieldJobSite;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class VillagerTasksMCA {
    public static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26359_, (Object)MemoryModuleType.f_26360_, (Object)MemoryModuleType.f_26361_, (Object)MemoryModuleType.f_26362_, (Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26366_, (Object)MemoryModuleType.f_26367_, (Object)MemoryModuleType.f_26368_, (Object)MemoryModuleType.f_148206_, (Object)MemoryModuleType.f_26332_, (Object)MemoryModuleType.f_26370_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_26371_, MemoryModuleType.f_26374_, MemoryModuleType.f_26375_, MemoryModuleType.f_26377_, MemoryModuleType.f_26379_, MemoryModuleType.f_26380_, MemoryModuleType.f_26381_, MemoryModuleType.f_26382_, MemoryModuleType.f_26323_, MemoryModuleType.f_26363_, MemoryModuleType.f_26324_, MemoryModuleType.f_26325_, MemoryModuleType.f_26326_, MemoryModuleType.f_26328_, MemoryModuleType.f_26329_, MemoryModuleType.f_26330_, MemoryModuleType.f_26327_, MemoryModuleType.f_26372_, MemoryModuleType.f_26373_, (MemoryModuleType)MemoryModuleTypeMCA.PLAYER_FOLLOWING.get(), (MemoryModuleType)MemoryModuleTypeMCA.STAYING.get(), (MemoryModuleType)MemoryModuleTypeMCA.NEAREST_GUARD_ENEMY.get(), (MemoryModuleType)MemoryModuleTypeMCA.WEARS_ARMOR.get(), (MemoryModuleType)MemoryModuleTypeMCA.SMALL_BOUNTY.get(), (MemoryModuleType)MemoryModuleTypeMCA.HIT_BY_PLAYER.get(), (MemoryModuleType)MemoryModuleTypeMCA.LAST_GRIEVE.get(), (MemoryModuleType)MemoryModuleTypeMCA.FORCED_HOME.get(), (MemoryModuleType)MemoryModuleTypeMCA.LAST_CANT_FIND_HOME_PISSED_MOMENT.get()});
    public static final ImmutableList<SensorType<? extends Sensor<? super Villager>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26812_, (Object)SensorType.f_26810_, (Object)SensorType.f_26813_, (Object)SensorType.f_26814_, (Object)SensorType.f_26815_, (Object)SensorType.f_26817_, (Object)SensorType.f_26818_, (Object)((SensorType)ActivityMCA.VILLAGER_BABIES.get()), (Object)((SensorType)ActivityMCA.EXPLODING_CREEPER.get()), (Object)((SensorType)ActivityMCA.GUARD_ENEMIES.get()));

    public static Brain.Provider<VillagerEntityMCA> createProfile() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    public static Brain<VillagerEntityMCA> initializeTasks(VillagerEntityMCA villager, Brain<VillagerEntityMCA> brain) {
        VillagerProfession profession = villager.m_7141_().m_35571_();
        AgeState age = AgeState.byCurrentAge(villager.m_146764_());
        boolean noDefault = false;
        if (brain.m_21952_((MemoryModuleType)MemoryModuleTypeMCA.STAYING.get()).isPresent()) {
            brain.m_21900_(Activity.f_37978_, VillagerTasksMCA.getStayingPackage());
            brain.m_21900_(Activity.f_37978_, VillagerTasksMCA.getImportantCorePackage(0.5f));
            brain.m_21900_(Activity.f_37978_, VillagerTasksMCA.getSelfDefencePackage());
            brain.m_21900_(Activity.f_37984_, VillagerTasksMCA.getPanicPackage(0.5f));
            noDefault = true;
        } else if (brain.m_21952_((MemoryModuleType)MemoryModuleTypeMCA.PLAYER_FOLLOWING.get()).isPresent()) {
            brain.m_21900_(Activity.f_37978_, VillagerTasksMCA.getFollowingPackage());
            brain.m_21900_(Activity.f_37978_, VillagerTasksMCA.getImportantCorePackage(0.5f));
            brain.m_21900_(Activity.f_37978_, VillagerTasksMCA.getSelfDefencePackage());
            brain.m_21900_(Activity.f_37984_, VillagerTasksMCA.getPanicPackage(0.5f));
            noDefault = true;
        } else if (profession == ProfessionsMCA.MERCENARY.get()) {
            brain.m_21912_(SchedulesMCA.GUESTS);
            brain.m_21900_(Activity.f_37978_, VillagerTasksMCA.getImportantCorePackage(0.5f));
            brain.m_21900_(Activity.f_37979_, VillagerTasksMCA.getMercenaryPackage(0.5f));
            brain.m_21900_(Activity.f_37978_, VillagerTasksMCA.getGuardCorePackage(villager));
            brain.m_21900_(Activity.f_37984_, VillagerTasksMCA.getPanicPackage(0.5f));
            brain.m_21900_(Activity.f_37982_, VillagerTasksMCA.getRestPackage(0.5f));
            brain.m_21900_((Activity)ActivityMCA.CHORE.get(), VillagerTasksMCA.getChorePackage());
            noDefault = true;
        } else if (!villager.requiresHome()) {
            brain.m_21912_(SchedulesMCA.GUESTS);
            brain.m_21900_(Activity.f_37978_, VillagerTasksMCA.getImportantCorePackage(0.5f));
            brain.m_21900_(Activity.f_37979_, VillagerTasksMCA.getAdventurerPackage(0.5f));
            brain.m_21900_(Activity.f_37978_, VillagerTasksMCA.getSelfDefencePackage());
            brain.m_21900_(Activity.f_37984_, VillagerTasksMCA.getPanicPackage(0.5f));
            brain.m_21900_(Activity.f_37982_, VillagerTasksMCA.getRestPackage(0.5f));
            noDefault = true;
        } else {
            if (age == AgeState.BABY) {
                brain.m_21912_(Schedule.f_38014_);
                return brain;
            }
            if (age != AgeState.ADULT) {
                brain.m_21912_(Schedule.f_38014_);
                brain.m_21900_(Activity.f_37981_, VillagerTasksMCA.getPlayPackage(0.5f));
                brain.m_21900_(Activity.f_37978_, VillagerTasksMCA.getSelfDefencePackage());
            } else if (villager.isGuard()) {
                brain.m_21912_(SchedulesMCA.getTypeSchedule((LivingEntity)villager, SchedulesMCA.GUARD, SchedulesMCA.GUARD_NIGHT));
                brain.m_21900_(Activity.f_37978_, VillagerTasksMCA.getGuardCorePackage(villager));
                brain.m_21900_(Activity.f_37980_, VillagerTasksMCA.getGuardWorkPackage());
                brain.m_21900_(Activity.f_37984_, VillagerTasksMCA.getGuardPanicPackage(0.5f));
                brain.m_21900_(Activity.f_37985_, VillagerTasksMCA.getGuardWorkPackage());
            } else {
                brain.m_21912_(SchedulesMCA.getTypeSchedule((LivingEntity)villager));
                brain.m_21900_(Activity.f_37978_, VillagerTasksMCA.getWorkingCorePackage(profession, 0.5f));
                brain.m_21903_(Activity.f_37980_, VillagerTasksMCA.getWorkPackage(profession, 0.5f), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_26360_, (Object)MemoryStatus.VALUE_PRESENT)));
                brain.m_21900_(Activity.f_37978_, VillagerTasksMCA.getSelfDefencePackage());
                brain.m_21900_(Activity.f_37985_, VillagerTasksMCA.getRaidPackage(0.5f));
            }
        }
        brain.m_21900_((Activity)ActivityMCA.GRIEVE.get(), VillagerTasksMCA.getGrievingPackage());
        if (!noDefault) {
            brain.m_21900_(Activity.f_37978_, VillagerTasksMCA.getImportantCorePackage(0.5f));
            brain.m_21900_(Activity.f_37978_, VillagerTasksMCA.getCorePackage(0.5f));
            brain.m_21903_(Activity.f_37983_, VillagerTasksMCA.getMeetPackage(0.5f), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_26362_, (Object)MemoryStatus.VALUE_PRESENT)));
            brain.m_21900_(Activity.f_37982_, VillagerTasksMCA.getRestPackage(0.5f));
            brain.m_21900_(Activity.f_37979_, VillagerTasksMCA.getIdlePackage(0.5f));
            brain.m_21900_(Activity.f_37984_, VillagerTasksMCA.getPanicPackage(0.5f));
            brain.m_21900_(Activity.f_37986_, VillagerTasksMCA.getPreRaidPackage(0.5f));
            brain.m_21900_(Activity.f_37987_, VillagerTasksMCA.getHidePackage(0.5f));
            brain.m_21900_((Activity)ActivityMCA.CHORE.get(), VillagerTasksMCA.getChorePackage());
        }
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21889_(Activity.f_37979_);
        brain.m_21862_(villager.f_19853_.m_46468_(), villager.f_19853_.m_46467_());
        return brain;
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super VillagerEntityMCA>>> getStayingPackage() {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new StayTask())), VillagerTasksMCA.getFullLookBehavior());
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super VillagerEntityMCA>>> getFollowingPackage() {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new FollowTask())), VillagerTasksMCA.getMinimalLookBehavior());
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super VillagerEntityMCA>>> getImportantCorePackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new Swim(0.8f)), (Object)(Config.getServerConfig().useSmarterDoorAI ? Pair.of((Object)0, (Object)((Object)new SmarterOpenDoorsTask())) : Pair.of((Object)0, (Object)new InteractWithDoor())), (Object)Pair.of((Object)0, (Object)new LookAtTargetSink(45, 90)), (Object)Pair.of((Object)0, (Object)new WakeUp()), (Object)Pair.of((Object)0, (Object)((Object)new DeliverMessageTask())), (Object)Pair.of((Object)1, (Object)((Object)new WanderOrTeleportToTargetTask())), (Object)Pair.of((Object)3, (Object)((Object)new InteractTask(speedModifier))), (Object)Pair.of((Object)10, (Object)((Object)new ExtendedFindPointOfInterestTask(registryEntry -> registryEntry.m_203565_(PoiTypes.f_218060_), (MemoryModuleType<GlobalPos>)MemoryModuleType.f_26359_, false, Optional.of((byte)14), villager -> villager.getResidency().seekHome(), (entity, pos) -> {
            VillageManager manager = VillageManager.get((ServerLevel)entity.f_19853_);
            if (entity.requiresHome()) {
                return manager.findNearestVillage((Entity)entity).filter(v -> !v.isPositionValidBed((BlockPos)pos)).isEmpty();
            }
            return manager.findNearestVillage((Entity)entity).filter(v -> v.getBuildingAt((Vec3i)pos).filter(b -> b.getBuildingType().name().equals("inn")).isPresent()).isPresent();
        }))));
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super VillagerEntityMCA>>> getCorePackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new GreetPlayerTask())), (Object)Pair.of((Object)0, (Object)new ReactToBell()), (Object)Pair.of((Object)0, (Object)new SetRaidStatus()), (Object)Pair.of((Object)5, (Object)new GoToWantedItem(speedModifier, false, 4)), (Object)Pair.of((Object)10, (Object)((Object)new ExtendedFindPointOfInterestTask(registryEntry -> registryEntry.m_203565_(PoiTypes.f_218060_), (MemoryModuleType<GlobalPos>)MemoryModuleType.f_26359_, false, Optional.of((byte)14), villager -> villager.getResidency().seekHome(), (entity, pos) -> {
            VillageManager manager = VillageManager.get((ServerLevel)entity.f_19853_);
            return manager.findNearestVillage((Entity)entity).filter(v -> v.getBuildingAt((Vec3i)pos).filter(b -> b.getBuildingType().noBeds()).isPresent()).isEmpty();
        }))), (Object)Pair.of((Object)10, (Object)((Object)new ExtendedFindPointOfInterestTask(registryEntry -> registryEntry.m_203565_(PoiTypes.f_218061_), (MemoryModuleType<GlobalPos>)MemoryModuleType.f_26362_, true, Optional.of((byte)14), villager -> villager.m_6274_().m_21952_(MemoryModuleType.f_26362_).ifPresent(p -> {
            if (villager.f_19853_.m_46472_() == p.m_122640_()) {
                VillageManager manager = VillageManager.get((ServerLevel)villager.f_19853_);
                if (!manager.cache.contains(p.m_122646_())) {
                    manager.cache.add(p.m_122646_());
                    manager.processBuilding(p.m_122646_());
                }
                villager.getResidency().seekHome();
            }
        })))));
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super VillagerEntityMCA>>> getWorkingCorePackage(VillagerProfession profession, float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new ValidateNearbyPoi(profession.f_219628_(), MemoryModuleType.f_26360_)), (Object)Pair.of((Object)0, (Object)new ValidateNearbyPoi(profession.f_219629_(), MemoryModuleType.f_26361_)), (Object)Pair.of((Object)2, (Object)new PoiCompetitorScan(profession)), (Object)Pair.of((Object)3, (Object)new LookAndFollowTradingPlayerSink(speedModifier)), (Object)Pair.of((Object)6, (Object)new AcquirePoi(profession.f_219629_(), MemoryModuleType.f_26360_, MemoryModuleType.f_26361_, true, Optional.empty())), (Object)Pair.of((Object)7, (Object)new GoToPotentialJobSite(speedModifier)), (Object)Pair.of((Object)8, (Object)new YieldJobSite(speedModifier)), (Object)Pair.of((Object)10, (Object)new AssignProfessionFromJobSite()), (Object)Pair.of((Object)10, (Object)((Object)new LoseUnimportantJobTask())));
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super VillagerEntityMCA>>> getSelfDefencePackage() {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new VillagerPanicTrigger()), (Object)Pair.of((Object)1, (Object)((Object)new EquipmentTask(VillagerTasksMCA::isInDanger, v -> EquipmentSet.NAKED))), (Object)Pair.of((Object)2, (Object)((Object)new ExtendedMeleeAttackTask(15, 2.5f, (MemoryModuleType<? extends LivingEntity>)MemoryModuleType.f_26323_))));
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super VillagerEntityMCA>>> getGuardCorePackage(VillagerEntityMCA villager) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new RunIf(VillagerTasksMCA::guardTooHurt, (Behavior)new VillagerPanicTrigger())), (Object)Pair.of((Object)0, (Object)((Object)new SayTask("villager.retreat", 100, e -> VillagerTasksMCA.guardTooHurt(e) && e.getVillagerBrain().isPanicking()))), (Object)Pair.of((Object)0, (Object)((Object)new SayTask("villager.attack", 160, e -> !VillagerTasksMCA.guardTooHurt(e) && VillagerTasksMCA.getPreferredTarget(e).isPresent()))), (Object)Pair.of((Object)0, (Object)new RunIf(VillagerTasksMCA::guardTooHurt, (Behavior)new ExtendedMeleeAttackTask(15, 2.5f, (MemoryModuleType<? extends LivingEntity>)MemoryModuleType.f_26323_))), (Object)Pair.of((Object)1, (Object)((Object)new EquipmentTask(VillagerTasksMCA::isOnDuty, v -> v.getResidency().getHomeVillage().map(vil -> vil.getVillageGuardsManager().getGuardEquipment(v.getProfession(), v.getDominantHand())).orElse(VillageGuardsManager.getEquipmentFor(v.getDominantHand(), EquipmentSet.GUARD_0, EquipmentSet.GUARD_0_LEFT))))), (Object)Pair.of((Object)2, (Object)new StartAttacking(t -> true, VillagerTasksMCA::getPreferredTarget)), (Object)Pair.of((Object)3, (Object)new StopAttackingIfTargetInvalid(livingEntity -> !VillagerTasksMCA.isPreferredTarget(villager, livingEntity))), (Object)Pair.of((Object)4, new BowTask(20, 12)), (Object)Pair.of((Object)5, (Object)new RunIf(v -> v.m_21055_(Items.f_42717_), (Behavior)new BackUpIfTooClose(5, 0.75f))), (Object)Pair.of((Object)6, (Object)new SetWalkTargetFromAttackTargetIfTargetOutOfReach(0.75f)), (Object)Pair.of((Object)7, (Object)((Object)new ExtendedMeleeAttackTask(20, 2.0f))), (Object)Pair.of((Object)8, (Object)new CrossbowAttack()), (Object[])new Pair[0]);
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super VillagerEntityMCA>>> getGuardWorkPackage() {
        return ImmutableList.of((Object)Pair.of((Object)10, (Object)((Object)new PatrolVillageTask(4, 0.4f))), (Object)Pair.of((Object)99, (Object)new UpdateActivityFromSchedule()));
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super VillagerEntityMCA>>> getGuardPanicPackage(float speedModifier) {
        float f = speedModifier * 1.5f;
        return ImmutableList.of((Object)Pair.of((Object)1, (Object)new VillagerCalmDown()), (Object)Pair.of((Object)2, (Object)SetWalkTargetAwayFrom.m_24019_((MemoryModuleType)MemoryModuleType.f_26323_, (float)f, (int)6, (boolean)false)), (Object)Pair.of((Object)2, (Object)SetWalkTargetAwayFrom.m_24019_((MemoryModuleType)MemoryModuleType.f_26382_, (float)f, (int)6, (boolean)false)), (Object)Pair.of((Object)3, (Object)new VillageBoundRandomStroll(f, 2, 2)), VillagerTasksMCA.getMinimalLookBehavior());
    }

    private static boolean guardTooHurt(VillagerEntityMCA villager) {
        return (double)villager.m_21223_() < (double)villager.m_21233_() * 0.25;
    }

    private static Optional<? extends LivingEntity> getPreferredTarget(VillagerEntityMCA villager) {
        if (VillagerTasksMCA.guardTooHurt(villager)) {
            return Optional.empty();
        }
        Optional primary = villager.m_6274_().m_21952_((MemoryModuleType)MemoryModuleTypeMCA.NEAREST_GUARD_ENEMY.get());
        if (primary.isPresent() && (VillagerTasksMCA.getActivity(villager) != Activity.f_37982_ || (double)((LivingEntity)primary.get()).m_20270_((Entity)villager) < 8.0)) {
            return primary;
        }
        return villager.m_6274_().m_21952_(MemoryModuleType.f_26372_);
    }

    private static boolean isPreferredTarget(VillagerEntityMCA villager, LivingEntity entity) {
        Optional<? extends LivingEntity> target = VillagerTasksMCA.getPreferredTarget(villager);
        return target.filter(livingEntity -> livingEntity == entity).isPresent();
    }

    public static boolean isOnDuty(VillagerEntityMCA villager) {
        return VillagerTasksMCA.getActivity(villager) == Activity.f_37980_ || villager.m_6274_().m_21952_(MemoryModuleType.f_26372_).isPresent();
    }

    public static boolean isInDanger(VillagerEntityMCA villager) {
        return villager.getVillagerBrain().isPanicking() || villager.m_6274_().m_21952_(MemoryModuleType.f_26372_).isPresent();
    }

    private static Activity getActivity(VillagerEntityMCA villager) {
        return villager.m_6274_().m_21932_().m_38019_((int)(villager.f_19853_.m_46468_() % 24000L));
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super VillagerEntityMCA>>> getGrievingPackage() {
        return ImmutableList.of((Object)Pair.of((Object)0, new SequenceTask((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT), ImmutableList.of((Object)((Object)new EnterBuildingTask("graveyard", 0.5f)), (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)((Object)new HoldItemTask(InteractionHand.MAIN_HAND, Items.f_41946_)), (Object)1), (Object)Pair.of((Object)((Object)new HoldItemTask(InteractionHand.MAIN_HAND, Items.f_41944_)), (Object)1), (Object)Pair.of((Object)((Object)new HoldItemTask(InteractionHand.MAIN_HAND, Items.f_41945_)), (Object)1), (Object)Pair.of((Object)((Object)new HoldItemTask(InteractionHand.MAIN_HAND, Items.f_41947_)), (Object)1))), (Object)((Object)new WanderOrTeleportToTargetTask()), (Object)new DoNothing(100, 300), (Object)((Object)new SayTask("villager.grieving")), (Object)new DoNothing(100, 300), (Object)((Object)new SayTask("villager.grieving")), (Object)new DoNothing(100, 300), (Object)((Object)new SayTask("villager.grieving")), (Object)((Object)new HoldItemTask(InteractionHand.MAIN_HAND, ItemStack.f_41583_)), new LambdaTask<VillagerEntityMCA>(v -> {
            v.getVillagerBrain().justGrieved();
            v.m_6274_().m_21862_(v.m_9236_().m_46468_(), v.m_9236_().m_46467_());
        })))));
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super VillagerEntityMCA>>> getWorkPackage(VillagerProfession profession, float speedModifier) {
        Object villagerWorkTask = profession == VillagerProfession.f_35590_ ? new WorkAtComposter() : new WorkAtPoi();
        return ImmutableList.of(VillagerTasksMCA.getMinimalLookBehavior(), (Object)Pair.of((Object)5, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)villagerWorkTask, (Object)7), (Object)Pair.of((Object)new StrollAroundPoi(MemoryModuleType.f_26360_, 0.4f, 4), (Object)2), (Object)Pair.of((Object)new StrollToPoi(MemoryModuleType.f_26360_, 0.4f, 1, 10), (Object)5), (Object)Pair.of((Object)new StrollToPoiList(MemoryModuleType.f_26363_, speedModifier, 1, 6, MemoryModuleType.f_26360_), (Object)5), (Object)Pair.of((Object)new HarvestFarmland(), (Object)(profession == VillagerProfession.f_35590_ ? 2 : 5)), (Object)Pair.of((Object)new UseBonemeal(), (Object)(profession == VillagerProfession.f_35590_ ? 4 : 7))))), (Object)Pair.of((Object)10, (Object)new ShowTradesToPlayer(400, 1600)), (Object)Pair.of((Object)10, (Object)new SetLookAndInteract(EntityType.f_20532_, 4)), (Object)Pair.of((Object)2, (Object)new SetWalkTargetFromBlockMemory(MemoryModuleType.f_26360_, speedModifier, 9, 100, 1200)), (Object)Pair.of((Object)3, (Object)new GiveGiftToHero(100)), (Object)Pair.of((Object)99, (Object)new UpdateActivityFromSchedule()));
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super VillagerEntityMCA>>> getPlayPackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new MoveToTargetSink(80, 120)), VillagerTasksMCA.getFullLookBehavior(), (Object)Pair.of((Object)5, (Object)new PlayTagWithOtherKids()), (Object)Pair.of((Object)5, (Object)new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.f_26366_, (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)InteractWith.m_23260_((EntityType)EntityType.f_20492_, (int)8, (MemoryModuleType)MemoryModuleType.f_26374_, (float)speedModifier, (int)2), (Object)2), (Object)Pair.of((Object)InteractWith.m_23260_((EntityType)EntityType.f_20553_, (int)8, (MemoryModuleType)MemoryModuleType.f_26374_, (float)speedModifier, (int)2), (Object)1), (Object)Pair.of((Object)new VillageBoundRandomStroll(speedModifier), (Object)1), (Object)Pair.of((Object)new SetWalkTargetFromLookTarget(speedModifier, 2), (Object)1), (Object)Pair.of((Object)new JumpOnBed(speedModifier), (Object)2), (Object)Pair.of((Object)new DoNothing(20, 40), (Object)2)))), (Object)Pair.of((Object)99, (Object)new UpdateActivityFromSchedule()));
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super VillagerEntityMCA>>> getRestPackage(float speed) {
        return ImmutableList.of((Object)Pair.of((Object)2, (Object)((Object)new ExtendedWalkTowardsTask((MemoryModuleType<GlobalPos>)MemoryModuleType.f_26359_, speed, 1, 192, 1200, v -> {
            boolean forced = v.m_6274_().m_21952_((MemoryModuleType)MemoryModuleTypeMCA.FORCED_HOME.get()).isPresent();
            if (forced) {
                v.sendChatToAllAround("villager.cant_find_bed", new Object[0]);
            }
            return !forced;
        }, v -> v.getResidency().seekHome()))), (Object)Pair.of((Object)3, (Object)new RunIf(Map.of((MemoryModuleType)MemoryModuleTypeMCA.FORCED_HOME.get(), MemoryStatus.VALUE_ABSENT), (Behavior)new ExtendedForgetCompletedPointOfInterestTask(registryEntry -> registryEntry.m_203565_(PoiTypes.f_218060_), (MemoryModuleType<GlobalPos>)MemoryModuleType.f_26359_, entity -> {
            if (entity instanceof VillagerEntityMCA) {
                VillagerEntityMCA villager = (VillagerEntityMCA)entity;
                villager.getResidency().seekHome();
            }
        }))), (Object)Pair.of((Object)3, (Object)new SleepInBed()), (Object)Pair.of((Object)5, (Object)new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.f_26359_, (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)new SetClosestHomeAsWalkTarget(speed), (Object)1), (Object)Pair.of((Object)new InsideBrownianWalk(speed), (Object)4), (Object)Pair.of((Object)new GoToClosestVillage(speed, 4), (Object)2), (Object)Pair.of((Object)new DoNothing(20, 40), (Object)2)))), (Object)Pair.of((Object)99, (Object)new UpdateActivityFromSchedule()));
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super VillagerEntityMCA>>> getMeetPackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)2, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new StrollAroundPoi(MemoryModuleType.f_26362_, 0.4f, 40), (Object)2), (Object)Pair.of((Object)new SocializeAtBell(), (Object)2)))), (Object)Pair.of((Object)10, (Object)new ShowTradesToPlayer(400, 1600)), (Object)Pair.of((Object)10, (Object)new SetLookAndInteract(EntityType.f_20532_, 4)), (Object)Pair.of((Object)2, (Object)new SetWalkTargetFromBlockMemory(MemoryModuleType.f_26362_, speedModifier, 6, 100, 200)), (Object)Pair.of((Object)3, (Object)new GiveGiftToHero(100)), (Object)Pair.of((Object)3, (Object)new ValidateNearbyPoi(registryEntry -> registryEntry.m_203565_(PoiTypes.f_218061_), MemoryModuleType.f_26362_)), (Object)Pair.of((Object)3, (Object)new GateBehavior((Map)ImmutableMap.of(), (Set)ImmutableSet.of((Object)MemoryModuleType.f_26374_), GateBehavior.OrderPolicy.ORDERED, GateBehavior.RunningPolicy.RUN_ONE, (List)ImmutableList.of((Object)Pair.of((Object)new TradeWithVillager(), (Object)1)))), VillagerTasksMCA.getFullLookBehavior(), (Object)Pair.of((Object)99, (Object)new UpdateActivityFromSchedule()));
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super VillagerEntityMCA>>> getIdlePackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)1, (Object)((Object)new EnterFavoredBuildingTask(0.5f))), (Object)Pair.of((Object)2, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)InteractWith.m_23260_((EntityType)((EntityType)EntitiesMCA.FEMALE_VILLAGER.get()), (int)8, (MemoryModuleType)MemoryModuleType.f_26374_, (float)speedModifier, (int)2), (Object)2), (Object)Pair.of((Object)InteractWith.m_23260_((EntityType)((EntityType)EntitiesMCA.MALE_VILLAGER.get()), (int)8, (MemoryModuleType)MemoryModuleType.f_26374_, (float)speedModifier, (int)2), (Object)2), (Object)Pair.of((Object)InteractWith.m_23260_((EntityType)EntityType.f_20553_, (int)8, (MemoryModuleType)MemoryModuleType.f_26374_, (float)speedModifier, (int)2), (Object)1), (Object)Pair.of((Object)new VillageBoundRandomStroll(speedModifier), (Object)1), (Object)Pair.of((Object)new SetWalkTargetFromLookTarget(speedModifier, 2), (Object)1), (Object)Pair.of((Object)new JumpOnBed(speedModifier), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)))), (Object)Pair.of((Object)3, (Object)new GiveGiftToHero(100)), (Object)Pair.of((Object)3, (Object)new SetLookAndInteract(EntityType.f_20532_, 4)), (Object)Pair.of((Object)3, (Object)new ShowTradesToPlayer(400, 1600)), (Object)Pair.of((Object)3, (Object)((Object)new GrieveTask())), (Object)Pair.of((Object)3, (Object)new GateBehavior((Map)ImmutableMap.of(), (Set)ImmutableSet.of((Object)MemoryModuleType.f_26374_), GateBehavior.OrderPolicy.ORDERED, GateBehavior.RunningPolicy.RUN_ONE, (List)ImmutableList.of((Object)Pair.of((Object)new TradeWithVillager(), (Object)1)))), VillagerTasksMCA.getFullLookBehavior(), (Object)Pair.of((Object)99, (Object)new UpdateActivityFromSchedule()));
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super VillagerEntityMCA>>> getPanicPackage(float speedModifier) {
        float f = speedModifier * 1.5f;
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new VillagerCalmDown()), (Object)Pair.of((Object)1, (Object)SetWalkTargetAwayFrom.m_24019_((MemoryModuleType)MemoryModuleType.f_26323_, (float)f, (int)6, (boolean)false)), (Object)Pair.of((Object)1, (Object)SetWalkTargetAwayFrom.m_24019_((MemoryModuleType)MemoryModuleType.f_26382_, (float)f, (int)6, (boolean)false)), (Object)Pair.of((Object)3, (Object)new VillageBoundRandomStroll(f, 2, 2)), VillagerTasksMCA.getMinimalLookBehavior());
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super VillagerEntityMCA>>> getPreRaidPackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new RingBell()), (Object)Pair.of((Object)0, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new SetWalkTargetFromBlockMemory(MemoryModuleType.f_26362_, speedModifier * 1.5f, 2, 150, 200), (Object)6), (Object)Pair.of((Object)new VillageBoundRandomStroll(speedModifier * 1.5f), (Object)2)))), VillagerTasksMCA.getMinimalLookBehavior(), (Object)Pair.of((Object)99, (Object)new ResetRaidStatus()));
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super VillagerEntityMCA>>> getRaidPackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new GoOutsideToCelebrate(speedModifier), (Object)5), (Object)Pair.of((Object)new VictoryStroll(speedModifier * 1.1f), (Object)2)))), (Object)Pair.of((Object)0, (Object)new CelebrateVillagersSurvivedRaid(600, 600)), (Object)Pair.of((Object)2, (Object)new LocateHidingPlaceDuringRaid(24, speedModifier * 1.4f)), VillagerTasksMCA.getMinimalLookBehavior(), (Object)Pair.of((Object)99, (Object)new ResetRaidStatus()));
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super VillagerEntityMCA>>> getHidePackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new SetHiddenState(15, 3)), (Object)Pair.of((Object)1, (Object)new LocateHidingPlace(32, speedModifier * 1.25f, 2)), VillagerTasksMCA.getMinimalLookBehavior());
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super VillagerEntityMCA>>> getChorePackage() {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new ChoppingTask())), (Object)Pair.of((Object)0, (Object)((Object)new FishingTask())), (Object)Pair.of((Object)0, (Object)((Object)new HarvestingTask())), (Object)Pair.of((Object)0, (Object)((Object)new HuntingTask())));
    }

    private static ImmutableList<Pair<Integer, ? extends Behavior<? super VillagerEntityMCA>>> getAdventurerPackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)5, (Object)InteractWith.m_23260_((EntityType)((EntityType)EntitiesMCA.FEMALE_VILLAGER.get()), (int)8, (MemoryModuleType)MemoryModuleType.f_26374_, (float)speedModifier, (int)2)), (Object)Pair.of((Object)5, (Object)InteractWith.m_23260_((EntityType)((EntityType)EntitiesMCA.MALE_VILLAGER.get()), (int)8, (MemoryModuleType)MemoryModuleType.f_26374_, (float)speedModifier, (int)2)), (Object)Pair.of((Object)5, (Object)InteractWith.m_23260_((EntityType)EntityType.f_20553_, (int)8, (MemoryModuleType)MemoryModuleType.f_26374_, (float)speedModifier, (int)2)), (Object)Pair.of((Object)5, (Object)new VillageBoundRandomStroll(speedModifier)), (Object)Pair.of((Object)5, (Object)new SetWalkTargetFromLookTarget(speedModifier, 2)), (Object)Pair.of((Object)5, (Object)((Object)new EnterBuildingTask("inn", 0.5f))));
    }

    private static ImmutableList<Pair<Integer, ? extends Behavior<? super VillagerEntityMCA>>> getMercenaryPackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)5, (Object)new VillageBoundRandomStroll(speedModifier)), (Object)Pair.of((Object)5, (Object)new SetWalkTargetFromLookTarget(speedModifier, 2)));
    }

    private static Pair<Integer, Behavior<LivingEntity>> getFullLookBehavior() {
        return Pair.of((Object)5, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new SetEntityLookTarget(EntityType.f_20553_, 8.0f), (Object)8), (Object)Pair.of((Object)new SetEntityLookTarget(EntityType.f_20492_, 8.0f), (Object)2), (Object)Pair.of((Object)new SetEntityLookTarget(EntityType.f_20532_, 8.0f), (Object)2), (Object)Pair.of((Object)new SetEntityLookTarget(MobCategory.CREATURE, 8.0f), (Object)1), (Object)Pair.of((Object)new SetEntityLookTarget(MobCategory.WATER_CREATURE, 8.0f), (Object)1), (Object)Pair.of((Object)new SetEntityLookTarget(MobCategory.WATER_AMBIENT, 8.0f), (Object)1), (Object)Pair.of((Object)new SetEntityLookTarget(MobCategory.MONSTER, 8.0f), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)2))));
    }

    private static Pair<Integer, Behavior<LivingEntity>> getMinimalLookBehavior() {
        return Pair.of((Object)5, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new SetEntityLookTarget(EntityType.f_20492_, 8.0f), (Object)2), (Object)Pair.of((Object)new SetEntityLookTarget(EntityType.f_20532_, 8.0f), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)8))));
    }
}

