/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.mixin;

import forge.net.mca.Config;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.VillagerLike;
import forge.net.mca.entity.ai.GPT3;
import forge.net.mca.util.WorldUtils;
import java.text.Normalizer;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ServerboundChatPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import org.apache.commons.lang3.StringUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerGamePacketListenerImpl.class})
public class MixinServerPlayNetworkHandler {
    @Shadow
    public ServerPlayer f_9743_;

    private String normalize(String string) {
        return Normalizer.normalize(string, Normalizer.Form.NFD).replaceAll("\\p{M}", "").toLowerCase(Locale.ROOT);
    }

    @Inject(method={"onChatMessage"}, at={@At(value="HEAD")})
    public void sendMessage(ServerboundChatPacket message, CallbackInfo ci) {
        String msg;
        if (Config.getInstance().enableVillagerChatAI && !(msg = StringUtils.normalizeSpace((String)message.f_133827_())).startsWith("/")) {
            List<VillagerEntityMCA> entities = WorldUtils.getCloseEntities(this.f_9743_.f_19853_, (Entity)this.f_9743_, 32.0, VillagerEntityMCA.class);
            String search = this.normalize(msg);
            boolean talked = false;
            for (VillagerEntityMCA villager : entities) {
                String name = this.normalize((String)villager.getTrackedValue(VillagerLike.VILLAGER_NAME));
                if (!search.contains(name)) continue;
                CompletableFuture.runAsync(() -> GPT3.answer(this.f_9743_, villager, msg).ifPresent(a -> villager.conversationManager.addMessage((Entity)this.f_9743_, Component.m_237113_((String)a))));
                talked = true;
                break;
            }
            if (!talked) {
                for (VillagerEntityMCA villager : entities) {
                    if (!GPT3.inConversationWith(villager, this.f_9743_)) continue;
                    CompletableFuture.runAsync(() -> GPT3.answer(this.f_9743_, villager, msg).ifPresent(a -> villager.conversationManager.addMessage((Entity)this.f_9743_, Component.m_237113_((String)a))));
                    break;
                }
            }
        }
    }
}

