/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.mixin.client;

import forge.net.mca.entity.CommonSpeechManager;
import forge.net.mca.entity.ai.DialogueType;
import forge.net.mca.util.localization.PooledTranslationStorage;
import java.util.Map;
import net.minecraft.client.resources.language.ClientLanguage;
import net.minecraft.locale.Language;
import net.minecraft.util.Tuple;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientLanguage.class}, priority=990)
abstract class MixinTranslationStorage
extends Language {
    @Shadow
    @Final
    private Map<String, String> f_118910_;
    private PooledTranslationStorage pool;

    MixinTranslationStorage() {
    }

    private PooledTranslationStorage getPool() {
        if (this.pool == null) {
            this.pool = new PooledTranslationStorage(this.f_118910_);
        }
        return this.pool;
    }

    @Inject(method={"get(Ljava/lang/String;)Ljava/lang/String;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGet(String key, CallbackInfoReturnable<String> info) {
        key = DialogueType.applyFallback(key);
        Tuple<String, String> unpooled = this.getPool().get(key);
        if (unpooled != null) {
            CommonSpeechManager.INSTANCE.lastResolvedKey = (String)unpooled.m_14418_();
            info.setReturnValue((Object)((String)unpooled.m_14419_()));
        } else {
            CommonSpeechManager.INSTANCE.lastResolvedKey = null;
            info.setReturnValue((Object)this.f_118910_.getOrDefault(key, key));
        }
    }

    @Inject(method={"hasTranslation(Ljava/lang/String;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void onHasTranslation(String key, CallbackInfoReturnable<Boolean> info) {
        if (this.getPool().contains(key)) {
            info.setReturnValue((Object)true);
        }
    }
}

