/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.entity.ai;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_5250;
import quilt.net.mca.entity.VillagerEntityMCA;

public class ConversationManager {
    private final VillagerEntityMCA entity;
    private final List<Message> pendingMessages = new LinkedList<Message>();

    public ConversationManager(VillagerEntityMCA entity) {
        this.entity = entity;
    }

    public void addMessage(class_1297 receiver, class_5250 message) {
        this.addMessage(new TextMessage(receiver, message));
    }

    public void addMessage(Message message) {
        this.pendingMessages.add(message);
        message.entity = this.entity;
    }

    public Optional<Message> getCurrentMessage() {
        if (this.pendingMessages.size() > 0) {
            Message message = this.pendingMessages.get(0);
            if (message.stillValid()) {
                return Optional.of(message);
            }
            this.pendingMessages.remove(0);
        }
        return Optional.empty();
    }

    public static class TextMessage
    extends Message {
        private final class_5250 text;

        public TextMessage(class_1297 receiver, class_5250 text) {
            super(receiver);
            this.text = text;
        }

        @Override
        public void deliver() {
            this.entity.sendChatToAllAround(this.text);
            super.deliver();
        }
    }

    public static abstract class Message {
        private final class_1297 receiver;
        VillagerEntityMCA entity;
        public final int validUntil;
        public static final int TIME_VALID = 6000;
        private boolean delivered = false;

        private Message(class_1297 receiver) {
            this.receiver = receiver;
            this.validUntil = receiver.field_6012 + 6000;
        }

        public class_1297 getReceiver() {
            return this.receiver;
        }

        public void deliver() {
            this.delivered = true;
        }

        public boolean stillValid() {
            return !this.delivered && !this.receiver.method_31481() && this.receiver.field_6012 < this.validUntil;
        }
    }

    public static class PhraseText
    extends Message {
        private final String text;

        public PhraseText(class_1297 receiver, String text) {
            super(receiver);
            this.text = text;
        }

        @Override
        public void deliver() {
            this.entity.sendChatToAllAround(this.text, new Object[0]);
            super.deliver();
        }
    }
}

