/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.entity.ai;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.apache.commons.io.IOUtils;
import quilt.net.mca.Config;
import quilt.net.mca.MCA;
import quilt.net.mca.entity.VillagerEntityMCA;
import quilt.net.mca.entity.ai.gpt3Modules.EnvironmentModule;
import quilt.net.mca.entity.ai.gpt3Modules.PersonalityModule;
import quilt.net.mca.entity.ai.gpt3Modules.PlayerModule;
import quilt.net.mca.entity.ai.gpt3Modules.RelationModule;
import quilt.net.mca.entity.ai.gpt3Modules.TraitsModule;
import quilt.net.mca.entity.ai.gpt3Modules.VillageModule;

public class GPT3 {
    private static final int MIN_MEMORY = 100;
    private static final int MAX_MEMORY = 600;
    private static final int MAX_MEMORY_TIME = 54000;
    private static final int CONVERSATION_TIME = 1200;
    private static final int CONVERSATION_DISTANCE = 16;
    private static final Map<UUID, List<String>> memory = new HashMap<UUID, List<String>>();
    private static final Map<UUID, Long> lastInteractions = new HashMap<UUID, Long>();
    private static final Map<UUID, UUID> lastInteraction = new HashMap<UUID, UUID>();

    public static String translate(String phrase) {
        return phrase.replaceAll("_", " ").toLowerCase(Locale.ROOT).replace("mca.", "");
    }

    public static Answer request(String encodedURL) {
        try {
            HttpURLConnection con = (HttpURLConnection)new URL(encodedURL).openConnection();
            con.setRequestProperty("Accept-Charset", StandardCharsets.UTF_8.toString());
            InputStream response = con.getInputStream();
            String body = IOUtils.toString((InputStream)response, (Charset)StandardCharsets.UTF_8);
            JsonObject map = JsonParser.parseString((String)body).getAsJsonObject();
            String answer = map.has("answer") ? map.get("answer").getAsString().trim().replace("\n", "") : "";
            String error = map.has("error") ? map.get("error").getAsString().trim().replace("\n", "") : null;
            return new Answer(answer, error);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Answer(null, "unknown");
        }
    }

    public static Optional<String> answer(class_3222 player, VillagerEntityMCA villager, String msg) {
        try {
            String playerName = player.method_5477().getString();
            String villagerName = villager.method_5477().getString();
            long time = villager.field_6002.method_8510();
            if (time > lastInteractions.getOrDefault(villager.method_5667(), 0L) + 54000L) {
                memory.remove(villager.method_5667());
            }
            lastInteractions.put(villager.method_5667(), time);
            lastInteraction.put(player.method_5667(), villager.method_5667());
            List pastDialogue = memory.computeIfAbsent(villager.method_5667(), key -> new LinkedList());
            int MEMORY = 100 + Math.min(5, Config.getInstance().villagerChatAIIntelligence) * 500 / 5;
            while (pastDialogue.stream().mapToInt(v -> v.length() / 4).sum() > MEMORY) {
                pastDialogue.remove(0);
            }
            pastDialogue.add("$player: " + msg);
            LinkedList<String> input = new LinkedList<String>();
            PersonalityModule.apply(input, villager, player);
            TraitsModule.apply(input, villager, player);
            RelationModule.apply(input, villager, player);
            VillageModule.apply(input, villager, player);
            EnvironmentModule.apply(input, villager, player);
            PlayerModule.apply(input, villager, player);
            input.add("\n\n");
            for (String s2 : pastDialogue) {
                input.add(s2 + "\n");
            }
            input.add("$villager:");
            Map<String, String> variables = Map.of("player", playerName, "villager", villagerName);
            StringBuilder sb = new StringBuilder();
            for (String s3 : input) {
                for (Map.Entry<String, String> entry : variables.entrySet()) {
                    s3 = s3.replaceAll("\\$" + entry.getKey(), entry.getValue());
                }
                sb.append(s3);
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("prompt", sb.toString());
            params.put("player", variables.get("player"));
            params.put("villager", variables.get("villager"));
            String encodedURL = params.keySet().stream().map(key -> key + "=" + URLEncoder.encode((String)params.get(key), StandardCharsets.UTF_8)).collect(Collectors.joining("&", Config.getInstance().villagerChatAIServer + "chat?", ""));
            Answer message = GPT3.request(encodedURL);
            if (message.error == null) {
                pastDialogue.add(villagerName + ": " + message.answer);
                return Optional.ofNullable(message.answer);
            }
            if (message.error.equals("limit")) {
                class_5250 styled = class_2561.method_43471((String)"mca.limit.patreon").method_27694(s -> s.method_10977(class_124.field_1065).method_10958(new class_2558(class_2558.class_2559.field_11749, "https://github.com/Luke100000/minecraft-comes-alive/wiki/GPT3-based-conversations#increase-conversation-limit")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"mca.limit.patreon.hover"))));
                player.method_7353((class_2561)styled, false);
            } else if (message.error.equals("limit_premium")) {
                player.method_7353((class_2561)class_2561.method_43471((String)"mca.limit.premium").method_27692(class_124.field_1061), false);
            } else {
                player.method_7353((class_2561)class_2561.method_43471((String)"mca.ai_broken").method_27692(class_124.field_1061), false);
            }
        }
        catch (Exception e) {
            MCA.LOGGER.error((Object)e);
            player.method_7353((class_2561)class_2561.method_43471((String)"mca.ai_broken").method_27692(class_124.field_1061), false);
        }
        return Optional.empty();
    }

    public static boolean inConversationWith(VillagerEntityMCA villager, class_3222 player) {
        return villager.method_5739((class_1297)player) < 16.0f && villager.field_6002.method_8510() < lastInteractions.getOrDefault(villager.method_5667(), 0L) + 1200L && lastInteraction.getOrDefault(player.method_5667(), class_156.field_25140).equals(villager.method_5667());
    }

    public record Answer(String answer, String error) {
    }
}

