/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import java.lang.reflect.Field;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCClientEventHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.AlarmBlockEntity;
import net.geforcemods.securitycraft.blockentities.IMSBlockEntity;
import net.geforcemods.securitycraft.blockentities.LaserBlockBlockEntity;
import net.geforcemods.securitycraft.blockentities.RiftStabilizerBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecretSignBlockEntity;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.geforcemods.securitycraft.blockentities.TrophySystemBlockEntity;
import net.geforcemods.securitycraft.blockentities.UsernameLoggerBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedSnowyDirtBlock;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.items.CameraMonitorItem;
import net.geforcemods.securitycraft.misc.OverlayToggleHandler;
import net.geforcemods.securitycraft.models.BlockMineModel;
import net.geforcemods.securitycraft.models.BulletModel;
import net.geforcemods.securitycraft.models.DisguisableDynamicBakedModel;
import net.geforcemods.securitycraft.models.IMSBombModel;
import net.geforcemods.securitycraft.models.SecurityCameraModel;
import net.geforcemods.securitycraft.models.SentryModel;
import net.geforcemods.securitycraft.models.SonicSecuritySystemModel;
import net.geforcemods.securitycraft.renderers.BlockPocketManagerRenderer;
import net.geforcemods.securitycraft.renderers.BouncingBettyRenderer;
import net.geforcemods.securitycraft.renderers.BulletRenderer;
import net.geforcemods.securitycraft.renderers.ClaymoreRenderer;
import net.geforcemods.securitycraft.renderers.DisguisableBlockEntityRenderer;
import net.geforcemods.securitycraft.renderers.DisplayCaseRenderer;
import net.geforcemods.securitycraft.renderers.IMSBombRenderer;
import net.geforcemods.securitycraft.renderers.KeypadChestRenderer;
import net.geforcemods.securitycraft.renderers.ProjectorRenderer;
import net.geforcemods.securitycraft.renderers.ReinforcedPistonHeadRenderer;
import net.geforcemods.securitycraft.renderers.RetinalScannerRenderer;
import net.geforcemods.securitycraft.renderers.SecretSignRenderer;
import net.geforcemods.securitycraft.renderers.SecurityCameraRenderer;
import net.geforcemods.securitycraft.renderers.SentryRenderer;
import net.geforcemods.securitycraft.renderers.SonicSecuritySystemRenderer;
import net.geforcemods.securitycraft.renderers.TrophySystemRenderer;
import net.geforcemods.securitycraft.screen.AlarmScreen;
import net.geforcemods.securitycraft.screen.BlockChangeDetectorScreen;
import net.geforcemods.securitycraft.screen.BlockPocketManagerScreen;
import net.geforcemods.securitycraft.screen.BlockReinforcerScreen;
import net.geforcemods.securitycraft.screen.BriefcaseInventoryScreen;
import net.geforcemods.securitycraft.screen.BriefcasePasswordScreen;
import net.geforcemods.securitycraft.screen.BriefcaseSetupScreen;
import net.geforcemods.securitycraft.screen.CameraMonitorScreen;
import net.geforcemods.securitycraft.screen.CheckPasswordScreen;
import net.geforcemods.securitycraft.screen.CustomizeBlockScreen;
import net.geforcemods.securitycraft.screen.DisguiseModuleScreen;
import net.geforcemods.securitycraft.screen.EditModuleScreen;
import net.geforcemods.securitycraft.screen.IMSScreen;
import net.geforcemods.securitycraft.screen.InventoryScannerScreen;
import net.geforcemods.securitycraft.screen.KeyChangerScreen;
import net.geforcemods.securitycraft.screen.KeycardReaderScreen;
import net.geforcemods.securitycraft.screen.KeypadBlastFurnaceScreen;
import net.geforcemods.securitycraft.screen.KeypadFurnaceScreen;
import net.geforcemods.securitycraft.screen.KeypadSmokerScreen;
import net.geforcemods.securitycraft.screen.LaserScreen;
import net.geforcemods.securitycraft.screen.MineRemoteAccessToolScreen;
import net.geforcemods.securitycraft.screen.ProjectorScreen;
import net.geforcemods.securitycraft.screen.SCManualScreen;
import net.geforcemods.securitycraft.screen.SSSItemScreen;
import net.geforcemods.securitycraft.screen.SentryRemoteAccessToolScreen;
import net.geforcemods.securitycraft.screen.SetPasswordScreen;
import net.geforcemods.securitycraft.screen.SonicSecuritySystemScreen;
import net.geforcemods.securitycraft.screen.ToggleListScreen;
import net.geforcemods.securitycraft.screen.UsernameLoggerScreen;
import net.geforcemods.securitycraft.util.BlockEntityRenderDelegate;
import net.geforcemods.securitycraft.util.Reinforced;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.SignEditScreen;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="securitycraft", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientHandler {
    public static final ModelLayerLocation BULLET_LOCATION = new ModelLayerLocation(new ResourceLocation("securitycraft", "bullet"), "main");
    public static final ModelLayerLocation IMS_BOMB_LOCATION = new ModelLayerLocation(new ResourceLocation("securitycraft", "ims_bomb"), "main");
    public static final ModelLayerLocation DISPLAY_CASE_LOCATION = new ModelLayerLocation(new ResourceLocation("securitycraft", "display_case"), "main");
    public static final ModelLayerLocation GLOW_DISPLAY_CASE_LOCATION = new ModelLayerLocation(new ResourceLocation("securitycraft", "glow_display_case"), "main");
    public static final ModelLayerLocation SENTRY_LOCATION = new ModelLayerLocation(new ResourceLocation("securitycraft", "sentry"), "main");
    public static final ModelLayerLocation SECURITY_CAMERA_LOCATION = new ModelLayerLocation(new ResourceLocation("securitycraft", "security_camera"), "main");
    public static final ModelLayerLocation SONIC_SECURITY_SYSTEM_LOCATION = new ModelLayerLocation(new ResourceLocation("securitycraft", "sonic_security_system"), "main");
    public static final BlockEntityRenderDelegate DISGUISED_BLOCK_RENDER_DELEGATE = new BlockEntityRenderDelegate();
    public static final BlockEntityRenderDelegate PROJECTOR_RENDER_DELEGATE = new BlockEntityRenderDelegate();
    public static IGuiOverlay cameraOverlay;
    public static IGuiOverlay hotbarBindOverlay;
    private static Map<Block, Integer> blocksWithReinforcedTint;
    private static Map<Block, Integer> blocksWithCustomTint;
    private static LazyOptional<Block[]> disguisableBlocks;

    @SubscribeEvent
    public static void onModelBakingCompleted(ModelEvent.BakingCompleted event) {
        String[] mines = new String[]{"ancient_debris", "blast_furnace", "coal_ore", "cobbled_deepslate", "cobblestone", "copper_ore", "deepslate", "deepslate_coal_ore", "deepslate_copper_ore", "deepslate_diamond_ore", "deepslate_emerald_ore", "deepslate_gold_ore", "deepslate_iron_ore", "deepslate_lapis_ore", "deepslate_redstone_ore", "diamond_ore", "dirt", "emerald_ore", "gravel", "gold_ore", "gilded_blackstone", "furnace", "iron_ore", "lapis_ore", "nether_gold_ore", "redstone_ore", "sand", "smoker", "stone"};
        Map modelRegistry = event.getModels();
        for (Block block : (Block[])disguisableBlocks.orElse(null)) {
            for (BlockState state : block.m_49965_().m_61056_()) {
                ClientHandler.registerDisguisedModel(modelRegistry, Utils.getRegistryName(block), state.m_61148_().entrySet().stream().map(StateHolder.f_61110_).collect(Collectors.joining(",")));
            }
        }
        for (String string : mines) {
            ClientHandler.registerBlockMineModel(event, new ResourceLocation("securitycraft", string.replace("_ore", "") + "_mine"), new ResourceLocation(string));
        }
        ClientHandler.registerBlockMineModel(event, new ResourceLocation("securitycraft", "quartz_mine"), new ResourceLocation("nether_quartz_ore"));
    }

    private static void registerDisguisedModel(Map<ResourceLocation, BakedModel> modelRegistry, ResourceLocation rl, String stateString) {
        ModelResourceLocation mrl = new ModelResourceLocation(rl, stateString);
        modelRegistry.put((ResourceLocation)mrl, (BakedModel)new DisguisableDynamicBakedModel(modelRegistry.get(mrl)));
    }

    private static void registerBlockMineModel(ModelEvent.BakingCompleted event, ResourceLocation mineRl, ResourceLocation realBlockRl) {
        ModelResourceLocation mineMrl = new ModelResourceLocation(mineRl, "inventory");
        event.getModels().put(mineMrl, new BlockMineModel((BakedModel)event.getModels().get(new ModelResourceLocation(realBlockRl, "inventory")), (BakedModel)event.getModels().get(mineMrl)));
    }

    @SubscribeEvent
    public static void onTextureStitchPre(TextureStitchEvent.Pre event) {
        if (event.getAtlas().m_118330_().equals((Object)Sheets.f_110740_)) {
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/active"));
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/inactive"));
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/left_active"));
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/left_inactive"));
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/right_active"));
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/right_inactive"));
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/christmas"));
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/christmas_left"));
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/christmas_right"));
        }
    }

    @SubscribeEvent
    public static void onFMLClientSetup(FMLClientSetupEvent event) {
        RenderType translucent = RenderType.m_110466_();
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)SCContent.FAKE_WATER.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)SCContent.FLOWING_FAKE_WATER.get()), (RenderType)translucent);
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)SCContent.BLOCK_REINFORCER_MENU.get()), BlockReinforcerScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)SCContent.BRIEFCASE_INVENTORY_MENU.get()), BriefcaseInventoryScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)SCContent.CUSTOMIZE_BLOCK_MENU.get()), CustomizeBlockScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)SCContent.DISGUISE_MODULE_MENU.get()), DisguiseModuleScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)SCContent.INVENTORY_SCANNER_MENU.get()), InventoryScannerScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)SCContent.KEYPAD_FURNACE_MENU.get()), KeypadFurnaceScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)SCContent.KEYPAD_SMOKER_MENU.get()), KeypadSmokerScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)SCContent.KEYPAD_BLAST_FURNACE_MENU.get()), KeypadBlastFurnaceScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)SCContent.KEYCARD_READER_MENU.get()), KeycardReaderScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)SCContent.BLOCK_POCKET_MANAGER_MENU.get()), BlockPocketManagerScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)SCContent.PROJECTOR_MENU.get()), ProjectorScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)SCContent.BLOCK_CHANGE_DETECTOR_MENU.get()), BlockChangeDetectorScreen::new);
        });
    }

    @SubscribeEvent
    public static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
        cameraOverlay = SCClientEventHandler::cameraOverlay;
        event.registerAboveAll("camera_overlay", cameraOverlay);
        hotbarBindOverlay = SCClientEventHandler::hotbarBindOverlay;
        event.registerAboveAll("hotbar_bind_overlay", hotbarBindOverlay);
        OverlayToggleHandler.disable(cameraOverlay);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)SCContent.BOUNCING_BETTY_ENTITY.get(), BouncingBettyRenderer::new);
        event.registerEntityRenderer((EntityType)SCContent.IMS_BOMB_ENTITY.get(), IMSBombRenderer::new);
        event.registerEntityRenderer((EntityType)SCContent.SECURITY_CAMERA_ENTITY.get(), NoopRenderer::new);
        event.registerEntityRenderer((EntityType)SCContent.SENTRY_ENTITY.get(), SentryRenderer::new);
        event.registerEntityRenderer((EntityType)SCContent.BULLET_ENTITY.get(), BulletRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.BLOCK_POCKET_MANAGER_BLOCK_ENTITY.get(), BlockPocketManagerRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.CLAYMORE_BLOCK_ENTITY.get(), ClaymoreRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYPAD_CHEST_BLOCK_ENTITY.get(), KeypadChestRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.DISPLAY_CASE_BLOCK_ENTITY.get(), ctx -> new DisplayCaseRenderer(ctx, false));
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.GLOW_DISPLAY_CASE_BLOCK_ENTITY.get(), ctx -> new DisplayCaseRenderer(ctx, true));
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.PROJECTOR_BLOCK_ENTITY.get(), ProjectorRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.REINFORCED_PISTON_BLOCK_ENTITY.get(), ReinforcedPistonHeadRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.RETINAL_SCANNER_BLOCK_ENTITY.get(), RetinalScannerRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.SECURITY_CAMERA_BLOCK_ENTITY.get(), SecurityCameraRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.SECRET_SIGN_BLOCK_ENTITY.get(), SecretSignRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.SONIC_SECURITY_SYSTEM_BLOCK_ENTITY.get(), SonicSecuritySystemRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.TROPHY_SYSTEM_BLOCK_ENTITY.get(), TrophySystemRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.BLOCK_CHANGE_DETECTOR_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.CAGE_TRAP_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.DISGUISABLE_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.INVENTORY_SCANNER_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYCARD_READER_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYPAD_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYPAD_BARREL_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYPAD_BLAST_FURNACE_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYPAD_FURNACE_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYPAD_SMOKER_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.LASER_BLOCK_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.PROTECTO_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.RIFT_STABILIZER_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.USERNAME_LOGGER_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(BULLET_LOCATION, BulletModel::createLayer);
        event.registerLayerDefinition(IMS_BOMB_LOCATION, IMSBombModel::createLayer);
        event.registerLayerDefinition(DISPLAY_CASE_LOCATION, DisplayCaseRenderer::createModelLayer);
        event.registerLayerDefinition(GLOW_DISPLAY_CASE_LOCATION, DisplayCaseRenderer::createModelLayer);
        event.registerLayerDefinition(SENTRY_LOCATION, SentryModel::createLayer);
        event.registerLayerDefinition(SECURITY_CAMERA_LOCATION, SecurityCameraModel::createLayer);
        event.registerLayerDefinition(SONIC_SECURITY_SYSTEM_LOCATION, SonicSecuritySystemModel::createLayer);
    }

    private static void initTint() {
        for (Field field : SCContent.class.getFields()) {
            if (!field.isAnnotationPresent(Reinforced.class)) continue;
            try {
                Block block = (Block)((RegistryObject)field.get(null)).get();
                int customTint = field.getAnnotation(Reinforced.class).customTint();
                if (field.getAnnotation(Reinforced.class).hasReinforcedTint()) {
                    blocksWithReinforcedTint.put(block, customTint);
                    continue;
                }
                if (customTint == 0xFFFFFF) continue;
                blocksWithCustomTint.put(block, customTint);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        int crystalQuartzTint = 1422242;
        blocksWithReinforcedTint.put((Block)SCContent.BLOCK_POCKET_MANAGER.get(), crystalQuartzTint);
        blocksWithReinforcedTint.put((Block)SCContent.BLOCK_POCKET_WALL.get(), crystalQuartzTint);
        blocksWithCustomTint.put((Block)SCContent.CRYSTAL_QUARTZ_SLAB.get(), crystalQuartzTint);
        blocksWithCustomTint.put((Block)SCContent.SMOOTH_CRYSTAL_QUARTZ.get(), crystalQuartzTint);
        blocksWithCustomTint.put((Block)SCContent.CHISELED_CRYSTAL_QUARTZ.get(), crystalQuartzTint);
        blocksWithCustomTint.put((Block)SCContent.CRYSTAL_QUARTZ_BLOCK.get(), crystalQuartzTint);
        blocksWithCustomTint.put((Block)SCContent.CRYSTAL_QUARTZ_BRICKS.get(), crystalQuartzTint);
        blocksWithCustomTint.put((Block)SCContent.CRYSTAL_QUARTZ_PILLAR.get(), crystalQuartzTint);
        blocksWithCustomTint.put((Block)SCContent.CRYSTAL_QUARTZ_STAIRS.get(), crystalQuartzTint);
        blocksWithCustomTint.put((Block)SCContent.SMOOTH_CRYSTAL_QUARTZ_SLAB.get(), crystalQuartzTint);
        blocksWithCustomTint.put((Block)SCContent.SMOOTH_CRYSTAL_QUARTZ_STAIRS.get(), crystalQuartzTint);
    }

    @SubscribeEvent
    public static void onRegisterColorHandlersBlock(RegisterColorHandlersEvent.Block event) {
        ClientHandler.initTint();
        blocksWithReinforcedTint.forEach((block, tint) -> event.register((state, world, pos, tintIndex) -> {
            if (tintIndex == 0) {
                return ClientHandler.mixWithReinforcedTintIfEnabled(tint);
            }
            return 0xFFFFFF;
        }, new Block[]{block}));
        blocksWithCustomTint.forEach((block, tint) -> event.register((state, world, pos, tintIndex) -> {
            if (tintIndex == 0) {
                return tint;
            }
            return 0xFFFFFF;
        }, new Block[]{block}));
        event.register((state, world, pos, tintIndex) -> {
            DisguisableBlock disguisedBlock;
            Block blockFromItem;
            BlockState defaultBlockState;
            Block block = state.m_60734_();
            if (block instanceof DisguisableBlock && !(defaultBlockState = (blockFromItem = Block.m_49814_((Item)(disguisedBlock = (DisguisableBlock)block).getDisguisedStack((BlockGetter)world, pos).m_41720_())).m_49966_()).m_60795_() && !(blockFromItem instanceof DisguisableBlock)) {
                return Minecraft.m_91087_().m_91298_().m_92577_(defaultBlockState, world, pos, tintIndex);
            }
            return 0xFFFFFF;
        }, (Block[])disguisableBlocks.orElse(null));
        event.register((state, world, pos, tintIndex) -> {
            if (tintIndex == 1 && !((Boolean)state.m_61143_((Property)ReinforcedSnowyDirtBlock.f_56637_)).booleanValue()) {
                int grassTint = world != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)world, (BlockPos)pos) : GrassColor.m_46415_((double)0.5, (double)1.0);
                return ClientHandler.mixWithReinforcedTintIfEnabled(grassTint);
            }
            return (Integer)ConfigHandler.CLIENT.reinforcedBlockTintColor.get();
        }, new Block[]{(Block)SCContent.REINFORCED_GRASS_BLOCK.get()});
        event.register((state, world, pos, tintIndex) -> {
            if (tintIndex == 1) {
                return world != null && pos != null ? BiomeColors.m_108811_((BlockAndTintGetter)world, (BlockPos)pos) : -1;
            }
            return (Integer)ConfigHandler.CLIENT.reinforcedBlockTintColor.get();
        }, new Block[]{(Block)SCContent.REINFORCED_WATER_CAULDRON.get()});
    }

    @SubscribeEvent
    public static void onRegisterColorHandlersItem(RegisterColorHandlersEvent.Item event) {
        blocksWithReinforcedTint.forEach((item, tint) -> event.register((stack, tintIndex) -> {
            if (tintIndex == 0) {
                return ClientHandler.mixWithReinforcedTintIfEnabled(tint);
            }
            return 0xFFFFFF;
        }, new ItemLike[]{item}));
        blocksWithCustomTint.forEach((item, tint) -> event.register((stack, tintIndex) -> {
            if (tintIndex == 0) {
                return tint;
            }
            return 0xFFFFFF;
        }, new ItemLike[]{item}));
        event.register((stack, tintIndex) -> {
            if (tintIndex == 0) {
                DyeableLeatherItem item = (DyeableLeatherItem)stack.m_41720_();
                if (item.m_41113_(stack)) {
                    return item.m_41121_(stack);
                }
                return 0x333333;
            }
            return -1;
        }, new ItemLike[]{(ItemLike)SCContent.BRIEFCASE.get()});
        event.register((stack, tintIndex) -> {
            if (tintIndex == 1) {
                int grassTint = GrassColor.m_46415_((double)0.5, (double)1.0);
                return ClientHandler.mixWithReinforcedTintIfEnabled(grassTint);
            }
            return (Integer)ConfigHandler.CLIENT.reinforcedBlockTintColor.get();
        }, new ItemLike[]{(ItemLike)SCContent.REINFORCED_GRASS_BLOCK.get()});
        blocksWithReinforcedTint = null;
        blocksWithCustomTint = null;
    }

    private static int mixWithReinforcedTintIfEnabled(int tint1) {
        boolean tintReinforcedBlocks = (Boolean)ConfigHandler.SERVER.forceReinforcedBlockTint.get() != false ? (Boolean)ConfigHandler.SERVER.reinforcedBlockTint.get() : (Boolean)ConfigHandler.CLIENT.reinforcedBlockTint.get();
        return tintReinforcedBlocks ? ClientHandler.mixTints(tint1, (Integer)ConfigHandler.CLIENT.reinforcedBlockTintColor.get()) : tint1;
    }

    private static int mixTints(int tint1, int tint2) {
        int red = tint1 >> 16 & 0xFF;
        int green = tint1 >> 8 & 0xFF;
        int blue = tint1 & 0xFF;
        red = (int)((float)red * ((float)(tint2 >> 16 & 0xFF) / 255.0f));
        green = (int)((float)green * ((float)(tint2 >> 8 & 0xFF) / 255.0f));
        blue = (int)((float)blue * ((float)(tint2 & 0xFF) / 255.0f));
        return ((red << 8) + green << 8) + blue;
    }

    public static Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    public static Level getClientLevel() {
        return Minecraft.m_91087_().f_91073_;
    }

    public static void displayMRATScreen(ItemStack stack) {
        Minecraft.m_91087_().m_91152_((Screen)new MineRemoteAccessToolScreen(stack));
    }

    public static void displaySRATScreen(ItemStack stack, int viewDistance) {
        Minecraft.m_91087_().m_91152_((Screen)new SentryRemoteAccessToolScreen(stack, viewDistance));
    }

    public static void displayEditModuleScreen(ItemStack stack) {
        Minecraft.m_91087_().m_91152_((Screen)new EditModuleScreen(stack));
    }

    public static void displayCameraMonitorScreen(Inventory inv, CameraMonitorItem item, CompoundTag stackTag) {
        Minecraft.m_91087_().m_91152_((Screen)new CameraMonitorScreen(inv, item, stackTag));
    }

    public static void displaySCManualScreen() {
        Minecraft.m_91087_().m_91152_((Screen)new SCManualScreen());
    }

    public static void displayEditSecretSignScreen(SecretSignBlockEntity be) {
        Minecraft.m_91087_().m_91152_((Screen)new SignEditScreen((SignBlockEntity)be, Minecraft.m_91087_().m_167974_()));
    }

    public static void displaySonicSecuritySystemScreen(SonicSecuritySystemBlockEntity be) {
        Minecraft.m_91087_().m_91152_((Screen)new SonicSecuritySystemScreen(be));
    }

    public static void displayBriefcasePasswordScreen(Component title) {
        Minecraft.m_91087_().m_91152_((Screen)new BriefcasePasswordScreen(title));
    }

    public static void displayBriefcaseSetupScreen(Component title) {
        Minecraft.m_91087_().m_91152_((Screen)new BriefcaseSetupScreen(title));
    }

    public static void displayUsernameLoggerScreen(Level level, BlockPos pos) {
        BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(pos);
        if (blockEntity instanceof UsernameLoggerBlockEntity) {
            UsernameLoggerBlockEntity be = (UsernameLoggerBlockEntity)blockEntity;
            if (be.isDisabled()) {
                ClientHandler.getClientPlayer().m_5661_((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            } else {
                Minecraft.m_91087_().m_91152_((Screen)new UsernameLoggerScreen(be));
            }
        }
    }

    public static void displayIMSScreen(IMSBlockEntity be) {
        Minecraft.m_91087_().m_91152_((Screen)new IMSScreen(be));
    }

    public static void displayUniversalKeyChangerScreen(BlockEntity be) {
        Minecraft.m_91087_().m_91152_((Screen)new KeyChangerScreen(be));
    }

    public static void displayTrophySystemScreen(TrophySystemBlockEntity be) {
        Minecraft.m_91087_().m_91152_(new ToggleListScreen(be, be.m_7755_(), (Component)Utils.localize("gui.securitycraft:trophy_system.targetableProjectiles", new Object[0]), (Component)Utils.localize("gui.securitycraft:trophy_system.moduleRequired", new Object[0]), (Component)Utils.localize("gui.securitycraft:trophy_system.toggle", new Object[0])));
    }

    public static void displayCheckPasswordScreen(BlockEntity be) {
        Component component;
        if (be instanceof Nameable) {
            Nameable nameable = (Nameable)be;
            component = nameable.m_5446_();
        } else {
            component = Component.m_237115_((String)be.m_58900_().m_60734_().m_7705_());
        }
        Component displayName = component;
        Minecraft.m_91087_().m_91152_((Screen)new CheckPasswordScreen(be, displayName));
    }

    public static void displaySetPasswordScreen(BlockEntity be) {
        Component component;
        if (be instanceof Nameable) {
            Nameable nameable = (Nameable)be;
            component = nameable.m_5446_();
        } else {
            component = Component.m_237115_((String)be.m_58900_().m_60734_().m_7705_());
        }
        Component displayName = component;
        Minecraft.m_91087_().m_91152_((Screen)new SetPasswordScreen(be, displayName));
    }

    public static void displaySSSItemScreen(ItemStack stack) {
        Minecraft.m_91087_().m_91152_((Screen)new SSSItemScreen(stack));
    }

    public static void displayRiftStabilizerScreen(RiftStabilizerBlockEntity be) {
        Minecraft.m_91087_().m_91152_(new ToggleListScreen<RiftStabilizerBlockEntity.TeleportationType>(be, be.m_7755_(), (Component)Utils.localize("gui.securitycraft:rift_stabilizer.teleportationTypes", new Object[0]), (Component)Utils.localize("gui.securitycraft:rift_stabilizer.moduleRequired", new Object[0]), (Component)Utils.localize("gui.securitycraft:rift_stabilizer.toggle", new Object[0])));
    }

    public static void displayLaserScreen(LaserBlockBlockEntity be, EnumMap<Direction, Boolean> sideConfig) {
        Minecraft.m_91087_().m_91152_((Screen)new LaserScreen(be, sideConfig));
    }

    public static void displayAlarmScreen(AlarmBlockEntity be) {
        Minecraft.m_91087_().m_91152_((Screen)new AlarmScreen(be, be.getSound().m_11660_()));
    }

    public static void refreshModelData(BlockEntity be) {
        BlockPos pos = be.m_58899_();
        Minecraft.m_91087_().f_91073_.getModelDataManager().requestRefresh(be);
        Minecraft.m_91087_().f_91060_.m_109494_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static boolean isPlayerMountedOnCamera() {
        return Minecraft.m_91087_().f_91075_ instanceof SecurityCamera;
    }

    public static void putDisguisedBeRenderer(BlockEntity disguisableBlockEntity, ItemStack stack) {
        DISGUISED_BLOCK_RENDER_DELEGATE.putDelegateFor(disguisableBlockEntity, NbtUtils.m_129241_((CompoundTag)stack.m_41784_().m_128469_("SavedState")));
    }

    static {
        blocksWithReinforcedTint = new HashMap<Block, Integer>();
        blocksWithCustomTint = new HashMap<Block, Integer>();
        disguisableBlocks = LazyOptional.of(() -> new Block[]{(Block)SCContent.BLOCK_CHANGE_DETECTOR.get(), (Block)SCContent.CAGE_TRAP.get(), (Block)SCContent.INVENTORY_SCANNER.get(), (Block)SCContent.KEYCARD_READER.get(), (Block)SCContent.KEYPAD.get(), (Block)SCContent.KEYPAD_BARREL.get(), (Block)SCContent.KEYPAD_BLAST_FURNACE.get(), (Block)SCContent.KEYPAD_FURNACE.get(), (Block)SCContent.KEYPAD_SMOKER.get(), (Block)SCContent.LASER_BLOCK.get(), (Block)SCContent.PROJECTOR.get(), (Block)SCContent.PROTECTO.get(), (Block)SCContent.RETINAL_SCANNER.get(), (Block)SCContent.RIFT_STABILIZER.get(), (Block)SCContent.SENTRY_DISGUISE.get(), (Block)SCContent.TROPHY_SYSTEM.get(), (Block)SCContent.USERNAME_LOGGER.get()});
    }
}

