/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.blockentities.BlockChangeDetectorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class SyncBlockChangeDetector {
    private BlockPos pos;
    private BlockChangeDetectorBlockEntity.DetectionMode mode;
    private boolean showHighlights;
    private int color;

    public SyncBlockChangeDetector() {
    }

    public SyncBlockChangeDetector(BlockPos pos, BlockChangeDetectorBlockEntity.DetectionMode mode, boolean showHighlights, int color) {
        this.pos = pos;
        this.mode = mode;
        this.showHighlights = showHighlights;
        this.color = color;
    }

    public static void encode(SyncBlockChangeDetector message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
        buf.m_130068_((Enum)message.mode);
        buf.writeBoolean(message.showHighlights);
        buf.writeInt(message.color);
    }

    public static SyncBlockChangeDetector decode(FriendlyByteBuf buf) {
        SyncBlockChangeDetector message = new SyncBlockChangeDetector();
        message.pos = buf.m_130135_();
        message.mode = (BlockChangeDetectorBlockEntity.DetectionMode)buf.m_130066_(BlockChangeDetectorBlockEntity.DetectionMode.class);
        message.showHighlights = buf.readBoolean();
        message.color = buf.readInt();
        return message;
    }

    public static void onMessage(SyncBlockChangeDetector message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockChangeDetectorBlockEntity be;
            Level level = ((NetworkEvent.Context)ctx.get()).getSender().f_19853_;
            BlockPos pos = message.pos;
            BlockEntity patt1736$temp = level.m_7702_(pos);
            if (patt1736$temp instanceof BlockChangeDetectorBlockEntity && (be = (BlockChangeDetectorBlockEntity)patt1736$temp).isOwnedBy((Player)((NetworkEvent.Context)ctx.get()).getSender())) {
                BlockState state = level.m_8055_(pos);
                be.setMode(message.mode);
                be.showHighlights(message.showHighlights);
                be.setColor(message.color);
                be.m_6596_();
                level.m_7260_(pos, state, state, 2);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

