/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.config;

import de.maxhenkel.voicechat.configbuilder.Config;
import de.maxhenkel.voicechat.configbuilder.ConfigBuilder;
import de.maxhenkel.voicechat.configbuilder.ConfigEntry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;

public class ForgeConfigBuilderWrapper
implements ConfigBuilder {
    private final ForgeConfigSpec.Builder builder;
    private final String[] path;

    public ForgeConfigBuilderWrapper(ForgeConfigSpec.Builder builder, String ... path) {
        this.builder = builder;
        this.path = path;
    }

    @Override
    public ConfigBuilder header(String ... comments) {
        return this;
    }

    @Override
    public ConfigEntry<Boolean> booleanEntry(String key, boolean def, String ... comments) {
        return new ForgeConfigEntry<Boolean>(key, comments, (ForgeConfigSpec.ConfigValue<Boolean>)this.builder.comment(comments).worldRestart().define(this.makePath(key), def));
    }

    @Override
    public ConfigEntry<Integer> integerEntry(String key, int def, int min, int max, String ... comments) {
        return new ForgeConfigEntry<Integer>(key, comments, (ForgeConfigSpec.ConfigValue<Integer>)this.builder.comment(comments).worldRestart().defineInRange(this.makePath(key), def, min, max));
    }

    @Override
    public ConfigEntry<Double> doubleEntry(String key, double def, double min, double max, String ... comments) {
        return new ForgeConfigEntry<Double>(key, comments, (ForgeConfigSpec.ConfigValue<Double>)this.builder.comment(comments).worldRestart().defineInRange(this.makePath(key), def, min, max));
    }

    @Override
    public ConfigEntry<String> stringEntry(String key, String def, String ... comments) {
        return new ForgeConfigEntry<String>(key, comments, this.builder.comment(comments).worldRestart().define(this.makePath(key), (Object)def));
    }

    @Override
    public ConfigEntry<List<Integer>> integerListEntry(String key, List<Integer> def, String ... comments) {
        return new ForgeConfigEntry<List<Integer>>(key, comments, this.builder.comment(comments).worldRestart().define(this.makePath(key), def));
    }

    @Override
    public <E extends Enum<E>> ConfigEntry<E> enumEntry(String key, E def, String ... comments) {
        return new ForgeConfigEntry(key, comments, this.builder.comment(comments).worldRestart().defineEnum(this.makePath(key), def));
    }

    private String makePath(String key) {
        ArrayList<String> pathList = new ArrayList<String>(Arrays.asList(this.path));
        pathList.add(key);
        return String.join((CharSequence)".", pathList);
    }

    private static Config fromBuilder(ForgeConfigSpec.Builder builder) {
        Map entries;
        try {
            Field field = builder.getClass().getDeclaredField("storage");
            com.electronwill.nightconfig.core.Config config = (com.electronwill.nightconfig.core.Config)field.get(builder);
            entries = config.valueMap();
        }
        catch (Exception e2) {
            entries = new HashMap();
        }
        Map finalEntries = entries.entrySet().stream().collect(HashMap::new, (m, e) -> m.put((String)e.getKey(), e.getValue().toString()), HashMap::putAll);
        return () -> finalEntries;
    }

    public class ForgeConfigEntry<T>
    implements ConfigEntry<T> {
        private final String[] comments;
        private final ForgeConfigSpec.ConfigValue<T> value;
        private final String key;

        public ForgeConfigEntry(String key, String[] comments, ForgeConfigSpec.ConfigValue<T> value) {
            this.key = key;
            this.comments = comments;
            this.value = value;
        }

        public ForgeConfigSpec.ConfigValue<T> getValue() {
            return this.value;
        }

        @Override
        public ConfigEntry<T> comment(String ... comments) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getComments() {
            return this.comments;
        }

        @Override
        public T get() {
            return (T)this.value.get();
        }

        @Override
        public ConfigEntry<T> set(T value) {
            this.value.set(value);
            return this;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public ConfigEntry<T> reset() {
            this.value.set(this.value.getDefault());
            return this;
        }

        @Override
        public ConfigEntry<T> save() {
            this.value.save();
            return this;
        }

        @Override
        public ConfigEntry<T> saveSync() {
            this.value.save();
            return this;
        }

        @Override
        public T getDefault() {
            return (T)this.value.getDefault();
        }

        @Override
        public Config getConfig() {
            return ForgeConfigBuilderWrapper.fromBuilder(ForgeConfigBuilderWrapper.this.builder);
        }
    }
}

