/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.okzoomer.network.packet;

import com.matyrobbrt.okzoomer.network.OkZoomerNetwork;
import com.matyrobbrt.okzoomer.network.packet.Packet;
import com.matyrobbrt.okzoomer.utils.ZoomUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public record ForceZoomDivisorPacket(double min, double max) implements Packet
{
    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeDouble(this.min());
        buf.writeDouble(this.max());
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        if (this.min <= 0.0 || this.max <= 0.0) {
            ZoomUtils.LOGGER.info("This server has attempted to set invalid divisor values! (min {}, max {})", (Object)this.min, (Object)this.max);
        } else if (this.min != 1.0 && this.max != 50.0) {
            ZoomUtils.LOGGER.info("This server has set the zoom divisors to minimum {} and maximum {}", (Object)this.min, (Object)this.max);
            OkZoomerNetwork.maximumZoomDivisor = this.max;
            OkZoomerNetwork.minimumZoomDivisor = this.min;
            OkZoomerNetwork.forceZoomDivisors = true;
            OkZoomerNetwork.checkRestrictions();
            OkZoomerNetwork.configureZoomInstance();
        }
    }

    public static ForceZoomDivisorPacket decode(FriendlyByteBuf buf) {
        return new ForceZoomDivisorPacket(buf.readDouble(), buf.readDouble());
    }
}

