/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.okzoomer.zoom;

import com.matyrobbrt.okzoomer.api.ZoomOverlay;
import com.matyrobbrt.okzoomer.config.ClientConfig;
import com.matyrobbrt.okzoomer.config.ConfigEnums;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ZoomerZoomOverlay
implements ZoomOverlay {
    private static final ResourceLocation OVERLAY_ID = new ResourceLocation("okzoomer", "zoom_overlay");
    private ResourceLocation textureId;
    private boolean active;
    private boolean zoomActive;
    private double divisor;
    private final Minecraft client;
    public float zoomOverlayAlpha = 0.0f;
    public float lastZoomOverlayAlpha = 0.0f;

    public ZoomerZoomOverlay(ResourceLocation textureId) {
        this.textureId = textureId;
        this.active = false;
        this.client = Minecraft.m_91087_();
    }

    @Override
    public ResourceLocation getId() {
        return OVERLAY_ID;
    }

    @Override
    public boolean getActive() {
        if (this.client.f_91066_.f_92062_ && ((Boolean)ClientConfig.DISABLE_OVERLAY_NO_HUD.get()).booleanValue()) {
            return false;
        }
        return this.active;
    }

    @Override
    public void renderOverlay() {
        RenderSystem.m_69465_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.zoomOverlayAlpha);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.textureId);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_5483_(0.0, (double)this.client.m_91268_().m_85446_(), -90.0).m_7421_(0.0f, 1.0f).m_5752_();
        bufferBuilder.m_5483_((double)this.client.m_91268_().m_85445_(), (double)this.client.m_91268_().m_85446_(), -90.0).m_7421_(1.0f, 1.0f).m_5752_();
        bufferBuilder.m_5483_((double)this.client.m_91268_().m_85445_(), 0.0, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
        bufferBuilder.m_5483_(0.0, 0.0, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69482_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void tick(boolean active, double divisor, double transitionMultiplier) {
        this.divisor = divisor;
        this.zoomActive = active;
        if (!active && this.zoomOverlayAlpha == 0.0f || active) {
            this.active = active;
        }
        float zoomMultiplier = this.zoomActive ? 1.0f : 0.0f;
        this.lastZoomOverlayAlpha = this.zoomOverlayAlpha;
        if (((ConfigEnums.ZoomTransitionOptions)((Object)ClientConfig.ZOOM_TRANSITION.get())).equals((Object)ConfigEnums.ZoomTransitionOptions.SMOOTH)) {
            this.zoomOverlayAlpha = (float)((double)this.zoomOverlayAlpha + (double)(zoomMultiplier - this.zoomOverlayAlpha) * (Double)ClientConfig.SMOOTH_MULTIPLIER.get());
        } else if (((ConfigEnums.ZoomTransitionOptions)((Object)ClientConfig.ZOOM_TRANSITION.get())).equals((Object)ConfigEnums.ZoomTransitionOptions.LINEAR)) {
            double linearStep = Mth.m_14008_((double)(1.0 / this.divisor), (double)((Double)ClientConfig.MINIMUM_LINEAR_STEP.get()), (double)((Double)ClientConfig.MAXIMUM_LINEAR_STEP.get()));
            this.zoomOverlayAlpha = Mth.m_14121_((float)this.zoomOverlayAlpha, (float)zoomMultiplier, (float)((float)linearStep));
        }
    }
}

