/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.feature.core;

import com.mojang.blaze3d.vertex.BufferBuilder;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.util.Set;
import net.raphimc.immediatelyfast.injection.interfaces.IBufferBuilder;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class BufferBuilderPool {
    private static final int INITIAL_SIZE = 256;
    private static final Set<Pair<BufferBuilder, Long>> POOL = new ReferenceArraySet(256);
    private static long lastCleanup = 0L;

    private BufferBuilderPool() {
    }

    public static BufferBuilder get() {
        if (lastCleanup < System.currentTimeMillis() - 5000L) {
            lastCleanup = System.currentTimeMillis();
            BufferBuilderPool.cleanup();
        }
        for (Pair<BufferBuilder, Long> entry : POOL) {
            BufferBuilder bufferBuilder = (BufferBuilder)entry.getKey();
            if (bufferBuilder.m_85732_() || ((IBufferBuilder)bufferBuilder).isReleased()) continue;
            entry.setValue((Object)System.currentTimeMillis());
            return bufferBuilder;
        }
        BufferBuilder bufferBuilder = new BufferBuilder(256);
        POOL.add((Pair<BufferBuilder, Long>)new MutablePair((Object)bufferBuilder, (Object)System.currentTimeMillis()));
        return bufferBuilder;
    }

    public static int getAllocatedSize() {
        BufferBuilderPool.cleanup();
        return POOL.size();
    }

    private static void cleanup() {
        POOL.removeIf(b -> ((IBufferBuilder)b.getKey()).isReleased());
        POOL.removeIf(b -> {
            if ((Long)b.getValue() < System.currentTimeMillis() - 120000L) {
                ((IBufferBuilder)b.getKey()).release();
                return true;
            }
            return false;
        });
    }
}

