/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.injection.mixins.map_atlas_generation;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.client.gui.MapRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.raphimc.immediatelyfast.feature.map_atlas_generation.MapAtlasTexture;
import net.raphimc.immediatelyfast.injection.interfaces.IMapRenderer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MapRenderer.class})
public abstract class MixinMapRenderer
implements IMapRenderer {
    @Shadow
    @Final
    TextureManager f_93255_;
    @Unique
    private final Int2ObjectMap<MapAtlasTexture> mapAtlasTextures = new Int2ObjectOpenHashMap();
    @Unique
    private final Int2IntMap mapIdToAtlasMapping = new Int2IntOpenHashMap();

    @Inject(method={"resetData"}, at={@At(value="RETURN")})
    private void clearMapAtlasTextures(CallbackInfo ci) {
        for (MapAtlasTexture texture : this.mapAtlasTextures.values()) {
            texture.close();
        }
        this.mapAtlasTextures.clear();
        this.mapIdToAtlasMapping.clear();
    }

    @Inject(method={"getOrCreateMapInstance"}, at={@At(value="HEAD")})
    private void createMapAtlasTexture(int id, MapItemSavedData state, CallbackInfoReturnable<MapRenderer.MapInstance> cir) {
        this.mapIdToAtlasMapping.computeIfAbsent(id, k -> {
            for (MapAtlasTexture atlasTexture : this.mapAtlasTextures.values()) {
                int location = atlasTexture.getNextMapLocation();
                if (location == -1) continue;
                return location;
            }
            MapAtlasTexture atlasTexture = new MapAtlasTexture(this.mapAtlasTextures.size());
            this.mapAtlasTextures.put(atlasTexture.getId(), (Object)atlasTexture);
            return atlasTexture.getNextMapLocation();
        });
    }

    @Override
    public MapAtlasTexture getMapAtlasTexture(int id) {
        return (MapAtlasTexture)this.mapAtlasTextures.get(id);
    }

    @Override
    public int getAtlasMapping(int mapId) {
        return this.mapIdToAtlasMapping.getOrDefault(mapId, -1);
    }

    @Override
    public TextureManager getTextureManager() {
        return this.f_93255_;
    }
}

