/*
 * Decompiled with CFR 0.152.
 */
package wearblackallday.dimthread.gamerule;

import com.mojang.logging.LogUtils;
import net.minecraft.world.level.GameRules;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import wearblackallday.dimthread.mixin.IntegerValueAccessor;

public class RestrictedIntegerValue
extends GameRules.IntegerValue {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final int min;
    private final int max;

    public RestrictedIntegerValue(GameRules.Type<GameRules.IntegerValue> type, int def, int min, int max) {
        super(type, def);
        this.min = min;
        this.max = max;
    }

    protected void m_7377_(@NotNull String value) {
        int i = RestrictedIntegerValue.safeParse(value);
        if (i < this.min || i > this.max) {
            return;
        }
        ((IntegerValueAccessor)((Object)this)).setValue(i);
    }

    public boolean m_46314_(@NotNull String input) {
        try {
            int value = Integer.parseInt(input);
            if (this.min > value || this.max < value) {
                return false;
            }
            ((IntegerValueAccessor)((Object)this)).setValue(value);
            return true;
        }
        catch (NumberFormatException var3) {
            return false;
        }
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull GameRules.IntegerValue m_5590_() {
        return new RestrictedIntegerValue((GameRules.Type<GameRules.IntegerValue>)this.f_46360_, ((IntegerValueAccessor)((Object)this)).getValue(), this.min, this.max);
    }

    private static int safeParse(String input) {
        if (!input.isEmpty()) {
            try {
                return Integer.parseInt(input);
            }
            catch (NumberFormatException var2) {
                LOGGER.warn("Failed to parse integer {}", (Object)input);
            }
        }
        return 0;
    }
}

