/*
 * Decompiled with CFR 0.152.
 */
package wearblackallday.dimthread.mixin;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RedStoneWireBlock.class})
public abstract class RedstoneWireBlockMixin {
    @Shadow
    @Final
    public static IntegerProperty f_55500_;
    @Shadow
    @Final
    public static Map<Direction, EnumProperty<RedstoneSide>> f_55501_;
    private final ThreadLocal<Boolean> wiresGivePowerSafe = ThreadLocal.withInitial(() -> true);

    @Shadow
    protected abstract BlockState m_55514_(BlockGetter var1, BlockState var2, BlockPos var3);

    @Inject(method={"calculateTargetStrength"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getBestNeighborSignal(Lnet/minecraft/core/BlockPos;)I", shift=At.Shift.BEFORE)})
    private void getReceivedRedstonePowerBefore(Level world, BlockPos pos, CallbackInfoReturnable<Integer> ci) {
        this.wiresGivePowerSafe.set(false);
    }

    @Inject(method={"calculateTargetStrength"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getBestNeighborSignal(Lnet/minecraft/core/BlockPos;)I", shift=At.Shift.AFTER)})
    private void getReceivedRedstonePowerAfter(Level world, BlockPos pos, CallbackInfoReturnable<Integer> ci) {
        this.wiresGivePowerSafe.set(true);
    }

    @Overwrite
    public boolean m_7899_(BlockState state) {
        return this.wiresGivePowerSafe.get();
    }

    @Overwrite
    public int m_6376_(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return this.wiresGivePowerSafe.get() == false ? 0 : state.m_60746_(world, pos, direction);
    }

    @Overwrite
    public int m_6378_(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        if (!this.wiresGivePowerSafe.get().booleanValue() || direction == Direction.DOWN) {
            return 0;
        }
        int i = (Integer)state.m_61143_((Property)f_55500_);
        if (i == 0) {
            return 0;
        }
        return direction != Direction.UP && !((RedstoneSide)this.m_55514_(world, state, pos).m_61143_((Property)f_55501_.get(direction.m_122424_()))).m_61761_() ? 0 : i;
    }
}

