/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.resources;

import com.google.common.base.Splitter;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import org.embeddedt.modernfix.util.FileUtil;

public class CachedResourcePath {
    private final String[] pathComponents;
    public static final Interner<String> PATH_COMPONENT_INTERNER = Interners.newStrongInterner();
    private static final Splitter SLASH_SPLITTER = Splitter.on((char)'/');
    private static final String[] NO_PREFIX = new String[0];

    public CachedResourcePath(String[] prefix, Path path) {
        this(prefix, path, path.getNameCount(), true);
    }

    public CachedResourcePath(String s) {
        this(NO_PREFIX, SLASH_SPLITTER.splitToList((CharSequence)FileUtil.normalize(s)), false);
    }

    public <T> CachedResourcePath(String[] prefixElements, Collection<T> collection, boolean intern) {
        this(prefixElements, collection, collection.size(), intern);
    }

    public <T> CachedResourcePath(String[] prefixElements, Iterable<T> path, int count, boolean intern) {
        int i;
        String[] components = new String[prefixElements.length + count];
        for (i = 0; i < prefixElements.length; ++i) {
            components[i] = intern ? (String)PATH_COMPONENT_INTERNER.intern((Object)prefixElements[i]) : prefixElements[i];
        }
        for (T component : path) {
            String s = component.toString();
            if (s.length() == 0) continue;
            components[i] = intern ? (String)PATH_COMPONENT_INTERNER.intern((Object)s) : s;
            ++i;
        }
        this.pathComponents = components;
    }

    public CachedResourcePath(String[] prefixElements, CachedResourcePath other) {
        int i;
        String[] components = new String[prefixElements.length + other.pathComponents.length];
        for (i = 0; i < prefixElements.length; ++i) {
            components[i] = (String)PATH_COMPONENT_INTERNER.intern((Object)prefixElements[i]);
        }
        System.arraycopy(other.pathComponents, 0, components, i, other.pathComponents.length);
        this.pathComponents = components;
    }

    public int hashCode() {
        return Arrays.hashCode(this.pathComponents);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CachedResourcePath that = (CachedResourcePath)o;
        return Arrays.equals(this.pathComponents, that.pathComponents);
    }

    public String getFileName() {
        return this.pathComponents[this.pathComponents.length - 1];
    }

    public int getNameCount() {
        return this.pathComponents.length;
    }

    public String getNameAt(int i) {
        return this.pathComponents[i];
    }

    public String getFullPath(int startIndex) {
        StringBuilder sb = new StringBuilder();
        for (int i = startIndex; i < this.pathComponents.length; ++i) {
            sb.append(this.pathComponents[i]);
            if (i == this.pathComponents.length - 1) continue;
            sb.append('/');
        }
        return sb.toString();
    }
}

