/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.util;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.security.CodeSigner;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.core.ModernFixMixinPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.transformer.ClassInfo;

public class ClassInfoManager {
    private static Map<String, ClassInfo> classInfoCache = null;

    public static void clear() {
        if (!ModernFixMixinPlugin.instance.isOptionEnabled("perf.clear_mixin_classinfo.ClassInfoManager")) {
            return;
        }
        if (classInfoCache == null) {
            try {
                Field field = ClassInfo.class.getDeclaredField("cache");
                field.setAccessible(true);
                classInfoCache = (Map)field.get(null);
            }
            catch (ReflectiveOperationException | RuntimeException e) {
                e.printStackTrace();
                return;
            }
        }
        try {
            classInfoCache.entrySet().removeIf(entry -> !((String)entry.getKey()).equals("java/lang/Object") && (entry.getValue() == null || !((ClassInfo)entry.getValue()).isMixin()));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        int numManifestsCleared = 0;
        if (numManifestsCleared > 0) {
            ModernFix.LOGGER.info("Cleared {} manifest attributes", (Object)numManifestsCleared);
        }
        try {
            ClassInfoManager.clearSecureJarStructs();
        }
        catch (Throwable e) {
            ModernFix.LOGGER.error("Couldn't clear Jar structs", e);
        }
    }

    private static void clearSecureJarStructs() throws Throwable {
    }

    static class EmptyAttributes
    extends Attributes {
        public static final EmptyAttributes INSTANCE = new EmptyAttributes();

        EmptyAttributes() {
            super(1);
            this.map = ImmutableMap.of();
        }
    }

    static class LyingStatusDataMap
    implements Map<String, Object> {
        public static final LyingStatusDataMap INSTANCE = new LyingStatusDataMap();

        LyingStatusDataMap() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(Object o) {
            return true;
        }

        @Override
        public boolean containsValue(Object o) {
            return false;
        }

        @Override
        public Object get(Object o) {
            return null;
        }

        @Override
        @Nullable
        public Object put(String s, Object o) {
            return null;
        }

        @Override
        public Object remove(Object o) {
            return null;
        }

        @Override
        public void putAll(@NotNull Map<? extends String, ?> map) {
        }

        @Override
        public void clear() {
        }

        @Override
        @NotNull
        public Set<String> keySet() {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public Collection<Object> values() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public Set<Map.Entry<String, Object>> entrySet() {
            return Collections.emptySet();
        }
    }

    static class EmptyCodeSignerTable
    extends Hashtable<String, CodeSigner[]> {
        public static final EmptyCodeSignerTable INSTANCE = new EmptyCodeSignerTable();
        private static final CodeSigner[] VAL = new CodeSigner[0];

        EmptyCodeSignerTable() {
        }

        @Override
        public synchronized CodeSigner[] put(String key, CodeSigner[] value) {
            return null;
        }

        @Override
        public synchronized boolean isEmpty() {
            return true;
        }

        @Override
        public synchronized boolean containsKey(Object key) {
            return false;
        }

        @Override
        public synchronized CodeSigner[] get(Object key) {
            return VAL;
        }
    }
}

