/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block.entity;

import juuxel.adorn.block.AdornBlockEntities;
import juuxel.adorn.fluid.FluidReference;
import juuxel.adorn.lib.AdornGameRules;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 -2\u00020\u0001:\u0002-.B\u0017\u0012\u0006\u0010(\u001a\u00020'\u0012\u0006\u0010*\u001a\u00020)\u00a2\u0006\u0004\b+\u0010,J\u000f\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H&\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u000f\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\u000f\u0010\u000eJ'\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H&\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u0016H\u0004\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0010H\u0004\u00a2\u0006\u0004\b\u0019\u0010\u001aJ'\u0010\u001b\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0010H\u0004\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0015\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 H\u0016\u00a2\u0006\u0004\b\"\u0010#R\u0014\u0010&\u001a\u00020\b8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006/"}, d2={"Ljuuxel/adorn/block/entity/KitchenSinkBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "", "calculateComparatorOutput", "()I", "", "clearFluidsWithSponge", "()Z", "Ljuuxel/adorn/fluid/FluidReference;", "fluid", "Lnet/minecraft/world/item/ItemStack;", "stack", "Ljuuxel/adorn/block/entity/KitchenSinkBlockEntity$FluidItemSound;", "getEmptySound", "(Ljuuxel/adorn/fluid/FluidReference;Lnet/minecraft/world/item/ItemStack;)Ljuuxel/adorn/block/entity/KitchenSinkBlockEntity$FluidItemSound;", "getFillSound", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/InteractionHand;", "hand", "interactWithItem", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Z", "", "markDirtyAndSync", "()V", "onFill", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/player/Player;)V", "onPickUp", "(Ljuuxel/adorn/fluid/FluidReference;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/player/Player;)V", "Lnet/minecraft/nbt/CompoundTag;", "toInitialChunkDataNbt", "()Lnet/minecraft/nbt/CompoundTag;", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "toUpdatePacket", "()Lnet/minecraft/network/protocol/Packet;", "getFluidReference", "()Ljuuxel/adorn/fluid/FluidReference;", "fluidReference", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Companion", "FluidItemSound", "Adorn"})
public abstract class KitchenSinkBlockEntity
extends BlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public KitchenSinkBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(AdornBlockEntities.INSTANCE.getKITCHEN_SINK(), pos, state);
    }

    @NotNull
    public abstract FluidReference getFluidReference();

    public abstract boolean interactWithItem(@NotNull ItemStack var1, @NotNull Player var2, @NotNull InteractionHand var3);

    public abstract boolean clearFluidsWithSponge();

    protected final void onFill(@NotNull ItemStack stack, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        Level w = level;
        if (!w.f_46443_) {
            w.m_142346_((Entity)player, GameEvent.f_157769_, this.f_58858_);
            player.m_6330_(this.getEmptySound(this.getFluidReference(), stack).getEvent(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    protected final void onPickUp(@NotNull FluidReference fluid, @NotNull ItemStack stack, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)fluid, (String)"fluid");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        Level w = level;
        if (!w.f_46443_) {
            w.m_142346_((Entity)player, GameEvent.f_157816_, this.f_58858_);
            player.m_6330_(this.getFillSound(fluid, stack).getEvent(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @NotNull
    protected FluidItemSound getFillSound(@NotNull FluidReference fluid, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)fluid, (String)"fluid");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (stack.m_150930_(Items.f_42590_)) {
            SoundEvent soundEvent = SoundEvents.f_11770_;
            Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"ITEM_BOTTLE_FILL");
            return new FluidItemSound(soundEvent, true);
        }
        SoundEvent soundEvent = fluid.getFluid().m_142520_().orElse(SoundEvents.f_11781_);
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"fluid.fluid.bucketFillSo\u2026dEvents.ITEM_BUCKET_FILL)");
        return new FluidItemSound(soundEvent, false);
    }

    @NotNull
    protected FluidItemSound getEmptySound(@NotNull FluidReference fluid, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)fluid, (String)"fluid");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (stack.m_150930_(Items.f_42589_) && Intrinsics.areEqual((Object)PotionUtils.m_43579_((ItemStack)stack), (Object)Potions.f_43599_)) {
            SoundEvent soundEvent = SoundEvents.f_11769_;
            Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"ITEM_BOTTLE_EMPTY");
            return new FluidItemSound(soundEvent, true);
        }
        SoundEvent soundEvent = fluid.getFluid().m_205067_(FluidTags.f_13132_) ? SoundEvents.f_11780_ : SoundEvents.f_11778_;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"if (fluid.fluid.isIn(Flu\u2026dEvents.ITEM_BUCKET_EMPTY");
        return new FluidItemSound(soundEvent, false);
    }

    protected final void markDirtyAndSync() {
        this.m_6596_();
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        Level w = level;
        if (!w.f_46443_) {
            w.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_58483_() {
        ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket = ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
        Intrinsics.checkNotNullExpressionValue((Object)clientboundBlockEntityDataPacket, (String)"create(this)");
        return (Packet)clientboundBlockEntityDataPacket;
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag compoundTag = this.m_187482_();
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"createNbt()");
        return compoundTag;
    }

    public abstract int calculateComparatorOutput();

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001d\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Ljuuxel/adorn/block/entity/KitchenSinkBlockEntity$Companion;", "", "Lnet/minecraft/world/level/material/Fluid;", "fluid", "", "isInfinite", "(Lnet/minecraft/world/level/material/Fluid;)Z", "Lnet/minecraft/world/level/Level;", "world", "supportsInfiniteExtraction", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/material/Fluid;)Z", "<init>", "()V", "Adorn"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isInfinite(Fluid fluid) {
            return fluid instanceof FlowingFluid && ((FlowingFluid)fluid).m_6760_();
        }

        public final boolean supportsInfiniteExtraction(@NotNull Level world, @NotNull Fluid fluid) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)fluid, (String)"fluid");
            return this.isInfinite(fluid) && world.m_46469_().m_46207_(AdornGameRules.INSTANCE.getINFINITE_KITCHEN_SINKS());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\r\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0017\u0010\b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0018\u001a\u0004\b\u0019\u0010\u0004R\u0017\u0010\t\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u001a\u001a\u0004\b\u001b\u0010\u0007\u00a8\u0006\u001e"}, d2={"Ljuuxel/adorn/block/entity/KitchenSinkBlockEntity$FluidItemSound;", "", "Lnet/minecraft/sounds/SoundEvent;", "component1", "()Lnet/minecraft/sounds/SoundEvent;", "", "component2", "()Z", "event", "preferred", "copy", "(Lnet/minecraft/sounds/SoundEvent;Z)Ljuuxel/adorn/block/entity/KitchenSinkBlockEntity$FluidItemSound;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "fallback", "orElse", "(Lnet/minecraft/sounds/SoundEvent;)Ljuuxel/adorn/block/entity/KitchenSinkBlockEntity$FluidItemSound;", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/sounds/SoundEvent;", "getEvent", "Z", "getPreferred", "<init>", "(Lnet/minecraft/sounds/SoundEvent;Z)V", "Adorn"})
    public static final class FluidItemSound {
        @NotNull
        private final SoundEvent event;
        private final boolean preferred;

        public FluidItemSound(@NotNull SoundEvent event, boolean preferred) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.event = event;
            this.preferred = preferred;
        }

        @NotNull
        public final SoundEvent getEvent() {
            return this.event;
        }

        public final boolean getPreferred() {
            return this.preferred;
        }

        @NotNull
        public final FluidItemSound orElse(@Nullable SoundEvent fallback) {
            if (this.preferred) {
                return this;
            }
            return fallback != null ? new FluidItemSound(fallback, true) : this;
        }

        @NotNull
        public final SoundEvent component1() {
            return this.event;
        }

        public final boolean component2() {
            return this.preferred;
        }

        @NotNull
        public final FluidItemSound copy(@NotNull SoundEvent event, boolean preferred) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return new FluidItemSound(event, preferred);
        }

        public static /* synthetic */ FluidItemSound copy$default(FluidItemSound fluidItemSound, SoundEvent soundEvent, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                soundEvent = fluidItemSound.event;
            }
            if ((n & 2) != 0) {
                bl = fluidItemSound.preferred;
            }
            return fluidItemSound.copy(soundEvent, bl);
        }

        @NotNull
        public String toString() {
            return "FluidItemSound(event=" + this.event + ", preferred=" + this.preferred + ")";
        }

        public int hashCode() {
            int result = this.event.hashCode();
            int n = this.preferred ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FluidItemSound)) {
                return false;
            }
            FluidItemSound fluidItemSound = (FluidItemSound)other;
            if (!Intrinsics.areEqual((Object)this.event, (Object)fluidItemSound.event)) {
                return false;
            }
            return this.preferred == fluidItemSound.preferred;
        }
    }
}

