/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import juuxel.adorn.block.entity.TradingStationBlockEntity;
import juuxel.adorn.config.ConfigManager;
import juuxel.adorn.trading.Trade;
import juuxel.adorn.util.Colors;
import juuxel.adorn.util.ColorsKt;
import juuxel.adorn.util.ExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\"\u001a\u00020!\u00a2\u0006\u0004\b#\u0010$J?\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJW\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001c\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001f\u001a\n \u001b*\u0004\u0018\u00010\u001e0\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 \u00a8\u0006&"}, d2={"Ljuuxel/adorn/client/renderer/TradingStationRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Ljuuxel/adorn/block/entity/TradingStationBlockEntity;", "be", "", "tickDelta", "Lcom/mojang/blaze3d/vertex/PoseStack;", "matrices", "Lnet/minecraft/client/renderer/MultiBufferSource;", "vertexConsumers", "", "light", "overlay", "", "render", "(Ljuuxel/adorn/block/entity/TradingStationBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/network/chat/Component;", "label", "", "x", "y", "z", "maxDistance", "renderLabel", "(Lnet/minecraft/world/level/block/entity/BlockEntity;Lnet/minecraft/network/chat/Component;DDDILcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderDispatcher;", "kotlin.jvm.PlatformType", "dispatcher", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderDispatcher;", "Lnet/minecraft/client/gui/Font;", "textRenderer", "Lnet/minecraft/client/gui/Font;", "Lnet/minecraft/client/render/block/entity/BlockEntityRendererFactory$Context;", "context", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "Companion", "Adorn"})
@OnlyIn(value=Dist.CLIENT)
public final class TradingStationRenderer
implements BlockEntityRenderer<TradingStationBlockEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final BlockEntityRenderDispatcher dispatcher;
    private final Font textRenderer;
    private static final float SELLING_ROTATION_MULTIPLIER = 1.2f;
    @NotNull
    private static final String OWNER_LABEL = "block.adorn.trading_station.label.owner";
    @NotNull
    private static final String SELLING_LABEL = "block.adorn.trading_station.label.selling";
    @NotNull
    private static final String PRICE_LABEL = "block.adorn.trading_station.label.price";

    public TradingStationRenderer(@NotNull BlockEntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.dispatcher = context.m_173581_();
        this.textRenderer = context.m_173586_();
    }

    public void render(@NotNull TradingStationBlockEntity be, float tickDelta, @NotNull PoseStack matrices, @NotNull MultiBufferSource vertexConsumers, int light, int overlay) {
        Object[] itemRenderer;
        Intrinsics.checkNotNullParameter((Object)be, (String)"be");
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)vertexConsumers, (String)"vertexConsumers");
        HitResult hitResult = this.dispatcher.f_112250_;
        boolean lookingAtBlock = hitResult != null && hitResult.m_6662_() == HitResult.Type.BLOCK && Intrinsics.areEqual((Object)be.m_58899_(), (Object)((BlockHitResult)hitResult).m_82425_());
        Trade trade = be.getTrade();
        if (!trade.isEmpty()) {
            matrices.m_85836_();
            matrices.m_85837_(0.5, 1.2, 0.5);
            LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
            Intrinsics.checkNotNull((Object)localPlayer);
            int playerAge = localPlayer.f_19797_;
            matrices.m_85836_();
            matrices.m_85845_(Vector3f.f_122225_.m_122240_(((float)playerAge + tickDelta) * 1.2f));
            matrices.m_85841_(0.6f, 0.6f, 0.6f);
            matrices.m_85837_(0.0, 0.3, 0.0);
            itemRenderer = Minecraft.m_91087_().m_91291_();
            itemRenderer.m_174269_(trade.getSelling(), ItemTransforms.TransformType.FIXED, light, overlay, matrices, vertexConsumers, 0);
            matrices.m_85849_();
            matrices.m_85849_();
        }
        if (lookingAtBlock && ConfigManager.Companion.config().getClient().getShowTradingStationTooltips()) {
            itemRenderer = new Object[]{be.getOwnerName().m_6881_().m_130940_(ChatFormatting.GOLD)};
            MutableComponent label1 = Component.m_237110_((String)OWNER_LABEL, (Object[])itemRenderer);
            BlockEntity blockEntity = be;
            Intrinsics.checkNotNullExpressionValue((Object)label1, (String)"label1");
            this.renderLabel(blockEntity, (Component)label1, 0.0, 0.9, 0.0, 12, matrices, vertexConsumers, light);
            if (!be.getTrade().isEmpty()) {
                Object[] objectArray = new Object[]{ExtensionsKt.toTextWithCount(be.getTrade().getSelling())};
                MutableComponent label2 = Component.m_237110_((String)SELLING_LABEL, (Object[])objectArray);
                Object[] objectArray2 = new Object[]{ExtensionsKt.toTextWithCount(be.getTrade().getPrice())};
                MutableComponent label3 = Component.m_237110_((String)PRICE_LABEL, (Object[])objectArray2);
                BlockEntity blockEntity2 = be;
                Intrinsics.checkNotNullExpressionValue((Object)label2, (String)"label2");
                this.renderLabel(blockEntity2, (Component)label2, 0.0, 0.65, 0.0, 12, matrices, vertexConsumers, light);
                BlockEntity blockEntity3 = be;
                Intrinsics.checkNotNullExpressionValue((Object)label3, (String)"label3");
                this.renderLabel(blockEntity3, (Component)label3, 0.0, 0.4, 0.0, 12, matrices, vertexConsumers, light);
            }
        }
    }

    private final void renderLabel(BlockEntity be, Component label, double x, double y, double z, int maxDistance, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        Camera camera = this.dispatcher.f_112249_;
        double dist = ExtensionsKt.getSquaredDistance(be, camera.m_90583_().f_82479_, camera.m_90583_().f_82480_, camera.m_90583_().f_82481_);
        if (dist < (double)(maxDistance * maxDistance)) {
            matrices.m_85836_();
            matrices.m_85837_(x + 0.5, y + 1.5, z + 0.5);
            matrices.m_85845_(camera.m_90591_());
            matrices.m_85841_(-0.025f, -0.025f, 0.025f);
            Matrix4f positionMatrix = matrices.m_85850_().m_85861_();
            float opacity = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
            int backgroundColor = ColorsKt.color(0, opacity);
            float textX = (float)(-this.textRenderer.m_92852_((FormattedText)label)) / 2.0f;
            this.textRenderer.m_92841_(label, textX, 0.0f, Colors.INSTANCE.getWHITE(), false, positionMatrix, vertexConsumers, false, backgroundColor, light);
            matrices.m_85849_();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0004R\u0014\u0010\u0006\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0004R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Ljuuxel/adorn/client/renderer/TradingStationRenderer$Companion;", "", "", "OWNER_LABEL", "Ljava/lang/String;", "PRICE_LABEL", "SELLING_LABEL", "", "SELLING_ROTATION_MULTIPLIER", "F", "<init>", "()V", "Adorn"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

