/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.fluid;

import juuxel.adorn.config.ConfigManager;
import juuxel.adorn.fluid.FluidIngredient;
import juuxel.adorn.fluid.FluidUnit;
import juuxel.adorn.fluid.FluidVolume;
import juuxel.adorn.fluid.HasFluidAmount;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u0000 52\u00020\u0001:\u00015B\u0007\u00a2\u0006\u0004\b3\u00104J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000e\u0010\u0012J\u001d\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0013\u0010\u000bJ\u0015\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0019H\u0004\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0015\u0010 \u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b \u0010\u001cR\u001c\u0010\u0006\u001a\u00020\u00058&@&X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001c\u0010*\u001a\u00020%8&@&X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0011\u0010+\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u001e\u00102\u001a\u0004\u0018\u00010-8&@&X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b.\u0010/\"\u0004\b0\u00101\u00a8\u00066"}, d2={"Ljuuxel/adorn/fluid/FluidReference;", "Ljuuxel/adorn/fluid/HasFluidAmount;", "Ljuuxel/adorn/fluid/FluidVolume;", "createSnapshot", "()Ljuuxel/adorn/fluid/FluidVolume;", "", "amount", "Ljuuxel/adorn/fluid/FluidUnit;", "unit", "", "decrement", "(JLjuuxel/adorn/fluid/FluidUnit;)V", "displayUnit", "Lnet/minecraft/network/chat/Component;", "getAmountText", "(Ljuuxel/adorn/fluid/FluidUnit;)Lnet/minecraft/network/chat/Component;", "max", "maxUnit", "(JLjuuxel/adorn/fluid/FluidUnit;Ljuuxel/adorn/fluid/FluidUnit;)Lnet/minecraft/network/chat/Component;", "increment", "Ljuuxel/adorn/fluid/FluidIngredient;", "ingredient", "", "matches", "(Ljuuxel/adorn/fluid/FluidIngredient;)Z", "Lnet/minecraft/network/FriendlyByteBuf;", "buf", "readWithoutUnit", "(Lnet/minecraft/network/FriendlyByteBuf;)V", "", "toString", "()Ljava/lang/String;", "write", "getAmount", "()J", "setAmount", "(J)V", "Lnet/minecraft/world/level/material/Fluid;", "getFluid", "()Lnet/minecraft/world/level/material/Fluid;", "setFluid", "(Lnet/minecraft/world/level/material/Fluid;)V", "fluid", "isEmpty", "()Z", "Lnet/minecraft/nbt/CompoundTag;", "getNbt", "()Lnet/minecraft/nbt/CompoundTag;", "setNbt", "(Lnet/minecraft/nbt/CompoundTag;)V", "nbt", "<init>", "()V", "Companion", "Adorn"})
public abstract class FluidReference
implements HasFluidAmount {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract Fluid getFluid();

    public abstract void setFluid(@NotNull Fluid var1);

    @Override
    public abstract long getAmount();

    public abstract void setAmount(long var1);

    @Nullable
    public abstract CompoundTag getNbt();

    public abstract void setNbt(@Nullable CompoundTag var1);

    public final boolean isEmpty() {
        return Intrinsics.areEqual((Object)this.getFluid(), (Object)Fluids.f_76191_) || this.getAmount() == 0L;
    }

    public final void write(@NotNull FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        buf.m_130068_((Enum)this.getUnit());
        if (this.isEmpty()) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.m_130130_(Registry.f_122822_.m_7447_((Object)this.getFluid()));
            buf.m_130103_(this.getAmount());
            buf.m_130079_(this.getNbt());
        }
    }

    protected final void readWithoutUnit(@NotNull FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        if (buf.readBoolean()) {
            Object object = Registry.f_122822_.m_7942_(buf.m_130242_());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Registry.FLUID[buf.readVarInt()]");
            this.setFluid((Fluid)object);
            this.setAmount(buf.m_130258_());
            this.setNbt(buf.m_130260_());
        } else {
            Fluid fluid = Fluids.f_76191_;
            Intrinsics.checkNotNullExpressionValue((Object)fluid, (String)"EMPTY");
            this.setFluid(fluid);
            this.setAmount(0L);
            this.setNbt(null);
        }
    }

    @NotNull
    public final FluidVolume createSnapshot() {
        return new FluidVolume(this.getFluid(), this.getAmount(), this.getNbt(), this.getUnit());
    }

    public final void increment(long amount, @NotNull FluidUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        this.setAmount(this.getAmount() + FluidUnit.Companion.convert(amount, this.getUnit(), unit));
    }

    public final void decrement(long amount, @NotNull FluidUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        this.increment(-amount, unit);
    }

    public final boolean matches(@NotNull FluidIngredient ingredient) {
        Intrinsics.checkNotNullParameter((Object)ingredient, (String)"ingredient");
        return ingredient.getFluid().matches(this.getFluid()) && FluidUnit.Companion.compareVolumes(this, ingredient) >= 0 && Intrinsics.areEqual((Object)this.getNbt(), (Object)ingredient.getNbt());
    }

    @NotNull
    public final Component getAmountText(@NotNull FluidUnit displayUnit) {
        Intrinsics.checkNotNullParameter((Object)displayUnit, (String)"displayUnit");
        Object[] objectArray = new Object[]{FluidUnit.Companion.losslessConvert(this.getAmount(), this.getUnit(), displayUnit).resizeFraction(FluidReference.Companion.getUnitDenominator(this.getUnit(), displayUnit)), displayUnit.getSymbol()};
        MutableComponent mutableComponent = Component.m_237110_((String)"gui.adorn.fluid_volume", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(\n          \u2026playUnit.symbol\n        )");
        return (Component)mutableComponent;
    }

    public static /* synthetic */ Component getAmountText$default(FluidReference fluidReference, FluidUnit fluidUnit, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getAmountText");
        }
        if ((n & 1) != 0) {
            fluidUnit = FluidReference.Companion.getDefaultDisplayUnit();
        }
        return fluidReference.getAmountText(fluidUnit);
    }

    @NotNull
    public final Component getAmountText(long max, @NotNull FluidUnit maxUnit, @NotNull FluidUnit displayUnit) {
        Intrinsics.checkNotNullParameter((Object)maxUnit, (String)"maxUnit");
        Intrinsics.checkNotNullParameter((Object)displayUnit, (String)"displayUnit");
        Object[] objectArray = new Object[]{FluidUnit.Companion.losslessConvert(this.getAmount(), this.getUnit(), displayUnit).resizeFraction(FluidReference.Companion.getUnitDenominator(this.getUnit(), displayUnit)), FluidUnit.Companion.losslessConvert(max, maxUnit, displayUnit).resizeFraction(FluidReference.Companion.getUnitDenominator(maxUnit, displayUnit)), displayUnit.getSymbol()};
        MutableComponent mutableComponent = Component.m_237110_((String)"gui.adorn.fluid_volume.fraction", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(\n          \u2026playUnit.symbol\n        )");
        return (Component)mutableComponent;
    }

    public static /* synthetic */ Component getAmountText$default(FluidReference fluidReference, long l, FluidUnit fluidUnit, FluidUnit fluidUnit2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getAmountText");
        }
        if ((n & 4) != 0) {
            fluidUnit2 = FluidReference.Companion.getDefaultDisplayUnit();
        }
        return fluidReference.getAmountText(l, fluidUnit, fluidUnit2);
    }

    @NotNull
    public String toString() {
        return "FluidReference(fluid=" + Registry.f_122822_.m_7981_((Object)this.getFluid()) + ", amount=" + this.getAmount() + ", nbt=" + this.getNbt() + ")";
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001d\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\b\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\u0007J\u000f\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Ljuuxel/adorn/fluid/FluidReference$Companion;", "", "Ljuuxel/adorn/fluid/FluidReference;", "a", "b", "", "areFluidsAndAmountsEqual", "(Ljuuxel/adorn/fluid/FluidReference;Ljuuxel/adorn/fluid/FluidReference;)Z", "areFluidsEqual", "Ljuuxel/adorn/fluid/FluidUnit;", "getDefaultDisplayUnit", "()Ljuuxel/adorn/fluid/FluidUnit;", "from", "to", "", "getUnitDenominator", "(Ljuuxel/adorn/fluid/FluidUnit;Ljuuxel/adorn/fluid/FluidUnit;)J", "<init>", "()V", "Adorn"})
    public static final class Companion {
        private Companion() {
        }

        private final long getUnitDenominator(FluidUnit from, FluidUnit to) {
            if (from.getBucketVolume() == to.getBucketVolume()) {
                return 1L;
            }
            return Math.max(1L, from.getBucketVolume() / to.getBucketVolume());
        }

        private final FluidUnit getDefaultDisplayUnit() {
            return ConfigManager.Companion.config().getClient().getDisplayedFluidUnit();
        }

        public final boolean areFluidsEqual(@NotNull FluidReference a, @NotNull FluidReference b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            if (a.isEmpty()) {
                return b.isEmpty();
            }
            return Intrinsics.areEqual((Object)a.getFluid(), (Object)b.getFluid()) && Intrinsics.areEqual((Object)a.getNbt(), (Object)b.getNbt());
        }

        public final boolean areFluidsAndAmountsEqual(@NotNull FluidReference a, @NotNull FluidReference b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            if (a.isEmpty()) {
                return b.isEmpty();
            }
            return this.areFluidsEqual(a, b) && FluidUnit.Companion.compareVolumes(a, b) == 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

