/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import juuxel.adorn.loot.AdornLootConditionTypes;
import juuxel.adorn.util.LoggingKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u000f\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fR\u0018\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Ljuuxel/adorn/loot/GameRuleLootCondition;", "Lnet/minecraft/world/level/storage/loot/predicates/LootItemCondition;", "Lnet/minecraft/world/level/storage/loot/predicates/LootItemConditionType;", "getType", "()Lnet/minecraft/world/level/storage/loot/predicates/LootItemConditionType;", "Lnet/minecraft/world/level/storage/loot/LootContext;", "context", "", "test", "(Lnet/minecraft/world/level/storage/loot/LootContext;)Z", "", "gameRule", "Ljava/lang/String;", "Lnet/minecraft/world/GameRules$Key;", "key", "Lnet/minecraft/world/level/GameRules$Key;", "<init>", "(Ljava/lang/String;)V", "Companion", "Serializer", "Adorn"})
public final class GameRuleLootCondition
implements LootItemCondition {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String gameRule;
    @NotNull
    private final GameRules.Key<?> key;
    @NotNull
    private static final Logger LOGGER = LoggingKt.logger();

    public GameRuleLootCondition(@NotNull String gameRule) {
        Intrinsics.checkNotNullParameter((Object)gameRule, (String)"gameRule");
        this.gameRule = gameRule;
        this.key = new GameRules.Key(this.gameRule, GameRules.Category.MISC);
    }

    public boolean test(@NotNull LootContext context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        GameRules.Value rule = context.m_78952_().m_46469_().m_46170_(this.key);
        if (rule instanceof GameRules.BooleanValue) {
            bl = ((GameRules.BooleanValue)rule).m_46223_();
        } else if (rule == null) {
            LOGGER.error("Unknown game rule {} in loot condition", (Object)this.gameRule);
            bl = false;
        } else {
            LOGGER.error("Game rule {} ({}) is not a boolean", (Object)rule, (Object)this.gameRule);
            bl = false;
        }
        return bl;
    }

    @NotNull
    public LootItemConditionType m_7940_() {
        return AdornLootConditionTypes.INSTANCE.getGAME_RULE();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0007"}, d2={"Ljuuxel/adorn/loot/GameRuleLootCondition$Companion;", "", "Lorg/slf4j/Logger;", "LOGGER", "Lorg/slf4j/Logger;", "<init>", "()V", "Adorn"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Ljuuxel/adorn/loot/GameRuleLootCondition$Serializer;", "Lnet/minecraft/world/level/storage/loot/Serializer;", "Ljuuxel/adorn/loot/GameRuleLootCondition;", "Lcom/google/gson/JsonObject;", "json", "Lcom/google/gson/JsonDeserializationContext;", "context", "fromJson", "(Lcom/google/gson/JsonObject;Lcom/google/gson/JsonDeserializationContext;)Ljuuxel/adorn/loot/GameRuleLootCondition;", "condition", "Lcom/google/gson/JsonSerializationContext;", "", "toJson", "(Lcom/google/gson/JsonObject;Ljuuxel/adorn/loot/GameRuleLootCondition;Lcom/google/gson/JsonSerializationContext;)V", "<init>", "()V", "Adorn"})
    public static final class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<GameRuleLootCondition> {
        @NotNull
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        public void toJson(@NotNull JsonObject json, @NotNull GameRuleLootCondition condition, @NotNull JsonSerializationContext context) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            json.addProperty("game_rule", condition.gameRule);
        }

        @NotNull
        public GameRuleLootCondition fromJson(@NotNull JsonObject json, @NotNull JsonDeserializationContext context) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            String string = GsonHelper.m_13906_((JsonObject)json, (String)"game_rule");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(json, \"game_rule\")");
            return new GameRuleLootCondition(string);
        }
    }
}

