/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.menu;

import juuxel.adorn.fluid.FluidReference;
import juuxel.adorn.fluid.FluidUnit;
import juuxel.adorn.fluid.FluidVolume;
import juuxel.adorn.item.AdornItems;
import juuxel.adorn.menu.AdornMenus;
import juuxel.adorn.platform.PlatformBridges;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0002)*B\u0019\b\u0016\u0012\u0006\u0010#\u001a\u00020\n\u0012\u0006\u0010%\u001a\u00020$\u00a2\u0006\u0004\b&\u0010'B/\u0012\u0006\u0010#\u001a\u00020\n\u0012\u0006\u0010%\u001a\u00020$\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010!\u001a\u00020 \u0012\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b&\u0010(J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\r\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\"\u0010\u0013\u001a\u00020\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001cR\u0011\u0010\u001f\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010!\u001a\u00020 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Ljuuxel/adorn/menu/BrewerMenu;", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "Lnet/minecraft/world/entity/player/Player;", "player", "", "canUse", "(Lnet/minecraft/world/entity/player/Player;)Z", "", "sendContentUpdates", "()V", "", "index", "Lnet/minecraft/world/item/ItemStack;", "transferSlot", "(Lnet/minecraft/world/entity/player/Player;I)Lnet/minecraft/world/item/ItemStack;", "Lnet/minecraft/world/Container;", "container", "Lnet/minecraft/world/Container;", "Ljuuxel/adorn/fluid/FluidReference;", "fluid", "Ljuuxel/adorn/fluid/FluidReference;", "getFluid", "()Ljuuxel/adorn/fluid/FluidReference;", "setFluid", "(Ljuuxel/adorn/fluid/FluidReference;)V", "Ljuuxel/adorn/fluid/FluidVolume;", "lastFluid", "Ljuuxel/adorn/fluid/FluidVolume;", "Lnet/minecraft/world/entity/player/Player;", "getProgress", "()I", "progress", "Lnet/minecraft/world/inventory/ContainerData;", "propertyDelegate", "Lnet/minecraft/world/inventory/ContainerData;", "syncId", "Lnet/minecraft/world/entity/player/Inventory;", "playerInventory", "<init>", "(ILnet/minecraft/world/entity/player/Inventory;)V", "(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/Container;Lnet/minecraft/world/inventory/ContainerData;Ljuuxel/adorn/fluid/FluidReference;)V", "FluidContainerSlot", "MainSlot", "Adorn"})
public final class BrewerMenu
extends AbstractContainerMenu {
    @NotNull
    private final Container container;
    @NotNull
    private final ContainerData propertyDelegate;
    @NotNull
    private FluidReference fluid;
    @NotNull
    private final Player player;
    @Nullable
    private FluidVolume lastFluid;

    public BrewerMenu(int syncId, @NotNull Inventory playerInventory, @NotNull Container container, @NotNull ContainerData propertyDelegate2, @NotNull FluidReference fluid) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)propertyDelegate2, (String)"propertyDelegate");
        Intrinsics.checkNotNullParameter((Object)fluid, (String)"fluid");
        super(AdornMenus.INSTANCE.getBREWER(), syncId);
        this.container = container;
        this.propertyDelegate = propertyDelegate2;
        this.fluid = fluid;
        Player player = playerInventory.f_35978_;
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"playerInventory.player");
        this.player = player;
        AbstractContainerMenu.m_38869_((Container)this.container, (int)4);
        AbstractContainerMenu.m_38886_((ContainerData)this.propertyDelegate, (int)1);
        this.m_38897_(new MainSlot(this.container, 0, 80, 56));
        this.m_38897_(new Slot(this.container, 1, 50, 17));
        this.m_38897_(new Slot(this.container, 2, 110, 17));
        this.m_38897_(new FluidContainerSlot(this.container, 3, 123, 60));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)playerInventory, x + y * 9 + 9, 8 + x * 18, 84 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)playerInventory, x, 8 + x * 18, 142));
        }
        this.m_38884_(this.propertyDelegate);
    }

    @NotNull
    public final FluidReference getFluid() {
        return this.fluid;
    }

    public final void setFluid(@NotNull FluidReference fluidReference) {
        Intrinsics.checkNotNullParameter((Object)fluidReference, (String)"<set-?>");
        this.fluid = fluidReference;
    }

    public final int getProgress() {
        return this.propertyDelegate.m_6413_(0);
    }

    public BrewerMenu(int syncId, @NotNull Inventory playerInventory) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        this(syncId, playerInventory, (Container)new SimpleContainer(4), (ContainerData)new SimpleContainerData(1), FluidVolume.Companion.empty(FluidUnit.LITRE));
    }

    public boolean m_6875_(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.container.m_6542_(player);
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack result = ItemStack.f_41583_;
        Object object = this.f_38839_.get(index);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"slots[index]");
        Slot slot = (Slot)object;
        if (slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            result = stack.m_41777_();
            if (index <= 3) {
                if (!this.m_38903_(stack, 4, this.f_38839_.size(), true)) {
                    ItemStack itemStack = ItemStack.f_41583_;
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                    return itemStack;
                }
            } else {
                Object object2 = this.f_38839_.get(0);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"slots[BrewerBlockEntity.INPUT_SLOT]");
                Slot mugSlot = (Slot)object2;
                if (!mugSlot.m_6657_() && mugSlot.m_5857_(stack)) {
                    mugSlot.m_5852_(stack.m_41620_(Math.min(mugSlot.m_5866_(stack), stack.m_41613_())));
                }
                if (!stack.m_41619_() && !this.m_38903_(stack, 1, 4, false)) {
                    ItemStack itemStack = ItemStack.f_41583_;
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                    return itemStack;
                }
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        ItemStack itemStack = result;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"result");
        return itemStack;
    }

    public void m_38946_() {
        super.m_38946_();
        FluidVolume last = this.lastFluid;
        if (last == null || !FluidReference.Companion.areFluidsAndAmountsEqual(this.fluid, last)) {
            this.lastFluid = this.fluid.createSnapshot();
            PlatformBridges.Companion this_$iv = PlatformBridges.Companion;
            boolean $i$f$getNetwork = false;
            this_$iv.get().getNetwork().sendBrewerFluidSync(this.player, this.f_38840_, this.fluid);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\u0007\u0012\u0006\u0010\r\u001a\u00020\u0007\u0012\u0006\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Ljuuxel/adorn/menu/BrewerMenu$MainSlot;", "Lnet/minecraft/world/inventory/Slot;", "Lnet/minecraft/world/item/ItemStack;", "stack", "", "canInsert", "(Lnet/minecraft/world/item/ItemStack;)Z", "", "getMaxItemCount", "()I", "Lnet/minecraft/world/Container;", "inventory", "index", "x", "y", "<init>", "(Lnet/minecraft/world/Container;III)V", "Adorn"})
    private static final class MainSlot
    extends Slot {
        public MainSlot(@NotNull Container inventory, int index, int x, int y) {
            Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
            super(inventory, index, x, y);
        }

        public int m_6641_() {
            return 1;
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            return stack.m_150930_((Item)AdornItems.INSTANCE.getMUG());
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\u0006\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\f"}, d2={"Ljuuxel/adorn/menu/BrewerMenu$FluidContainerSlot;", "Lnet/minecraft/world/inventory/Slot;", "", "getMaxItemCount", "()I", "Lnet/minecraft/world/Container;", "inventory", "index", "x", "y", "<init>", "(Lnet/minecraft/world/Container;III)V", "Adorn"})
    private static final class FluidContainerSlot
    extends Slot {
        public FluidContainerSlot(@NotNull Container inventory, int index, int x, int y) {
            Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
            super(inventory, index, x, y);
        }

        public int m_6641_() {
            return 1;
        }
    }
}

