/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.platform.forge.block.entity;

import java.util.Arrays;
import java.util.Comparator;
import juuxel.adorn.block.entity.BrewerBlockEntity;
import juuxel.adorn.fluid.FluidReference;
import juuxel.adorn.platform.forge.util.FluidTankReference;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010+\u001a\u00020*\u0012\u0006\u0010-\u001a\u00020,\u00a2\u0006\u0004\b.\u0010/J\u000f\u0010\u0003\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001b\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ3\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\"\u0004\b\u0000\u0010\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0013J\u000f\u0010\u0019\u001a\u00020\u0011H\u0014\u00a2\u0006\u0004\b\u0019\u0010\u0013J\u0017\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0014H\u0014\u00a2\u0006\u0004\b\u001a\u0010\u0017R\u001a\u0010\u001c\u001a\u00020\u001b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\"\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0017\u0010#\u001a\u00020\"8\u0006\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&R8\u0010(\u001a&\u0012\f\u0012\n '*\u0004\u0018\u00010\"0\" '*\u0012\u0012\f\u0012\n '*\u0004\u0018\u00010\"0\"\u0018\u00010\u00060\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)\u00a8\u00060"}, d2={"Ljuuxel/adorn/platform/forge/block/entity/BrewerBlockEntityForge;", "Ljuuxel/adorn/block/entity/BrewerBlockEntity;", "", "canExtractFluidContainer", "()Z", "", "Lnet/minecraftforge/common/util/LazyOptional;", "Lnet/minecraftforge/items/IItemHandlerModifiable;", "createItemHandlers", "()[Lnet/minecraftforge/common/util/LazyOptional;", "T", "Lnet/minecraftforge/common/capabilities/Capability;", "cap", "Lnet/minecraft/core/Direction;", "side", "getCapability", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/core/Direction;)Lnet/minecraftforge/common/util/LazyOptional;", "", "invalidateCaps", "()V", "Lnet/minecraft/nbt/CompoundTag;", "nbt", "readNbt", "(Lnet/minecraft/nbt/CompoundTag;)V", "reviveCaps", "tryExtractFluidContainer", "writeNbt", "Ljuuxel/adorn/fluid/FluidReference;", "fluidReference", "Ljuuxel/adorn/fluid/FluidReference;", "getFluidReference", "()Ljuuxel/adorn/fluid/FluidReference;", "itemHandlers", "[Lnet/minecraftforge/common/util/LazyOptional;", "Lnet/minecraftforge/fluids/capability/templates/FluidTank;", "tank", "Lnet/minecraftforge/fluids/capability/templates/FluidTank;", "getTank", "()Lnet/minecraftforge/fluids/capability/templates/FluidTank;", "kotlin.jvm.PlatformType", "tankHolder", "Lnet/minecraftforge/common/util/LazyOptional;", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Adorn"})
public final class BrewerBlockEntityForge
extends BrewerBlockEntity {
    @NotNull
    private LazyOptional<IItemHandlerModifiable>[] itemHandlers;
    @NotNull
    private final FluidTank tank;
    @NotNull
    private final FluidReference fluidReference;
    private final LazyOptional<FluidTank> tankHolder;

    public BrewerBlockEntityForge(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(pos, state);
        this.itemHandlers = this.createItemHandlers();
        this.tank = new FluidTank(this, 2000){
            final /* synthetic */ BrewerBlockEntityForge this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            protected void onContentsChanged() {
                this.this$0.m_6596_();
            }
        };
        this.fluidReference = new FluidTankReference(this.tank);
        this.tankHolder = LazyOptional.of(() -> BrewerBlockEntityForge.tankHolder$lambda-0(this));
    }

    @NotNull
    public final FluidTank getTank() {
        return this.tank;
    }

    @Override
    @NotNull
    public FluidReference getFluidReference() {
        return this.fluidReference;
    }

    private final LazyOptional<IItemHandlerModifiable>[] createItemHandlers() {
        Direction[] directionArray = (Direction[])ArraysKt.sortedArrayWith((Object[])Direction.values(), (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Direction it = (Direction)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.m_122411_());
                it = (Direction)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.m_122411_()));
            }
        });
        LazyOptional[] lazyOptionalArray = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])Arrays.copyOf(directionArray, directionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)lazyOptionalArray, (String)"create(this, *Direction.\u2026ith(compareBy { it.id }))");
        return lazyOptionalArray;
    }

    @Override
    protected boolean canExtractFluidContainer() {
        return !FluidUtil.tryEmptyContainer((ItemStack)this.m_8020_(3), (IFluidHandler)((IFluidHandler)this.tank), (int)this.tank.getSpace(), null, (boolean)false).isSuccess();
    }

    @Override
    protected void tryExtractFluidContainer() {
        FluidActionResult fluidActionResult = FluidUtil.tryEmptyContainer((ItemStack)this.m_8020_(3), (IFluidHandler)((IFluidHandler)this.tank), (int)this.tank.getSpace(), null, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)fluidActionResult, (String)"tryEmptyContainer(getSta\u2026, tank.space, null, true)");
        FluidActionResult result = fluidActionResult;
        if (result.isSuccess()) {
            this.m_6836_(3, result.result);
            this.m_6596_();
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        Intrinsics.checkNotNullParameter(cap, (String)"cap");
        if (!this.f_58859_ && Intrinsics.areEqual(cap, (Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
            LazyOptional lazyOptional;
            if (side != null) {
                LazyOptional lazyOptional2 = this.itemHandlers[side.m_122411_()].cast();
                lazyOptional = lazyOptional2;
                Intrinsics.checkNotNullExpressionValue((Object)lazyOptional2, (String)"itemHandlers[side.id].cast()");
            } else {
                LazyOptional lazyOptional3 = LazyOptional.empty();
                lazyOptional = lazyOptional3;
                Intrinsics.checkNotNullExpressionValue((Object)lazyOptional3, (String)"empty()");
            }
            return lazyOptional;
        }
        if (Intrinsics.areEqual(cap, (Object)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
            LazyOptional lazyOptional = this.tankHolder.cast();
            Intrinsics.checkNotNullExpressionValue((Object)lazyOptional, (String)"tankHolder.cast()");
            return lazyOptional;
        }
        LazyOptional lazyOptional = super.getCapability(cap, side);
        Intrinsics.checkNotNullExpressionValue((Object)lazyOptional, (String)"super.getCapability(cap, side)");
        return lazyOptional;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (LazyOptional<IItemHandlerModifiable> itemHandler : this.itemHandlers) {
            itemHandler.invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.itemHandlers = this.createItemHandlers();
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.m_183515_(nbt);
        this.tank.writeToNBT(nbt);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.m_142466_(nbt);
        this.tank.readFromNBT(nbt);
    }

    private static final FluidTank tankHolder$lambda-0(BrewerBlockEntityForge this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.tank;
    }
}

