/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.platform.forge.block.entity;

import juuxel.adorn.block.entity.KitchenSinkBlockEntity;
import juuxel.adorn.fluid.FluidReference;
import juuxel.adorn.fluid.FluidVolume;
import juuxel.adorn.platform.forge.util.FluidReferencesKt;
import juuxel.adorn.platform.forge.util.FluidTankReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 82\u00020\u0001:\u00018B\u0017\u0012\u0006\u00103\u001a\u000202\u0012\u0006\u00105\u001a\u000204\u00a2\u0006\u0004\b6\u00107J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J3\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\r\"\u0004\b\u0000\u0010\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0016J'\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010!\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b!\u0010\"J'\u0010#\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010%\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020\u001eH\u0014\u00a2\u0006\u0004\b%\u0010\"R\u001a\u0010&\u001a\u00020\u00108\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)R\u0017\u0010+\u001a\u00020*8\u0006\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.R8\u00100\u001a&\u0012\f\u0012\n /*\u0004\u0018\u00010*0* /*\u0012\u0012\f\u0012\n /*\u0004\u0018\u00010*0*\u0018\u00010\r0\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101\u00a8\u00069"}, d2={"Ljuuxel/adorn/platform/forge/block/entity/KitchenSinkBlockEntityForge;", "Ljuuxel/adorn/block/entity/KitchenSinkBlockEntity;", "", "calculateComparatorOutput", "()I", "", "clearFluidsWithSponge", "()Z", "T", "Lnet/minecraftforge/common/capabilities/Capability;", "cap", "Lnet/minecraft/core/Direction;", "side", "Lnet/minecraftforge/common/util/LazyOptional;", "getCapability", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/core/Direction;)Lnet/minecraftforge/common/util/LazyOptional;", "Ljuuxel/adorn/fluid/FluidReference;", "fluid", "Lnet/minecraft/world/item/ItemStack;", "stack", "Ljuuxel/adorn/block/entity/KitchenSinkBlockEntity$FluidItemSound;", "getEmptySound", "(Ljuuxel/adorn/fluid/FluidReference;Lnet/minecraft/world/item/ItemStack;)Ljuuxel/adorn/block/entity/KitchenSinkBlockEntity$FluidItemSound;", "getFillSound", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/InteractionHand;", "hand", "interactWithItem", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Z", "Lnet/minecraft/nbt/CompoundTag;", "nbt", "", "readNbt", "(Lnet/minecraft/nbt/CompoundTag;)V", "setStackOrInsert", "(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/item/ItemStack;)V", "writeNbt", "fluidReference", "Ljuuxel/adorn/fluid/FluidReference;", "getFluidReference", "()Ljuuxel/adorn/fluid/FluidReference;", "Lnet/minecraftforge/fluids/capability/templates/FluidTank;", "tank", "Lnet/minecraftforge/fluids/capability/templates/FluidTank;", "getTank", "()Lnet/minecraftforge/fluids/capability/templates/FluidTank;", "kotlin.jvm.PlatformType", "tankHolder", "Lnet/minecraftforge/common/util/LazyOptional;", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Companion", "Adorn"})
public final class KitchenSinkBlockEntityForge
extends KitchenSinkBlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FluidTank tank;
    @NotNull
    private final FluidReference fluidReference;
    private final LazyOptional<FluidTank> tankHolder;
    private static final int BOTTLE_LITRES = 250;
    @NotNull
    private static final FluidStack BOTTLE_WATER = new FluidStack((Fluid)Fluids.f_76193_, 250);

    public KitchenSinkBlockEntityForge(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(pos, state);
        this.tank = new FluidTank(this){
            final /* synthetic */ KitchenSinkBlockEntityForge this$0;
            {
                this.this$0 = $receiver;
                super(1000);
            }

            @NotNull
            public FluidStack drain(int maxDrain, @Nullable IFluidHandler.FluidAction action) {
                FluidStack fluidStack;
                Level level = KitchenSinkBlockEntityForge.access$getWorld$p$s1270512846(this.this$0);
                Intrinsics.checkNotNull((Object)level);
                Fluid fluid = this.fluid.getFluid();
                Intrinsics.checkNotNullExpressionValue((Object)fluid, (String)"fluid.fluid");
                if (KitchenSinkBlockEntity.Companion.supportsInfiniteExtraction(level, fluid)) {
                    fluidStack = new FluidStack(this.fluid, Math.min(this.getFluidAmount(), maxDrain));
                } else {
                    FluidStack fluidStack2 = super.drain(maxDrain, action);
                    fluidStack = fluidStack2;
                    Intrinsics.checkNotNullExpressionValue((Object)fluidStack2, (String)"{\n                super.\u2026in, action)\n            }");
                }
                return fluidStack;
            }

            protected void onContentsChanged() {
                KitchenSinkBlockEntityForge.access$markDirtyAndSync(this.this$0);
            }
        };
        this.fluidReference = new FluidTankReference(this.tank);
        this.tankHolder = LazyOptional.of(() -> KitchenSinkBlockEntityForge.tankHolder$lambda-0(this));
    }

    @NotNull
    public final FluidTank getTank() {
        return this.tank;
    }

    @Override
    @NotNull
    public FluidReference getFluidReference() {
        return this.fluidReference;
    }

    @Override
    public boolean interactWithItem(@NotNull ItemStack stack, @NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (this.tank.getSpace() > 0) {
            FluidActionResult fluidActionResult = FluidUtil.tryEmptyContainer((ItemStack)stack, (IFluidHandler)((IFluidHandler)this.tank), (int)this.tank.getSpace(), null, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)fluidActionResult, (String)"tryEmptyContainer(stack,\u2026, tank.space, null, true)");
            FluidActionResult result = fluidActionResult;
            if (result.isSuccess()) {
                this.onFill(stack, player);
                ItemStack itemStack = result.result;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"result.result");
                this.setStackOrInsert(player, hand, itemStack);
                this.markDirtyAndSync();
                return true;
            }
        }
        FluidVolume tankFluid = this.getFluidReference().createSnapshot();
        FluidActionResult fluidActionResult = FluidUtil.tryFillContainer((ItemStack)stack, (IFluidHandler)((IFluidHandler)this.tank), (int)this.tank.getFluidAmount(), null, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)fluidActionResult, (String)"tryFillContainer(stack, \u2026.fluidAmount, null, true)");
        FluidActionResult result = fluidActionResult;
        if (result.isSuccess()) {
            this.onPickUp(tankFluid, stack, player);
            ItemStack itemStack = result.result;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"result.result");
            this.setStackOrInsert(player, hand, itemStack);
            this.markDirtyAndSync();
            return true;
        }
        if (stack.m_150930_(Items.f_42590_)) {
            FluidStack fluidStack = this.tank.drain(BOTTLE_WATER, IFluidHandler.FluidAction.SIMULATE);
            Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"tank.drain(BOTTLE_WATER,\u2026ler.FluidAction.SIMULATE)");
            FluidStack drainingResult = fluidStack;
            if (drainingResult.getAmount() >= 250) {
                this.tank.drain(BOTTLE_WATER, IFluidHandler.FluidAction.EXECUTE);
                this.onPickUp(tankFluid, stack, player);
                ItemStack bottle = new ItemStack((ItemLike)Items.f_42589_);
                PotionUtils.m_43549_((ItemStack)bottle, (Potion)Potions.f_43599_);
                this.setStackOrInsert(player, hand, bottle);
                return true;
            }
        } else if (stack.m_150930_(Items.f_42589_)) {
            boolean spaceForWater;
            boolean bl = spaceForWater = this.tank.getFluid().isEmpty() || this.tank.getFluid().isFluidEqual(BOTTLE_WATER) && this.tank.getSpace() >= 250;
            if (spaceForWater && Intrinsics.areEqual((Object)PotionUtils.m_43579_((ItemStack)stack), (Object)Potions.f_43599_)) {
                this.onFill(stack, player);
                this.tank.fill(BOTTLE_WATER.copy(), IFluidHandler.FluidAction.EXECUTE);
                this.setStackOrInsert(player, hand, new ItemStack((ItemLike)Items.f_42590_));
                this.markDirtyAndSync();
                return true;
            }
        }
        return false;
    }

    private final void setStackOrInsert(Player player, InteractionHand hand, ItemStack stack) {
        ItemStack current = player.m_21120_(hand);
        current.m_41774_(1);
        if (current.m_41619_()) {
            player.m_21008_(hand, stack);
        } else {
            player.m_150109_().m_150079_(stack);
        }
    }

    @Override
    public boolean clearFluidsWithSponge() {
        if (!this.tank.getFluid().getFluid().m_205067_(FluidTags.f_13131_) || this.tank.getFluid().getAmount() == 0) {
            return false;
        }
        this.tank.getFluid().setAmount(0);
        this.markDirtyAndSync();
        return true;
    }

    @Override
    @NotNull
    protected KitchenSinkBlockEntity.FluidItemSound getFillSound(@NotNull FluidReference fluid, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)fluid, (String)"fluid");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return super.getFillSound(fluid, stack).orElse(fluid.getFluid().getFluidType().getSound(FluidReferencesKt.toFluidStack(fluid), SoundActions.BUCKET_FILL));
    }

    @Override
    @NotNull
    protected KitchenSinkBlockEntity.FluidItemSound getEmptySound(@NotNull FluidReference fluid, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)fluid, (String)"fluid");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return super.getEmptySound(fluid, stack).orElse(fluid.getFluid().getFluidType().getSound(FluidReferencesKt.toFluidStack(fluid), SoundActions.BUCKET_EMPTY));
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.m_142466_(nbt);
        this.tank.readFromNBT(nbt);
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.m_183515_(nbt);
        this.tank.writeToNBT(nbt);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        Intrinsics.checkNotNullParameter(cap, (String)"cap");
        if (Intrinsics.areEqual(cap, (Object)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
            LazyOptional lazyOptional = this.tankHolder.cast();
            Intrinsics.checkNotNullExpressionValue((Object)lazyOptional, (String)"tankHolder.cast()");
            return lazyOptional;
        }
        LazyOptional lazyOptional = super.getCapability(cap, side);
        Intrinsics.checkNotNullExpressionValue((Object)lazyOptional, (String)"super.getCapability(cap, side)");
        return lazyOptional;
    }

    @Override
    public int calculateComparatorOutput() {
        return this.tank.isEmpty() ? 0 : 1 + Mth.m_14143_((float)((float)14 * (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity()));
    }

    private static final FluidTank tankHolder$lambda-0(KitchenSinkBlockEntityForge this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.tank;
    }

    public static final /* synthetic */ Level access$getWorld$p$s1270512846(KitchenSinkBlockEntityForge $this) {
        return $this.f_58857_;
    }

    public static final /* synthetic */ void access$markDirtyAndSync(KitchenSinkBlockEntityForge $this) {
        $this.markDirtyAndSync();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Ljuuxel/adorn/platform/forge/block/entity/KitchenSinkBlockEntityForge$Companion;", "", "", "BOTTLE_LITRES", "I", "Lnet/minecraftforge/fluids/FluidStack;", "BOTTLE_WATER", "Lnet/minecraftforge/fluids/FluidStack;", "<init>", "()V", "Adorn"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

