/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.platform.forge.client;

import java.util.List;
import java.util.function.Function;
import juuxel.adorn.client.FluidRenderingBridge;
import juuxel.adorn.fluid.FluidReference;
import juuxel.adorn.fluid.FluidUnit;
import juuxel.adorn.platform.forge.util.FluidReferencesKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0017\u00a2\u0006\u0004\b\u0005\u0010\u0006J+\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0017\u00a2\u0006\u0004\b\f\u0010\rJ\u0019\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0003\u001a\u00020\u0002H\u0017\u00a2\u0006\u0004\b\u000f\u0010\u0010J/\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u000bH\u0017\u00a2\u0006\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Ljuuxel/adorn/platform/forge/client/FluidRenderingBridgeForge;", "Ljuuxel/adorn/client/FluidRenderingBridge;", "Ljuuxel/adorn/fluid/FluidReference;", "volume", "", "fillsFromTop", "(Ljuuxel/adorn/fluid/FluidReference;)Z", "Lnet/minecraft/world/level/BlockAndTintGetter;", "world", "Lnet/minecraft/core/BlockPos;", "pos", "", "getColor", "(Ljuuxel/adorn/fluid/FluidReference;Lnet/minecraft/world/level/BlockAndTintGetter;Lnet/minecraft/core/BlockPos;)I", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "getStillSprite", "(Ljuuxel/adorn/fluid/FluidReference;)Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "Lnet/minecraft/world/item/TooltipFlag;", "context", "maxAmountInLitres", "", "Lnet/minecraft/network/chat/Component;", "getTooltip", "(Ljuuxel/adorn/fluid/FluidReference;Lnet/minecraft/world/item/TooltipFlag;Ljava/lang/Integer;)Ljava/util/List;", "<init>", "()V", "Adorn"})
public final class FluidRenderingBridgeForge
implements FluidRenderingBridge {
    @NotNull
    public static final FluidRenderingBridgeForge INSTANCE = new FluidRenderingBridgeForge();

    private FluidRenderingBridgeForge() {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public TextureAtlasSprite getStillSprite(@NotNull FluidReference volume) {
        Intrinsics.checkNotNullParameter((Object)volume, (String)"volume");
        Fluid fluid = volume.getFluid();
        Function atlas = Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_);
        return (TextureAtlasSprite)atlas.apply(IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture(FluidReferencesKt.toFluidStack(volume)));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getColor(@NotNull FluidReference volume, @Nullable BlockAndTintGetter world, @Nullable BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)volume, (String)"volume");
        Fluid fluid = volume.getFluid();
        return world != null && pos != null ? IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor(fluid.m_76145_(), world, pos) : IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor(FluidReferencesKt.toFluidStack(volume));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean fillsFromTop(@NotNull FluidReference volume) {
        Intrinsics.checkNotNullParameter((Object)volume, (String)"volume");
        Fluid fluid = volume.getFluid();
        return fluid.getFluidType().isLighterThanAir();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public List<Component> getTooltip(@NotNull FluidReference volume, @NotNull TooltipFlag context, @Nullable Integer maxAmountInLitres) {
        List list;
        Intrinsics.checkNotNullParameter((Object)volume, (String)"volume");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List $this$getTooltip_u24lambda_u2d0 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Fluid fluid = volume.getFluid();
        FluidStack stack = FluidReferencesKt.toFluidStack(volume);
        Component name = stack.getDisplayName();
        MutableComponent mutableComponent = Component.m_237119_().m_7220_(name).m_130938_(fluid.getFluidType().getRarity(stack).getStyleModifier());
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"empty().append(name).sty\u2026ity(stack).styleModifier)");
        $this$getTooltip_u24lambda_u2d0.add(mutableComponent);
        if (maxAmountInLitres != null) {
            $this$getTooltip_u24lambda_u2d0.add(FluidReference.getAmountText$default(volume, maxAmountInLitres.intValue(), FluidUnit.LITRE, null, 4, null));
        } else {
            $this$getTooltip_u24lambda_u2d0.add(FluidReference.getAmountText$default(volume, null, 1, null));
        }
        if (context.m_7050_()) {
            MutableComponent mutableComponent2 = Component.m_237113_((String)String.valueOf(ForgeRegistries.FLUIDS.getKey((Object)fluid))).m_130940_(ChatFormatting.DARK_GRAY);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"literal(ForgeRegistries.\u2026ted(Formatting.DARK_GRAY)");
            $this$getTooltip_u24lambda_u2d0.add(mutableComponent2);
        }
        return CollectionsKt.build((List)list);
    }
}

