/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.util.animation;

import juuxel.adorn.util.animation.AnimationEngine;
import juuxel.adorn.util.animation.AnimationTask;
import juuxel.adorn.util.animation.Interpolator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 \u001b*\u0004\b\u0000\u0010\u00012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00028\u00000\u0002:\u0002\u001b\u001cB%\u0012\u0006\u0010\u0014\u001a\u00020\u0013\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00028\u0000H$\u00a2\u0006\u0004\b\u0006\u0010\u0007J.\u0010\u000b\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u00032\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u0004\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0004\b\u000b\u0010\fR\"\u0010\u000e\u001a\u000e\u0018\u00010\rR\b\u0012\u0004\u0012\u00028\u00000\u00008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001d"}, d2={"Ljuuxel/adorn/util/animation/AbstractAnimatedProperty;", "T", "Lkotlin/properties/ReadWriteProperty;", "", "value", "", "setRawValue", "(Ljava/lang/Object;)V", "thisRef", "Lkotlin/reflect/KProperty;", "property", "setValue", "(Ljava/lang/Object;Lkotlin/reflect/KProperty;Ljava/lang/Object;)V", "Ljuuxel/adorn/util/animation/AbstractAnimatedProperty$Task;", "currentTask", "Ljuuxel/adorn/util/animation/AbstractAnimatedProperty$Task;", "", "duration", "I", "Ljuuxel/adorn/util/animation/AnimationEngine;", "engine", "Ljuuxel/adorn/util/animation/AnimationEngine;", "Ljuuxel/adorn/util/animation/Interpolator;", "interpolator", "Ljuuxel/adorn/util/animation/Interpolator;", "<init>", "(Ljuuxel/adorn/util/animation/AnimationEngine;ILjuuxel/adorn/util/animation/Interpolator;)V", "Companion", "Task", "Adorn"})
public abstract class AbstractAnimatedProperty<T>
implements ReadWriteProperty<Object, T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnimationEngine engine;
    private final int duration;
    @NotNull
    private final Interpolator<T> interpolator;
    @Nullable
    private volatile Task currentTask;

    public AbstractAnimatedProperty(@NotNull AnimationEngine engine, int duration, @NotNull Interpolator<T> interpolator) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter(interpolator, (String)"interpolator");
        this.engine = engine;
        this.duration = duration;
        this.interpolator = interpolator;
    }

    protected abstract void setRawValue(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(@Nullable Object thisRef, @NotNull KProperty<?> property, T value2) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        AbstractAnimatedProperty abstractAnimatedProperty = this;
        synchronized (abstractAnimatedProperty) {
            boolean bl = false;
            Object oldValue = this.getValue(thisRef, property);
            Task task = this.currentTask;
            if (task != null) {
                Task task2 = task;
                AnimationEngine animationEngine = this.engine;
                AnimationTask p0 = task2;
                boolean bl2 = false;
                animationEngine.remove(p0);
            }
            if (!Intrinsics.areEqual((Object)oldValue, value2)) {
                Task task3;
                this.currentTask = task3 = new Task(oldValue, value2);
                this.engine.add(task3);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\b"}, d2={"Ljuuxel/adorn/util/animation/AbstractAnimatedProperty$Companion;", "", "", "delta", "ease", "(F)F", "<init>", "()V", "Adorn"})
    public static final class Companion {
        private Companion() {
        }

        private final float ease(float delta) {
            return 1.0f - (float)Math.pow(1.0f - delta, 5);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\f\u001a\u00028\u0000\u0012\u0006\u0010\u000e\u001a\u00028\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\u0007R\u0016\u0010\n\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00028\u00008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00028\u00008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\r\u00a8\u0006\u0011"}, d2={"Ljuuxel/adorn/util/animation/AbstractAnimatedProperty$Task;", "Ljuuxel/adorn/util/animation/AnimationTask;", "", "isAlive", "()Z", "", "removed", "()V", "tick", "", "age", "I", "from", "Ljava/lang/Object;", "to", "<init>", "(Ljuuxel/adorn/util/animation/AbstractAnimatedProperty;Ljava/lang/Object;Ljava/lang/Object;)V", "Adorn"})
    private final class Task
    implements AnimationTask {
        private final T from;
        private final T to;
        private int age;

        public Task(T from, T to) {
            this.from = from;
            this.to = to;
        }

        @Override
        public boolean isAlive() {
            return this.age < AbstractAnimatedProperty.this.duration;
        }

        @Override
        public void tick() {
            int n = this.age;
            this.age = n + 1;
            float delta = Companion.ease((float)this.age / (float)AbstractAnimatedProperty.this.duration);
            Object newValue = AbstractAnimatedProperty.this.interpolator.interpolate(delta, this.from, this.to);
            AbstractAnimatedProperty.this.setRawValue(newValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removed() {
            AbstractAnimatedProperty abstractAnimatedProperty = AbstractAnimatedProperty.this;
            AbstractAnimatedProperty abstractAnimatedProperty2 = AbstractAnimatedProperty.this;
            AbstractAnimatedProperty abstractAnimatedProperty3 = abstractAnimatedProperty;
            synchronized (abstractAnimatedProperty3) {
                boolean bl = false;
                if (Intrinsics.areEqual((Object)abstractAnimatedProperty2.currentTask, (Object)this)) {
                    abstractAnimatedProperty2.currentTask = null;
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }
}

