/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.stairs;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedVerticalSlopedStairsModel
extends FramedBlockModel {
    private final Direction facing;
    private final Direction rotDir;
    private final Direction rotDirTwo;
    private final boolean ySlope;

    public FramedVerticalSlopedStairsModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        this.rotDir = rot.withFacing(this.facing);
        this.rotDirTwo = rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(this.facing);
        this.ySlope = (Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction slopeRotDir;
        Direction quadDir = quad.m_111306_();
        if (quadDir == this.rotDir || quadDir == this.rotDirTwo) {
            if (Utils.isY(quadDir)) {
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.facing.m_122424_(), 0.5f)).export(quadMap.get(quadDir));
            } else {
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.facing.m_122424_(), 0.5f)).export(quadMap.get(quadDir));
            }
        } else if (quadDir == this.facing.m_122424_()) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(this.rotDir, 1.0f, 0.0f)).export(quadMap.get(quadDir));
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(this.rotDir.m_122424_(), 1.0f, 0.0f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
        }
        boolean useRotDirQuad = Utils.isY(this.rotDir) == this.ySlope;
        Direction slopeQuadDir = useRotDirQuad ? this.rotDir : this.rotDirTwo;
        Direction direction = slopeRotDir = useRotDirQuad ? this.rotDirTwo : this.rotDir;
        if (quadDir == slopeQuadDir) {
            if (Utils.isY(slopeQuadDir)) {
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.facing, 0.5f)).apply(Modifiers.makeVerticalSlope(slopeRotDir, 45.0f)).export(quadMap.get(null));
            } else {
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.facing, 0.5f)).apply(Modifiers.makeVerticalSlope(slopeRotDir == Direction.UP, 45.0f)).export(quadMap.get(null));
            }
        }
    }

    public static BlockState itemSource() {
        return (BlockState)((Block)FBContent.blockFramedVerticalSlopedStairs.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

