/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.integration.waila;

import de.maxhenkel.gravestone.GraveUtils;
import de.maxhenkel.gravestone.tileentity.GraveStoneTileEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class HUDHandlerGraveStone
implements IBlockComponentProvider,
IServerDataProvider<BlockEntity> {
    public static final HUDHandlerGraveStone INSTANCE = new HUDHandlerGraveStone();
    private static final ResourceLocation OBJECT_NAME_TAG = new ResourceLocation("jade", "object_name");
    private static final ResourceLocation UID = new ResourceLocation("gravestone", "grave");

    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        if (blockEntity instanceof GraveStoneTileEntity) {
            CompoundTag data;
            GraveStoneTileEntity grave = (GraveStoneTileEntity)blockEntity;
            iTooltip.remove(OBJECT_NAME_TAG);
            iTooltip.add((Component)grave.m_7755_().m_6881_().m_130940_(ChatFormatting.WHITE));
            MutableComponent time = GraveUtils.getDate(grave.getDeath().getTimestamp());
            if (time != null) {
                iTooltip.add((Component)Component.m_237110_((String)"message.gravestone.date_of_death", (Object[])new Object[]{time}));
            }
            if ((data = blockAccessor.getServerData()).m_128441_("ItemCount")) {
                iTooltip.add((Component)Component.m_237110_((String)"message.gravestone.item_count", (Object[])new Object[]{data.m_128451_("ItemCount")}));
            }
        }
    }

    public void appendServerData(CompoundTag compoundTag, ServerPlayer serverPlayer, Level level, BlockEntity blockEntity, boolean b) {
        if (blockEntity instanceof GraveStoneTileEntity) {
            GraveStoneTileEntity grave = (GraveStoneTileEntity)blockEntity;
            compoundTag.m_128405_("ItemCount", (int)grave.getDeath().getAllItems().stream().filter(itemStack -> !itemStack.m_41619_()).count());
        }
    }

    public ResourceLocation getUid() {
        return UID;
    }
}

