/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.gui.content;

import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.konkrete.gui.content.handling.AdvancedWidgetsHandler;
import de.keksuccino.konkrete.gui.content.handling.IAdvancedWidgetBase;
import de.keksuccino.konkrete.input.CharData;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.KeyboardData;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.mixin.client.IMixinEditBox;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;

public class AdvancedTextField
extends EditBox
implements IAdvancedWidgetBase {
    private final boolean handleSelf;
    private final CharacterFilter characterFilter;

    public AdvancedTextField(Font font, int x, int y, int width, int height, boolean handleSelf, @Nullable CharacterFilter characterFilter) {
        super(font, x, y, width, height, (Component)Component.m_237113_((String)""));
        this.handleSelf = handleSelf;
        this.characterFilter = characterFilter;
    }

    public boolean m_5534_(char character, int modifiers) {
        if (this.characterFilter == null || this.characterFilter.isAllowed(character)) {
            return super.m_5534_(character, modifiers);
        }
        return false;
    }

    public void m_94164_(String textToWrite) {
        if (this.characterFilter != null) {
            textToWrite = this.characterFilter.filterForAllowedChars(textToWrite);
        }
        super.m_94164_(textToWrite);
    }

    public void m_6303_(PoseStack matrix, int mouseX, int mouseY, float partial) {
        if (this.handleSelf) {
            AdvancedWidgetsHandler.handleWidget(this);
        }
        super.m_6303_(matrix, mouseX, mouseY, partial);
    }

    @Override
    public void onTick() {
        if (this.handleSelf) {
            this.m_94120_();
        }
    }

    @Override
    public void onKeyPress(KeyboardData d) {
        if (this.handleSelf) {
            this.m_7933_(d.keycode, d.scancode, d.modfiers);
        }
    }

    @Override
    public void onKeyReleased(KeyboardData d) {
        if (this.handleSelf) {
            this.m_7920_(d.keycode, d.scancode, d.modfiers);
        }
    }

    @Override
    public void onCharTyped(CharData d) {
        if (this.handleSelf) {
            this.m_5534_(d.typedChar, d.modfiers);
        }
    }

    @Override
    public void onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.handleSelf) {
            this.m_6375_(mouseX, mouseY, mouseButton);
        }
    }

    public boolean isHovered() {
        int mouseX = MouseInput.getMouseX();
        int mouseY = MouseInput.getMouseY();
        return mouseX >= this.getX() && mouseX <= this.getX() + this.m_5711_() && mouseY >= this.getY() && mouseY <= this.getY() + this.m_93694_();
    }

    public boolean m_94222_() {
        return this.getAccessor().getIsEditableKonkrete();
    }

    public boolean isLeftClicked() {
        return this.m_198029_() && MouseInput.isLeftMouseDown();
    }

    public int m_5711_() {
        return this.f_93618_;
    }

    public void m_93674_(int width) {
        this.f_93618_ = width;
    }

    public int getX() {
        return this.f_93620_;
    }

    public void m_94214_(int x) {
        this.f_93620_ = x;
    }

    public int getY() {
        return this.f_93621_;
    }

    public void setY(int y) {
        this.f_93621_ = y;
    }

    public IMixinEditBox getAccessor() {
        return (IMixinEditBox)((Object)this);
    }

    @Deprecated
    public boolean m_198029_() {
        return this.isHovered();
    }

    @Deprecated
    protected void setResponderEntryValue(String text) {
        this.getAccessor().onValueChangeKonkrete(text);
    }

    @Deprecated
    public int getMaxStringLength() {
        return this.getAccessor().getMaxLengthKonkrete();
    }

    @Deprecated
    public int getSelectionEnd() {
        return this.getAccessor().getHightlightPosKonkrete();
    }

    @Deprecated
    public boolean isEnabled() {
        return this.m_94222_();
    }
}

