/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.nbt;

import com.teamresourceful.resourcefullib.common.nbt.NbtReader;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class TagReader<I, T extends Tag>
implements NbtReader<I, T> {
    private final byte type;
    private final Function<I, T> writer;
    private final BiConsumer<I, T> reader;
    @Nullable
    private final Supplier<T> defaultCreator;

    public TagReader(byte type, Function<I, T> writer, BiConsumer<I, T> reader, @Nullable Supplier<T> defaultCreator) {
        this.type = type;
        this.writer = writer;
        this.reader = reader;
        this.defaultCreator = defaultCreator;
    }

    public static <I> TagReader<I, ByteTag> byteTag(Function<I, Byte> writer, BiConsumer<I, Byte> reader) {
        return new TagReader<Object, ByteTag>(1, i -> ByteTag.m_128266_((byte)((Byte)writer.apply(i))), (i, t) -> reader.accept(i, t.m_7063_()), null);
    }

    public static <I> TagReader<I, ByteTag> byteTag(Function<I, Byte> writer, BiConsumer<I, Byte> reader, byte defaultValue) {
        return new TagReader<Object, ByteTag>(1, i -> ByteTag.m_128266_((byte)((Byte)writer.apply(i))), (i, t) -> reader.accept(i, t.m_7063_()), () -> ByteTag.m_128266_((byte)defaultValue));
    }

    public static <I> TagReader<I, ShortTag> shortTag(Function<I, Short> writer, BiConsumer<I, Short> reader) {
        return new TagReader<Object, ShortTag>(2, i -> ShortTag.m_129258_((short)((Short)writer.apply(i))), (i, t) -> reader.accept(i, t.m_7053_()), null);
    }

    public static <I> TagReader<I, ShortTag> shortTag(Function<I, Short> writer, BiConsumer<I, Short> reader, short defaultValue) {
        return new TagReader<Object, ShortTag>(2, i -> ShortTag.m_129258_((short)((Short)writer.apply(i))), (i, t) -> reader.accept(i, t.m_7053_()), () -> ShortTag.m_129258_((short)defaultValue));
    }

    public static <I> TagReader<I, IntTag> intTag(Function<I, Integer> writer, BiConsumer<I, Integer> reader) {
        return new TagReader<Object, IntTag>(3, i -> IntTag.m_128679_((int)((Integer)writer.apply(i))), (i, t) -> reader.accept(i, t.m_7047_()), null);
    }

    public static <I> TagReader<I, IntTag> intTag(Function<I, Integer> writer, BiConsumer<I, Integer> reader, int defaultValue) {
        return new TagReader<Object, IntTag>(3, i -> IntTag.m_128679_((int)((Integer)writer.apply(i))), (i, t) -> reader.accept(i, t.m_7047_()), () -> IntTag.m_128679_((int)defaultValue));
    }

    public static <I> TagReader<I, LongTag> longTag(Function<I, Long> writer, BiConsumer<I, Long> reader) {
        return new TagReader<Object, LongTag>(4, i -> LongTag.m_128882_((long)((Long)writer.apply(i))), (i, t) -> reader.accept(i, t.m_7046_()), null);
    }

    public static <I> TagReader<I, LongTag> longTag(Function<I, Long> writer, BiConsumer<I, Long> reader, long defaultValue) {
        return new TagReader<Object, LongTag>(4, i -> LongTag.m_128882_((long)((Long)writer.apply(i))), (i, t) -> reader.accept(i, t.m_7046_()), () -> LongTag.m_128882_((long)defaultValue));
    }

    public static <I> TagReader<I, FloatTag> floatTag(Function<I, Float> writer, BiConsumer<I, Float> reader) {
        return new TagReader<Object, FloatTag>(5, i -> FloatTag.m_128566_((float)((Float)writer.apply(i)).floatValue()), (i, t) -> reader.accept(i, Float.valueOf(t.m_7057_())), null);
    }

    public static <I> TagReader<I, FloatTag> floatTag(Function<I, Float> writer, BiConsumer<I, Float> reader, float defaultValue) {
        return new TagReader<Object, FloatTag>(5, i -> FloatTag.m_128566_((float)((Float)writer.apply(i)).floatValue()), (i, t) -> reader.accept(i, Float.valueOf(t.m_7057_())), () -> FloatTag.m_128566_((float)defaultValue));
    }

    public static <I> TagReader<I, DoubleTag> doubleTag(Function<I, Double> writer, BiConsumer<I, Double> reader) {
        return new TagReader<Object, DoubleTag>(6, i -> DoubleTag.m_128500_((double)((Double)writer.apply(i))), (i, t) -> reader.accept(i, t.m_7061_()), null);
    }

    public static <I> TagReader<I, DoubleTag> doubleTag(Function<I, Double> writer, BiConsumer<I, Double> reader, double defaultValue) {
        return new TagReader<Object, DoubleTag>(6, i -> DoubleTag.m_128500_((double)((Double)writer.apply(i))), (i, t) -> reader.accept(i, t.m_7061_()), () -> DoubleTag.m_128500_((double)defaultValue));
    }

    public static <I> TagReader<I, StringTag> stringTag(Function<I, String> writer, BiConsumer<I, String> reader) {
        return new TagReader<Object, StringTag>(8, i -> StringTag.m_129297_((String)((String)writer.apply(i))), (i, t) -> reader.accept(i, t.m_7916_()), null);
    }

    public static <I> TagReader<I, StringTag> stringTag(Function<I, String> writer, BiConsumer<I, String> reader, String defaultValue) {
        return new TagReader<Object, StringTag>(8, i -> StringTag.m_129297_((String)((String)writer.apply(i))), (i, t) -> reader.accept(i, t.m_7916_()), () -> StringTag.m_129297_((String)defaultValue));
    }

    @Override
    public byte type() {
        return this.type;
    }

    @Override
    public void setDefault(I instance) {
        if (this.defaultCreator != null) {
            this.reader.accept(instance, (Tag)this.defaultCreator.get());
        }
    }

    @Override
    public void read(I instance, T tag) {
        this.reader.accept(instance, tag);
    }

    @Override
    public T write(I instance) {
        return (T)((Tag)this.writer.apply(instance));
    }
}

