/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.bogey;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.util.transform.Transform;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public abstract class BogeyRenderer {
    Map<String, ModelData[]> contraptionModelData = new HashMap<String, ModelData[]>();

    public Transform<?>[] getTransformsFromPartial(PartialModel model, PoseStack ms, boolean inInstancedContraption, int size) {
        return inInstancedContraption ? this.transformContraptionModelData(this.keyFromModel(model), ms) : this.createModelData(model, size);
    }

    public Transform<?>[] getTransformsFromBlockState(BlockState state, PoseStack ms, boolean inContraption, int size) {
        return inContraption ? this.transformContraptionModelData(this.keyFromModel(state), ms) : this.createModelData(state, size);
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void render(CompoundTag var1, float var2, PoseStack var3, int var4, VertexConsumer var5, boolean var6);

    @OnlyIn(value=Dist.CLIENT)
    public void render(CompoundTag bogeyData, float wheelAngle, PoseStack ms) {
        this.render(bogeyData, wheelAngle, ms, 0, null, true);
    }

    public abstract BogeySizes.BogeySize getSize();

    private Transform<?>[] transformContraptionModelData(String key, PoseStack ms) {
        ModelData[] modelData = this.contraptionModelData.get(key);
        Arrays.stream(modelData).forEach(modelDataElement -> modelDataElement.setTransform(ms));
        return modelData;
    }

    private Transform<?>[] createModelData(PartialModel model, int size) {
        BlockState air = Blocks.f_50016_.m_49966_();
        SuperByteBuffer[] data = new SuperByteBuffer[]{CachedBufferer.partial(model, air)};
        return this.expandArrayToLength(data, size);
    }

    private Transform<?>[] createModelData(BlockState state, int size) {
        SuperByteBuffer[] data = new SuperByteBuffer[]{CachedBufferer.block(state)};
        return this.expandArrayToLength(data, size);
    }

    private Transform<?>[] expandArrayToLength(SuperByteBuffer[] data, int size) {
        return (Transform[])Arrays.stream(Collections.nCopies(size, data).toArray()).flatMap(inner -> Arrays.stream((SuperByteBuffer[])inner)).toArray(SuperByteBuffer[]::new);
    }

    public Transform<?> getTransformFromPartial(PartialModel model, PoseStack ms, boolean inInstancedContraption) {
        BlockState air = Blocks.f_50016_.m_49966_();
        return inInstancedContraption ? this.contraptionModelData.get(this.keyFromModel(model))[0].setTransform(ms) : CachedBufferer.partial(model, air);
    }

    public Transform<?> getTransformFromBlockState(BlockState state, PoseStack ms, boolean inContraption) {
        return inContraption ? this.contraptionModelData.get(this.keyFromModel(state))[0].setTransform(ms) : CachedBufferer.block(state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void initialiseContraptionModelData(MaterialManager var1);

    public void createModelInstances(MaterialManager materialManager, PartialModel model, int count) {
        ModelData[] modelData = new ModelData[count];
        materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(model).createInstances((InstanceData[])modelData);
        this.contraptionModelData.put(this.keyFromModel(model), modelData);
    }

    public void createModelInstances(MaterialManager materialManager, BlockState state, int count) {
        ModelData[] modelData = new ModelData[count];
        materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(state).createInstances((InstanceData[])modelData);
        this.contraptionModelData.put(this.keyFromModel(state), modelData);
    }

    public void createModelInstance(MaterialManager materialManager, BlockState state) {
        this.createModelInstances(materialManager, state, 1);
    }

    public void createModelInstances(MaterialManager materialManager, PartialModel ... models) {
        for (PartialModel model : models) {
            this.createModelInstances(materialManager, model, 1);
        }
    }

    public static <B extends Transform<?>> void finalize(B b, PoseStack ms, int light, @Nullable VertexConsumer vb) {
        b.scale(0.9980469f);
        if (b instanceof SuperByteBuffer) {
            SuperByteBuffer byteBuf = (SuperByteBuffer)b;
            if (vb != null) {
                byteBuf.light(light).renderInto(ms, vb);
            }
        }
    }

    public void emptyTransforms() {
        for (ModelData[] data : this.contraptionModelData.values()) {
            for (ModelData model : data) {
                model.setEmptyTransform();
            }
        }
    }

    public void updateLight(int blockLight, int skyLight) {
        for (ModelData[] data : this.contraptionModelData.values()) {
            for (ModelData model : data) {
                model.setBlockLight(blockLight).setSkyLight(skyLight);
            }
        }
    }

    public void remove() {
        for (ModelData[] data : this.contraptionModelData.values()) {
            for (ModelData model : data) {
                model.delete();
            }
        }
        this.contraptionModelData.clear();
    }

    private String keyFromModel(PartialModel partialModel) {
        return partialModel.getLocation().toString();
    }

    private String keyFromModel(BlockState state) {
        return state.toString();
    }

    public static abstract class CommonRenderer
    extends BogeyRenderer {
        @Override
        public BogeySizes.BogeySize getSize() {
            return null;
        }
    }
}

