/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.generator;

import net.devtech.arrp.generator.BlockResourceGenerator;
import net.devtech.arrp.generator.TextureRegistry;
import net.devtech.arrp.json.blockstate.JBlockStates;
import net.devtech.arrp.json.models.JModel;
import net.devtech.arrp.json.models.JTextures;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

public class BRRPCubeBlock
extends Block
implements BlockResourceGenerator {
    public final String parent;
    public final JTextures textures;

    public BRRPCubeBlock(BlockBehaviour.Properties settings, String parent, JTextures textures) {
        super(settings);
        this.parent = parent;
        this.textures = textures;
    }

    public static BRRPCubeBlock cubeAll(BlockBehaviour.Properties settings, String allTexture) {
        return new BRRPCubeBlock(settings, "block/cube_all", JTextures.ofAll(allTexture));
    }

    public static BRRPCubeBlock cubeBottomTop(BlockBehaviour.Properties settings, String topTexture, String sideTexture, String bottomTexture) {
        return new BRRPCubeBlock(settings, "block/cube_bottom_top", JTextures.ofSides(topTexture, sideTexture, bottomTexture));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public @UnknownNullability JBlockStates getBlockStates() {
        return JBlockStates.simple(this.getBlockModelId());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public @UnknownNullability JModel getBlockModel() {
        return new JModel(this.parent).textures(this.textures);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public String getTextureId(@NotNull TextureSlot textureKey) {
        ResourceLocation texture = TextureRegistry.getTexture(this, textureKey);
        if (texture != null) {
            return texture.toString();
        }
        for (TextureSlot textureKey0 = textureKey; textureKey0 != null; textureKey0 = textureKey0.m_125903_()) {
            String texture0 = (String)this.textures.get(textureKey0.m_125897_());
            if (texture0 == null) continue;
            return texture0;
        }
        return BlockResourceGenerator.super.getTextureId(textureKey);
    }
}

