/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.generator;

import net.devtech.arrp.annotations.PreferredEnvironment;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.devtech.arrp.json.models.JModel;
import net.devtech.arrp.json.models.JTextures;
import net.devtech.arrp.json.recipe.JRecipe;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import pers.solid.brrp.PlatformBridge;

public interface ItemResourceGenerator {
    @Contract(pure=true)
    default public ResourceLocation getItemId() {
        return Registry.f_122827_.m_7981_((Object)((Item)this));
    }

    @PreferredEnvironment(value=Dist.CLIENT)
    @Contract(pure=true)
    default public ResourceLocation getItemModelId() {
        return this.getItemId().brrp_prepend("item/");
    }

    @PreferredEnvironment(value=Dist.CLIENT)
    @Contract(pure=true)
    default public String getTextureId() {
        return this.getItemId().brrp_prepend("item/").toString();
    }

    @PreferredEnvironment(value=Dist.CLIENT)
    @Contract(pure=true)
    @Nullable
    default public JModel getItemModel() {
        return new JModel("item/generated").textures(new JTextures().layer0(this.getTextureId()));
    }

    @PreferredEnvironment(value=Dist.CLIENT)
    @Contract(mutates="param1")
    default public void writeItemModel(RuntimeResourcePack pack) {
        JModel model = this.getItemModel();
        if (model != null) {
            pack.addModel(model, this.getItemModelId());
        }
    }

    @PreferredEnvironment(value=Dist.CLIENT)
    @Contract(mutates="param1")
    default public void writeAssets(RuntimeResourcePack pack) {
        this.writeItemModel(pack);
    }

    @Contract(pure=true)
    @Nullable
    default public JRecipe getCraftingRecipe() {
        return null;
    }

    @Contract(pure=true)
    default public ResourceLocation getRecipeId() {
        return this.getItemId();
    }

    @ApiStatus.AvailableSince(value="0.6.2")
    @Contract(pure=true)
    default public ResourceLocation getAdvancementIdForRecipe(ResourceLocation recipeId) {
        ItemLike itemConvertible;
        CreativeModeTab group;
        ItemResourceGenerator itemResourceGenerator = this;
        if (itemResourceGenerator instanceof ItemLike && (group = (itemConvertible = (ItemLike)itemResourceGenerator).m_5456_().m_41471_()) != null) {
            return recipeId.brrp_prepend("recipes/" + group.m_40783_() + "/");
        }
        return recipeId.brrp_prepend("recipes/");
    }

    @Contract(mutates="param1")
    default public void writeRecipes(RuntimeResourcePack pack) {
        JRecipe craftingRecipe = this.getCraftingRecipe();
        if (craftingRecipe != null) {
            ResourceLocation recipeId = this.getRecipeId();
            pack.addRecipe(recipeId, craftingRecipe);
            pack.addRecipeAdvancement(recipeId, this.getAdvancementIdForRecipe(recipeId), craftingRecipe);
        }
    }

    @Contract(mutates="param1")
    default public void writeData(RuntimeResourcePack pack) {
        this.writeRecipes(pack);
    }

    @Contract(mutates="param1")
    default public void writeAll(RuntimeResourcePack pack) {
        if (PlatformBridge.getInstance().isClientEnvironment()) {
            this.writeAssets(pack);
        }
        this.writeData(pack);
    }

    @Contract(mutates="param1")
    default public void writeResources(RuntimeResourcePack pack, @Nullable PackType resourceType) {
        if (resourceType == null) {
            this.writeAssets(pack);
            this.writeData(pack);
        } else if (resourceType == PackType.CLIENT_RESOURCES) {
            this.writeAssets(pack);
        } else {
            this.writeData(pack);
        }
    }

    @Contract(mutates="param1")
    @ApiStatus.AvailableSince(value="0.8.2")
    @ApiStatus.OverrideOnly
    default public void writeResources(RuntimeResourcePack pack, boolean clientIncluded, boolean serverIncluded) {
        if (clientIncluded) {
            this.writeAssets(pack);
        }
        if (serverIncluded) {
            this.writeData(pack);
        }
    }
}

