/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.generator;

import net.devtech.arrp.annotations.PreferredEnvironment;
import net.devtech.arrp.generator.BlockResourceGenerator;
import net.devtech.arrp.generator.ItemResourceGenerator;
import net.devtech.arrp.generator.TextureRegistry;
import net.minecraft.core.Registry;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.api.distmarker.Dist;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ResourceGeneratorHelper {
    @Contract(pure=true)
    public static ResourceLocation getItemId(@NotNull ItemLike item) {
        ResourceLocation resourceLocation;
        if (item instanceof ItemResourceGenerator) {
            ItemResourceGenerator generator = (ItemResourceGenerator)item;
            resourceLocation = generator.getItemId();
        } else {
            resourceLocation = Registry.f_122827_.m_7981_((Object)item.m_5456_());
        }
        return resourceLocation;
    }

    @Contract(pure=true)
    @PreferredEnvironment(value=Dist.CLIENT)
    public static ResourceLocation getItemModelId(@NotNull ItemLike item) {
        ResourceLocation resourceLocation;
        if (item instanceof ItemResourceGenerator) {
            ItemResourceGenerator generator = (ItemResourceGenerator)item;
            resourceLocation = generator.getItemModelId();
        } else {
            resourceLocation = Registry.f_122827_.m_7981_((Object)item.m_5456_()).brrp_prepend("item/");
        }
        return resourceLocation;
    }

    public static ResourceLocation getBlockId(@NotNull Block block) {
        ResourceLocation resourceLocation;
        if (block instanceof BlockResourceGenerator) {
            BlockResourceGenerator generator = (BlockResourceGenerator)block;
            resourceLocation = generator.getBlockId();
        } else {
            resourceLocation = Registry.f_122824_.m_7981_((Object)block);
        }
        return resourceLocation;
    }

    @Contract(pure=true)
    @PreferredEnvironment(value=Dist.CLIENT)
    public static ResourceLocation getBlockModelId(@NotNull Block block) {
        ResourceLocation resourceLocation;
        if (block instanceof BlockResourceGenerator) {
            BlockResourceGenerator generator = (BlockResourceGenerator)block;
            resourceLocation = generator.getBlockModelId();
        } else {
            resourceLocation = Registry.f_122824_.m_7981_((Object)block).brrp_prepend("block/");
        }
        return resourceLocation;
    }

    @Contract(pure=true)
    @PreferredEnvironment(value=Dist.CLIENT)
    public static String getTextureId(@NotNull Block block, @NotNull TextureSlot textureKey) {
        if (block instanceof BlockResourceGenerator) {
            BlockResourceGenerator generator = (BlockResourceGenerator)block;
            return generator.getTextureId(textureKey);
        }
        ResourceLocation texture = TextureRegistry.getTexture(block, textureKey);
        if (texture != null) {
            return texture.toString();
        }
        return ResourceGeneratorHelper.getBlockId(block).brrp_prepend("block/").toString();
    }

    @ApiStatus.AvailableSince(value="0.6.2")
    public static ResourceLocation getRecipeId(@NotNull ItemLike item) {
        if (item instanceof ItemResourceGenerator) {
            ItemResourceGenerator generator = (ItemResourceGenerator)item;
            return generator.getRecipeId();
        }
        return ResourceGeneratorHelper.getItemId(item);
    }

    @ApiStatus.AvailableSince(value="0.6.2")
    public static ResourceLocation getAdvancementIdForRecipe(@NotNull ItemLike item, ResourceLocation recipeId) {
        if (item instanceof ItemResourceGenerator) {
            ItemResourceGenerator generator = (ItemResourceGenerator)item;
            return generator.getAdvancementIdForRecipe(recipeId);
        }
        CreativeModeTab group = item.m_5456_().m_41471_();
        if (group != null) {
            return recipeId.brrp_prepend("recipes/" + group.m_40783_() + "/");
        }
        return recipeId.brrp_prepend("recipes/");
    }

    @Contract(pure=true)
    public static ResourceLocation getLootTableId(@NotNull BlockBehaviour block) {
        if (block instanceof BlockResourceGenerator) {
            BlockResourceGenerator generator = (BlockResourceGenerator)block;
            return generator.getLootTableId();
        }
        return block.m_60589_();
    }
}

