/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.impl;

import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import net.devtech.arrp.api.JsonSerializable;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.devtech.arrp.json.animation.JAnimation;
import net.devtech.arrp.json.blockstate.JBlockStates;
import net.devtech.arrp.json.blockstate.JState;
import net.devtech.arrp.json.lang.JLang;
import net.devtech.arrp.json.loot.JLootTable;
import net.devtech.arrp.json.models.JModel;
import net.devtech.arrp.json.recipe.JRecipe;
import net.devtech.arrp.json.tags.JTag;
import net.devtech.arrp.util.CallableFunction;
import net.devtech.arrp.util.CountingInputStream;
import net.devtech.arrp.util.UnsafeByteArrayOutputStream;
import net.minecraft.SharedConstants;
import net.minecraft.advancements.Advancement;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pers.solid.brrp.PlatformBridge;

@ApiStatus.Internal
public class RuntimeResourcePackImpl
implements RuntimeResourcePack,
PackResources {
    public static final ExecutorService EXECUTOR_SERVICE;
    public static final boolean DUMP;
    public static final boolean DEBUG_PERFORMANCE;
    public static final Gson GSON;
    @ApiStatus.AvailableSince(value="0.7.0")
    static final Set<String> KEY_WARNINGS;
    private static final Logger LOGGER;
    public final int packVersion;
    private final ResourceLocation id;
    private final Lock waiting = new ReentrantLock();
    private final Map<ResourceLocation, Supplier<byte[]>> data = new ConcurrentHashMap<ResourceLocation, Supplier<byte[]>>();
    private final Map<ResourceLocation, Supplier<byte[]>> assets = new ConcurrentHashMap<ResourceLocation, Supplier<byte[]>>();
    private final Map<ResourceLocation, JLang> langMergeable = new ConcurrentHashMap<ResourceLocation, JLang>();
    private final Map<String, Supplier<byte[]>> root = new ConcurrentHashMap<String, Supplier<byte[]>>();
    private boolean forbidsDuplicateResource = false;

    public RuntimeResourcePackImpl(ResourceLocation id) {
        this(id, SharedConstants.m_183709_().getPackVersion(com.mojang.bridge.game.PackType.RESOURCE));
    }

    public RuntimeResourcePackImpl(ResourceLocation id, int version) {
        this.packVersion = version;
        this.id = id;
    }

    private static byte[] serialize(Object object) {
        UnsafeByteArrayOutputStream ubaos = new UnsafeByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)ubaos, StandardCharsets.UTF_8);
        GSON.toJson(object, (Appendable)writer);
        try {
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ubaos.getBytes();
    }

    private static ResourceLocation fix(ResourceLocation identifier, String prefix, String append) {
        return new ResourceLocation(identifier.m_135827_(), prefix + "/" + identifier.m_135815_() + "." + append);
    }

    @Override
    public void setForbidsDuplicateResource(boolean b) {
        this.forbidsDuplicateResource = true;
    }

    @Override
    public void addRecoloredImage(ResourceLocation identifier, InputStream target, IntUnaryOperator operator) {
        this.addLazyResource(PackType.CLIENT_RESOURCES, RuntimeResourcePackImpl.fix(identifier, "textures", "png"), (i, r) -> {
            try {
                CountingInputStream is = new CountingInputStream(target);
                BufferedImage base = ImageIO.read(is);
                BufferedImage recolored = new BufferedImage(base.getWidth(), base.getHeight(), 2);
                for (int y = 0; y < base.getHeight(); ++y) {
                    for (int x = 0; x < base.getWidth(); ++x) {
                        recolored.setRGB(x, y, operator.applyAsInt(base.getRGB(x, y)));
                    }
                }
                UnsafeByteArrayOutputStream baos = new UnsafeByteArrayOutputStream(is.bytes());
                ImageIO.write((RenderedImage)recolored, "png", baos);
                return baos.getBytes();
            }
            catch (Throwable e) {
                LOGGER.error("Failed to add resources:", e);
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public byte[] addLang(ResourceLocation identifier, JLang lang) {
        return this.addAsset(RuntimeResourcePackImpl.fix(identifier, "lang", "json"), RuntimeResourcePackImpl.serialize(lang));
    }

    @Override
    public void mergeLang(ResourceLocation identifier, JLang lang) {
        this.langMergeable.compute(identifier, (identifier1, existingLang) -> {
            JLang newLang;
            if (existingLang == null) {
                newLang = new JLang();
                ResourceLocation path = RuntimeResourcePackImpl.fix(identifier, "lang", "json");
                this.assets.put(path, new Memoized<ResourceLocation>((pack, identifier2) -> RuntimeResourcePackImpl.serialize(newLang), path));
            } else {
                newLang = existingLang;
            }
            newLang.putAll(lang);
            return newLang;
        });
    }

    @Override
    public byte[] addLootTable(ResourceLocation identifier, JLootTable table) {
        return this.addData(RuntimeResourcePackImpl.fix(identifier, "loot_tables", "json"), RuntimeResourcePackImpl.serialize(table));
    }

    @Override
    @ApiStatus.AvailableSince(value="0.8.0")
    public byte[] addLootTable(ResourceLocation identifier, LootTable lootTable) {
        return this.addData(RuntimeResourcePackImpl.fix(identifier, "loot_tables", "json"), RuntimeResourcePackImpl.serialize(lootTable));
    }

    @Override
    public Future<byte[]> addAsyncResource(PackType type, ResourceLocation path, CallableFunction<ResourceLocation, byte[]> data) {
        Future<byte[]> future = EXECUTOR_SERVICE.submit(() -> (byte[])data.get(path));
        Map<ResourceLocation, Supplier<byte[]>> sys = this.getSys(type);
        if (this.forbidsDuplicateResource && sys.containsKey(path)) {
            throw new IllegalArgumentException(String.format("Duplicate resource id %s in runtime resource pack %s.", path, this.m_8017_()));
        }
        sys.put(path, () -> {
            try {
                return (byte[])future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
        return future;
    }

    @Override
    public void addLazyResource(PackType type, ResourceLocation path, BiFunction<RuntimeResourcePack, ResourceLocation, byte[]> func) {
        Map<ResourceLocation, Supplier<byte[]>> sys = this.getSys(type);
        if (this.forbidsDuplicateResource && sys.containsKey(path)) {
            throw new IllegalArgumentException(String.format("Duplicate resource id %s in runtime resource pack %s.", path, this.m_8017_()));
        }
        sys.put(path, new Memoized<ResourceLocation>(func, path));
    }

    @Override
    public byte[] addResource(PackType type, ResourceLocation path, byte[] data) {
        Map<ResourceLocation, Supplier<byte[]>> sys = this.getSys(type);
        if (this.forbidsDuplicateResource && sys.containsKey(path)) {
            throw new IllegalArgumentException(String.format("Duplicate resource id %s in runtime resource pack %s.", path, this.m_8017_()));
        }
        sys.put(path, (Supplier<byte[]>)Suppliers.ofInstance((Object)data));
        return data;
    }

    @Override
    public Future<byte[]> addAsyncRootResource(String path, CallableFunction<String, byte[]> data) {
        if (this.forbidsDuplicateResource && this.root.containsKey(path)) {
            throw new IllegalArgumentException(String.format("Duplicate root resource id %s in runtime resource pack %s!", path, this.m_8017_()));
        }
        Future<byte[]> future = EXECUTOR_SERVICE.submit(() -> (byte[])data.get(path));
        this.root.put(path, () -> {
            try {
                return (byte[])future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
        return future;
    }

    @Override
    public void addLazyRootResource(String path, BiFunction<RuntimeResourcePack, String, byte[]> data) {
        if (this.forbidsDuplicateResource && this.root.containsKey(path)) {
            throw new IllegalArgumentException(String.format("Duplicate root resource id %s in runtime resource pack %s!", path, this.m_8017_()));
        }
        this.root.put(path, new Memoized<String>(data, path));
    }

    @Override
    public byte[] addRootResource(String path, byte[] data) {
        if (this.forbidsDuplicateResource && this.root.containsKey(path)) {
            throw new IllegalArgumentException(String.format("Duplicate root resource id %s in runtime resource pack %s!", path, this.m_8017_()));
        }
        this.root.put(path, (Supplier<byte[]>)Suppliers.ofInstance((Object)data));
        return data;
    }

    @Override
    public byte[] addAsset(ResourceLocation id, byte[] data) {
        if (this.forbidsDuplicateResource && this.assets.containsKey(id)) {
            throw new IllegalArgumentException(String.format("Duplicate asset id %s in runtime resource pack %s!", id, this.m_8017_()));
        }
        this.assets.put(id, (Supplier<byte[]>)Suppliers.ofInstance((Object)data));
        return data;
    }

    @Override
    public byte[] addData(ResourceLocation id, byte[] data) {
        if (this.forbidsDuplicateResource && this.data.containsKey(id)) {
            throw new IllegalArgumentException(String.format("Duplicate data id %s in runtime resource pack %s!", id, this.m_8017_()));
        }
        this.data.put(id, (Supplier<byte[]>)Suppliers.ofInstance((Object)data));
        return data;
    }

    @Override
    public byte[] addModel(JModel model, ResourceLocation id) {
        return this.addAsset(RuntimeResourcePackImpl.fix(id, "models", "json"), RuntimeResourcePackImpl.serialize(model));
    }

    @Override
    public byte[] addBlockState(JState state, ResourceLocation identifier) {
        return this.addAsset(RuntimeResourcePackImpl.fix(identifier, "blockstates", "json"), RuntimeResourcePackImpl.serialize(state));
    }

    @Override
    public byte[] addBlockState(JBlockStates state, ResourceLocation id) {
        return this.addAsset(RuntimeResourcePackImpl.fix(id, "blockstates", "json"), RuntimeResourcePackImpl.serialize(state));
    }

    @Override
    @ApiStatus.AvailableSince(value="0.8.0")
    public byte[] addBlockState(BlockStateGenerator state, ResourceLocation id) {
        return this.addAsset(RuntimeResourcePackImpl.fix(id, "blockstates", "json"), RuntimeResourcePackImpl.serialize(state));
    }

    @Override
    public byte[] addTexture(ResourceLocation id, BufferedImage image) {
        UnsafeByteArrayOutputStream ubaos = new UnsafeByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", ubaos);
        }
        catch (IOException e) {
            throw new RuntimeException("impossible.", e);
        }
        return this.addAsset(RuntimeResourcePackImpl.fix(id, "textures", "png"), ubaos.getBytes());
    }

    @Override
    public byte[] addAnimation(ResourceLocation id, JAnimation animation) {
        return this.addAsset(RuntimeResourcePackImpl.fix(id, "textures", "png.mcmeta"), RuntimeResourcePackImpl.serialize(animation));
    }

    @Override
    public byte[] addTag(ResourceLocation id, JTag tag) {
        return this.addData(RuntimeResourcePackImpl.fix(id, "tags", "json"), RuntimeResourcePackImpl.serialize(tag));
    }

    @Override
    public byte[] addRecipe(ResourceLocation id, JRecipe recipe) {
        return this.addData(RuntimeResourcePackImpl.fix(id, "recipes", "json"), RuntimeResourcePackImpl.serialize(recipe));
    }

    @Override
    @ApiStatus.AvailableSince(value="0.8.0")
    public byte[] addRecipe(ResourceLocation id, FinishedRecipe recipe) {
        return this.addData(RuntimeResourcePackImpl.fix(id, "recipes", "json"), RuntimeResourcePackImpl.serialize(recipe));
    }

    @Override
    public byte[] addAdvancement(ResourceLocation id, Advancement.Builder advancement) {
        return this.addData(RuntimeResourcePackImpl.fix(id, "advancements", "json"), RuntimeResourcePackImpl.serialize(advancement));
    }

    @Override
    public Future<?> async(Consumer<RuntimeResourcePack> action) {
        this.lock();
        return EXECUTOR_SERVICE.submit(() -> {
            action.accept(this);
            this.waiting.unlock();
        });
    }

    @Override
    public void dumpDirect(Path output) {
        LOGGER.info("Dumping {} in the path {}.", (Object)this.m_8017_(), (Object)output);
        try {
            for (Map.Entry<String, Supplier<byte[]>> entry : this.root.entrySet()) {
                Path path = output.resolve(String.join((CharSequence)"/", entry.getKey()));
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.write(path, entry.getValue().get(), new OpenOption[0]);
            }
            Path assets = output.resolve("assets");
            Files.createDirectories(assets, new FileAttribute[0]);
            for (Map.Entry<ResourceLocation, Supplier<byte[]>> entry : this.assets.entrySet()) {
                this.write(assets, entry.getKey(), entry.getValue().get());
            }
            Path path = output.resolve("data");
            Files.createDirectories(path, new FileAttribute[0]);
            for (Map.Entry<ResourceLocation, Supplier<byte[]>> entry : this.data.entrySet()) {
                this.write(path, entry.getKey(), entry.getValue().get());
            }
            LOGGER.info("Dumping {} finished.", (Object)this.m_8017_());
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void load(Path dir) throws IOException {
        try (Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);){
            for (Path file : () -> stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(dir::relativize).iterator()) {
                String path;
                String s = file.toString();
                if (s.startsWith("assets")) {
                    path = s.substring("assets".length() + 1);
                    this.load(path, this.assets, Files.readAllBytes(file));
                    continue;
                }
                if (s.startsWith("data")) {
                    path = s.substring("data".length() + 1);
                    this.load(path, this.data, Files.readAllBytes(file));
                    continue;
                }
                byte[] data = Files.readAllBytes(file);
                this.root.put(s, (Supplier<byte[]>)Suppliers.ofInstance((Object)data));
            }
        }
    }

    @Override
    @Deprecated
    public void dump(File output) {
        this.dump(Paths.get(output.toURI()));
    }

    @Override
    public void dump(ZipOutputStream zos) throws IOException {
        ResourceLocation id;
        this.lock();
        for (Map.Entry<String, Supplier<byte[]>> entry : this.root.entrySet()) {
            zos.putNextEntry(new ZipEntry(String.join((CharSequence)"/", entry.getKey())));
            zos.write(entry.getValue().get());
            zos.closeEntry();
        }
        for (Map.Entry<String, Supplier<byte[]>> entry : this.assets.entrySet()) {
            id = (ResourceLocation)entry.getKey();
            zos.putNextEntry(new ZipEntry("assets/" + id.m_135827_() + "/" + id.m_135815_()));
            zos.write(entry.getValue().get());
            zos.closeEntry();
        }
        for (Map.Entry<String, Supplier<byte[]>> entry : this.data.entrySet()) {
            id = (ResourceLocation)entry.getKey();
            zos.putNextEntry(new ZipEntry("data/" + id.m_135827_() + "/" + id.m_135815_()));
            zos.write(entry.getValue().get());
            zos.closeEntry();
        }
        this.waiting.unlock();
    }

    @Override
    public void load(ZipInputStream stream) throws IOException {
        ZipEntry entry;
        while ((entry = stream.getNextEntry()) != null) {
            String path;
            String s = entry.toString();
            if (s.startsWith("assets")) {
                path = s.substring("assets".length() + 1);
                this.load(path, this.assets, this.read(entry, stream));
                continue;
            }
            if (s.startsWith("data")) {
                path = s.substring("data".length() + 1);
                this.load(path, this.data, this.read(entry, stream));
                continue;
            }
            byte[] data = this.read(entry, stream);
            this.root.put(s, (Supplier<byte[]>)Suppliers.ofInstance((Object)data));
        }
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    public InputStream m_5542_(String fileName) {
        if (!fileName.contains("/") && !fileName.contains("\\")) {
            this.lock();
            Supplier<byte[]> supplier = this.root.get(fileName);
            if (supplier == null) {
                this.waiting.unlock();
                return null;
            }
            this.waiting.unlock();
            return new ByteArrayInputStream(supplier.get());
        }
        throw new IllegalArgumentException("File name can't be a path");
    }

    @Nullable
    public InputStream m_8031_(PackType type, ResourceLocation id) {
        this.lock();
        Supplier<byte[]> supplier = this.getSys(type).get(id);
        this.waiting.unlock();
        return supplier == null ? null : new ByteArrayInputStream(supplier.get());
    }

    public Collection<ResourceLocation> m_214146_(PackType type, String namespace, String prefix, Predicate<ResourceLocation> allowedPathPredicate) {
        this.lock();
        HashSet<ResourceLocation> identifiers = new HashSet<ResourceLocation>();
        for (ResourceLocation identifier : this.getSys(type).keySet()) {
            if (!identifier.m_135827_().equals(namespace) || !identifier.m_135815_().startsWith(prefix) || !allowedPathPredicate.test(identifier)) continue;
            identifiers.add(identifier);
        }
        this.waiting.unlock();
        return identifiers;
    }

    public boolean m_7211_(PackType type, ResourceLocation id) {
        this.lock();
        boolean contains = this.getSys(type).containsKey(id);
        this.waiting.unlock();
        return contains;
    }

    public Set<String> m_5698_(PackType type) {
        this.lock();
        HashSet<String> namespaces = new HashSet<String>();
        for (ResourceLocation identifier : this.getSys(type).keySet()) {
            namespaces.add(identifier.m_135827_());
        }
        this.waiting.unlock();
        return namespaces;
    }

    public <T> T m_5550_(MetadataSectionSerializer<T> metaReader) {
        InputStream stream = this.m_5542_("pack.mcmeta");
        if (stream != null) {
            return (T)AbstractPackResources.m_10214_(metaReader, (InputStream)stream);
        }
        if (metaReader.m_7991_().equals("pack")) {
            JsonObject object = new JsonObject();
            object.addProperty("pack_format", (Number)this.packVersion);
            object.add("description", Component.Serializer.m_130716_((Component)this.getDescription()));
            return (T)metaReader.m_6322_(object);
        }
        if (KEY_WARNINGS.add(metaReader.m_7991_())) {
            LOGGER.info("'" + metaReader.m_7991_() + "' is an unsupported metadata key");
        }
        return null;
    }

    public String m_8017_() {
        return "Runtime Resource Pack " + this.id.toString();
    }

    public void close() {
        LOGGER.info("Closing {}.", (Object)this.m_8017_());
        this.lock();
        if (DUMP) {
            this.dump();
        }
        this.waiting.unlock();
    }

    protected byte[] read(ZipEntry entry, InputStream stream) throws IOException {
        byte[] data = new byte[Math.toIntExact(entry.getSize())];
        if (stream.read(data) != data.length) {
            throw new IOException("Zip stream was cut off! (maybe incorrect zip entry length? maybe u didn't flush your stream?)");
        }
        return data;
    }

    protected void load(String fullPath, Map<ResourceLocation, Supplier<byte[]>> map, byte[] data) {
        int sep = fullPath.indexOf(47);
        String namespace = fullPath.substring(0, sep);
        String path = fullPath.substring(sep + 1);
        map.put(new ResourceLocation(namespace, path), (Supplier<byte[]>)Suppliers.ofInstance((Object)data));
    }

    private void lock() {
        if (!this.waiting.tryLock()) {
            if (DEBUG_PERFORMANCE) {
                long start = System.currentTimeMillis();
                this.waiting.lock();
                long end = System.currentTimeMillis();
                LOGGER.warn("Waited " + (end - start) + "ms for lock in RRP: " + this.id);
            } else {
                this.waiting.lock();
            }
        }
    }

    private void write(Path dir, ResourceLocation identifier, byte[] data) {
        try {
            Path file = dir.resolve(identifier.m_135827_()).resolve(identifier.m_135815_());
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            try (OutputStream output = Files.newOutputStream(file, new OpenOption[0]);){
                output.write(data);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clearResources(PackType side) {
        this.getSys(side).clear();
        if (side == PackType.CLIENT_RESOURCES) {
            this.langMergeable.clear();
        }
    }

    @Override
    public void clearResources() {
        this.assets.clear();
        this.data.clear();
        this.root.clear();
        this.langMergeable.clear();
    }

    @Override
    public void clearRootResources() {
        this.root.clear();
    }

    private Map<ResourceLocation, Supplier<byte[]>> getSys(PackType side) {
        return side == PackType.CLIENT_RESOURCES ? this.assets : this.data;
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeHierarchyAdapter(JsonSerializable.class, JsonSerializable.SERIALIZER).registerTypeHierarchyAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeHierarchyAdapter(NumberProvider.class, NumberProviders.m_165737_()).registerTypeHierarchyAdapter(LootTable.class, (Object)new LootTable.Serializer()).registerTypeHierarchyAdapter(BlockStateGenerator.class, (builder, type, jsonSerializationContext) -> (JsonElement)builder.get()).registerTypeHierarchyAdapter(FinishedRecipe.class, (recipe, typeOrSrc, context) -> recipe.m_125966_()).registerTypeHierarchyAdapter(Advancement.Builder.class, (builder, type, jsonSerializationContext) -> builder.m_138400_()).registerTypeHierarchyAdapter(StringRepresentable.class, (src, typeOfSrc, context) -> new JsonPrimitive(src.m_7912_())).create();
        KEY_WARNINGS = Collections.newSetFromMap(new ConcurrentHashMap());
        LOGGER = LoggerFactory.getLogger(RuntimeResourcePackImpl.class);
        Properties properties = new Properties();
        int processors = Math.max(Runtime.getRuntime().availableProcessors() / 2 - 1, 1);
        boolean dump = false;
        boolean performance = false;
        properties.setProperty("threads", String.valueOf(processors));
        properties.setProperty("dump assets", "false");
        properties.setProperty("debug performance", "false");
        File file = PlatformBridge.getInstance().getConfigDir().resolve("rrp.properties").toFile();
        try (FileReader reader = new FileReader(file);){
            properties.load(reader);
            processors = Integer.parseInt(properties.getProperty("threads"));
            dump = Boolean.parseBoolean(properties.getProperty("dump assets"));
            performance = Boolean.parseBoolean(properties.getProperty("debug performance"));
        }
        catch (Throwable t) {
            LOGGER.warn("Invalid config, creating new one!");
            file.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(file);){
                properties.store(writer, "number of threads RRP should use for generating resources");
            }
            catch (IOException ex) {
                LOGGER.error("Unable to write to RRP config!", (Throwable)ex);
            }
        }
        EXECUTOR_SERVICE = Executors.newFixedThreadPool(processors, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("BRRP-Workers-%s").build());
        DUMP = dump;
        DEBUG_PERFORMANCE = performance;
        KEY_WARNINGS.add("filter");
        KEY_WARNINGS.add("language");
    }

    private class Memoized<T>
    implements Supplier<byte[]> {
        private final BiFunction<RuntimeResourcePack, T, byte[]> func;
        private final T path;
        private byte[] data;

        public Memoized(BiFunction<RuntimeResourcePack, T, byte[]> func, T path) {
            this.func = func;
            this.path = path;
        }

        @Override
        public byte[] get() {
            if (this.data == null) {
                this.data = this.func.apply(RuntimeResourcePackImpl.this, (RuntimeResourcePack)this.path);
            }
            return this.data;
        }
    }
}

