/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.blockstate;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.List;
import net.devtech.arrp.ARRP;
import net.devtech.arrp.annotations.PreferredEnvironment;
import net.devtech.arrp.api.JsonSerializable;
import net.devtech.arrp.json.blockstate.JBlockModel;
import net.devtech.arrp.json.blockstate.JMultipart;
import net.devtech.arrp.json.blockstate.JState;
import net.devtech.arrp.json.blockstate.JVariants;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

@PreferredEnvironment(value=Dist.CLIENT)
public class JBlockStates
implements JsonSerializable {
    public final JVariants variants;
    public final List<JMultipart> multiparts;

    @ApiStatus.Internal
    protected JBlockStates(JVariants variants, List<JMultipart> multiparts) {
        this.variants = variants;
        this.multiparts = multiparts;
    }

    @Contract(value="_ -> new", pure=true)
    public static JBlockStates ofVariants(JVariants variants) {
        return new JBlockStates(variants, null);
    }

    @Contract(value="_ -> new", pure=true)
    public static JBlockStates ofMultiparts(List<JMultipart> multiparts) {
        return new JBlockStates(null, multiparts);
    }

    @Contract(value="_ -> new", pure=true)
    public static JBlockStates ofMultiparts(JMultipart ... multiparts) {
        return JBlockStates.ofMultiparts(Lists.newArrayList((Object[])multiparts));
    }

    @Contract(value="_, _ -> this", mutates="this")
    public JBlockStates addVariant(String variant, JBlockModel ... modelDefinition) {
        if (variant == null) {
            throw new IllegalStateException("A block states definition can only have either variants or multiparts, not both");
        }
        this.variants.addVariant(variant, modelDefinition);
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    public JBlockStates add(JMultipart multipart) {
        if (this.multiparts == null) {
            throw new IllegalStateException("A block states definition can only have either variants or multipart, not both");
        }
        this.multiparts.add(multipart);
        return this;
    }

    public static JBlockStates of(JState jState) {
        JBlockStates instance;
        if (jState.variants.isEmpty()) {
            instance = JBlockStates.ofMultiparts(jState.multiparts);
        } else {
            instance = JBlockStates.ofVariants(JVariants.upgrade(jState.variants.get(0)));
            if (jState.variants.size() > 1) {
                ARRP.LOGGER.warn("Only one variant definition is allowed, but provided multiple. Only the first one will be used.");
            }
        }
        return instance;
    }

    @Contract(value="_ -> new", pure=true)
    public static JBlockStates simple(ResourceLocation blockModelId) {
        return JBlockStates.ofVariants(JVariants.ofNoVariants(new JBlockModel(blockModelId)));
    }

    @Contract(value="_ -> new", pure=true)
    public static JBlockStates simpleRandomRotation(ResourceLocation blockModelId) {
        return JBlockStates.ofVariants(JVariants.ofNoVariants(JVariants.ofRandomRotation(new JBlockModel(blockModelId))));
    }

    @Contract(value="_, _ -> new", pure=true)
    public static JBlockStates simpleHorizontalFacing(ResourceLocation blockModelId, boolean uvlock) {
        return JBlockStates.ofVariants(JVariants.ofHorizontalFacing(new JBlockModel(blockModelId).uvlock(uvlock)));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static JBlockStates simpleSlab(ResourceLocation baseBlockModelId, ResourceLocation bottomSlabModelId, ResourceLocation topSlabModelId) {
        return JBlockStates.ofVariants(JVariants.ofSlab(new JBlockModel(baseBlockModelId), bottomSlabModelId, topSlabModelId));
    }

    @Contract(value="_ -> new", pure=true)
    public static JBlockStates delegate(BlockStateGenerator delegate) {
        return new Delegate(delegate);
    }

    @Override
    public JsonElement serialize(Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        if (this.variants != null) {
            object.add("variants", context.serialize((Object)this.variants));
        }
        if (this.multiparts != null) {
            object.add("multipart", context.serialize(this.multiparts));
        }
        return object;
    }

    @ApiStatus.Internal
    private static final class Delegate
    extends JBlockStates {
        private final BlockStateGenerator delegate;

        private Delegate(BlockStateGenerator delegate) {
            super(null, null);
            this.delegate = delegate;
        }

        @Override
        public JsonElement serialize(Type typeOfSrc, JsonSerializationContext context) {
            return (JsonElement)this.delegate.get();
        }
    }
}

