/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.blockstate;

import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.devtech.arrp.annotations.PreferredEnvironment;
import net.devtech.arrp.api.JsonSerializable;
import net.devtech.arrp.json.blockstate.JBlockModel;
import net.devtech.arrp.json.blockstate.JWhen;
import net.minecraft.data.models.blockstates.Condition;
import net.minecraftforge.api.distmarker.Dist;
import org.jetbrains.annotations.Contract;

@PreferredEnvironment(value=Dist.CLIENT)
public class JMultipart
implements Cloneable,
JsonSerializable {
    public final List<JBlockModel> apply;
    public Condition when;

    public JMultipart() {
        this.apply = new ArrayList<JBlockModel>();
    }

    public JMultipart(JBlockModel ... apply) {
        this.apply = Lists.newArrayList((Object[])apply);
    }

    public JMultipart(List<JBlockModel> apply) {
        this.apply = apply;
    }

    public JMultipart(Condition when, JBlockModel ... apply) {
        this(apply);
        this.when = when;
    }

    public JMultipart clone() {
        try {
            return (JMultipart)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    @Deprecated
    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JMultipart when(JWhen when) {
        return this.when((Condition)when);
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JMultipart when(Condition when) {
        this.when = when;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JMultipart addModel(JBlockModel model) {
        this.apply.add(model);
        return this;
    }

    @Override
    public JsonElement serialize(Type typeOfSrc, JsonSerializationContext context) {
        JsonObject obj = new JsonObject();
        if (this.apply.size() == 1) {
            obj.add("apply", context.serialize((Object)this.apply.get(0)));
        } else {
            obj.add("apply", context.serialize(this.apply));
        }
        obj.add("when", context.serialize((Object)this.when));
        return obj;
    }
}

