/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.blockstate;

import com.google.common.collect.ForwardingList;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.devtech.arrp.annotations.PreferredEnvironment;
import net.devtech.arrp.api.JsonSerializable;
import net.devtech.arrp.impl.RuntimeResourcePackImpl;
import net.minecraft.data.models.blockstates.Condition;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraftforge.api.distmarker.Dist;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@PreferredEnvironment(value=Dist.CLIENT)
public class JWhenLogical
extends ForwardingList<Condition>
implements Cloneable,
Condition,
JsonSerializable {
    @NotNull
    public final Condition.Operation operator;
    @NotNull
    public final List<Condition> components;

    @ApiStatus.Internal
    public JWhenLogical(@NotNull Condition.Operation operator, @NotNull List<Condition> components) {
        this.operator = operator;
        this.components = components;
    }

    @Contract(value="_ -> new")
    public static JWhenLogical anyOf(Condition ... conditions) {
        return new JWhenLogical(Condition.Operation.OR, Lists.newArrayList((Object[])conditions));
    }

    @Contract(value="_ -> new")
    public static JWhenLogical allOf(Condition ... conditions) {
        return new JWhenLogical(Condition.Operation.AND, Lists.newArrayList((Object[])conditions));
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JWhenLogical addCondition(Condition condition) {
        this.components.add(condition);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JWhenLogical addCondition(Condition ... condition) {
        this.components.addAll(Arrays.asList(condition));
        return this;
    }

    @NotNull
    protected List<Condition> delegate() {
        return this.components;
    }

    @Override
    public JsonElement serialize(Type typeOfSrc, JsonSerializationContext context) {
        JsonArray jsonArray = new JsonArray();
        this.components.stream().map(Supplier::get).forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
        JsonObject jsonObject = new JsonObject();
        jsonObject.add(this.operator.name(), (JsonElement)jsonArray);
        return jsonObject;
    }

    public void m_7619_(StateDefinition<?, ?> stateManager) {
        this.components.forEach(component -> component.m_7619_(stateManager));
    }

    public JsonElement get() {
        return RuntimeResourcePackImpl.GSON.toJsonTree((Object)this);
    }

    @ApiStatus.AvailableSince(value="0.8.0")
    public JWhenLogical clone() {
        try {
            return (JWhenLogical)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

