/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.loot;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.devtech.arrp.api.JsonSerializable;
import net.devtech.arrp.impl.RuntimeResourcePackImpl;
import net.devtech.arrp.json.loot.JCondition;
import net.devtech.arrp.json.loot.JFunction;
import net.minecraft.core.Registry;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

public class JEntry
implements Cloneable {
    public String type;
    public String name;
    public List<JEntry> children;
    public Boolean expand;
    public List<JFunction> functions;
    public List<JCondition> conditions;
    public Integer weight;
    public Integer quality;

    public JEntry() {
    }

    public JEntry(String type, String name) {
        this();
        this.type = type;
        this.name = name;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JEntry type(String type) {
        this.type = type;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    @ApiStatus.AvailableSince(value="0.8.0")
    public JEntry type(LootPoolEntryType type) {
        this.type = Objects.requireNonNull(Registry.f_122875_.m_7981_((Object)type), "The loot pool entry type seems not registered yet!").toString();
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JEntry name(String name) {
        this.name = name;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JEntry child(JEntry child) {
        if (this == child) {
            throw new IllegalArgumentException("Can't add entry as its own child!");
        }
        if (this.children == null) {
            this.children = new ArrayList<JEntry>();
        }
        this.children.add(child);
        return this;
    }

    @Deprecated
    @Contract(value="_ -> this", mutates="this")
    public JEntry child(String child) {
        return this.child((JEntry)RuntimeResourcePackImpl.GSON.fromJson(child, JEntry.class));
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JEntry expand(Boolean expand) {
        this.expand = expand;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JEntry function(JFunction function) {
        if (this.functions == null) {
            this.functions = new ArrayList<JFunction>();
        }
        this.functions.add(function);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JEntry function(String function) {
        return this.function(new JFunction(function));
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JEntry condition(JCondition condition) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<JCondition>();
        }
        this.conditions.add(condition);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JEntry condition(LootItemCondition condition) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<JCondition>();
        }
        this.conditions.add(JCondition.delegate(condition));
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JEntry condition(LootItemCondition.Builder condition) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<JCondition>();
        }
        this.conditions.add(JCondition.delegate(condition));
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JEntry condition(String condition) {
        return this.condition(new JCondition(condition));
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JEntry weight(Integer weight) {
        this.weight = weight;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JEntry quality(Integer quality) {
        this.quality = quality;
        return this;
    }

    public JEntry clone() {
        try {
            return (JEntry)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    @ApiStatus.AvailableSince(value="0.8.0")
    @Contract(value="_ -> new")
    public static JEntry delegate(LootPoolEntryContainer delegate) {
        return new Delegate(delegate);
    }

    @ApiStatus.AvailableSince(value="0.8.0")
    @Contract(value="_ -> new")
    public static <T extends LootPoolEntryContainer.Builder<T>> JEntry delegate(LootPoolEntryContainer.Builder<T> delegate) {
        return new DelegateFromBuilder<T>(delegate);
    }

    @ApiStatus.Internal
    private static final class Delegate
    extends JEntry
    implements JsonSerializable {
        private static final Gson GSON = Deserializers.m_78800_().create();
        private final LootPoolEntryContainer delegate;

        private Delegate(LootPoolEntryContainer delegate) {
            this.delegate = delegate;
        }

        @Override
        public JsonElement serialize(Type typeOfSrc, JsonSerializationContext context) {
            return GSON.toJsonTree((Object)this.delegate);
        }
    }

    @ApiStatus.Internal
    @ApiStatus.AvailableSince(value="0.8.0")
    private static final class DelegateFromBuilder<T extends LootPoolEntryContainer.Builder<T>>
    extends JEntry
    implements JsonSerializable {
        private final LootPoolEntryContainer.Builder<T> delegate;

        private DelegateFromBuilder(LootPoolEntryContainer.Builder<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public JEntry condition(LootItemCondition.Builder condition) {
            this.delegate.m_79080_(condition);
            return this;
        }

        @Override
        public JsonElement serialize(Type typeOfSrc, JsonSerializationContext context) {
            return Delegate.GSON.toJsonTree((Object)this.delegate.m_7512_());
        }

        @Override
        public JEntry weight(Integer weight) {
            Preconditions.checkNotNull((Object)weight, (Object)"The weight must not be null");
            LootPoolEntryContainer.Builder<T> builder = this.delegate;
            if (!(builder instanceof LootPoolSingletonContainer.Builder)) {
                throw new UnsupportedOperationException("Only LeafEntry.Builder can set weight!");
            }
            LootPoolSingletonContainer.Builder leafEntryBuilder = (LootPoolSingletonContainer.Builder)builder;
            leafEntryBuilder.m_79707_(weight.intValue());
            return this;
        }

        @Override
        public JEntry quality(Integer quality) {
            Preconditions.checkNotNull((Object)this.weight, (Object)"The quality must not be null");
            LootPoolEntryContainer.Builder<T> builder = this.delegate;
            if (!(builder instanceof LootPoolSingletonContainer.Builder)) {
                throw new UnsupportedOperationException("Only LeafEntry.Builder can set quality!");
            }
            LootPoolSingletonContainer.Builder leafEntryBuilder = (LootPoolSingletonContainer.Builder)builder;
            leafEntryBuilder.m_79711_(quality.intValue());
            return this;
        }
    }
}

