/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.models;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.function.Function;
import net.devtech.arrp.annotations.PreferredEnvironment;
import net.devtech.arrp.json.models.JFace;
import net.devtech.arrp.json.models.JFaces;
import net.devtech.arrp.json.models.JRotation;
import net.minecraft.core.Direction;
import net.minecraftforge.api.distmarker.Dist;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

@PreferredEnvironment(value=Dist.CLIENT)
public class JElement
implements Cloneable {
    public final float[] from = new float[3];
    public final float[] to = new float[3];
    public JRotation rotation;
    public Boolean shade;
    public JFaces faces;

    @ApiStatus.Internal
    public JElement() {
    }

    @Contract(value="_,_,_,_,_,_ -> new")
    public static JElement of(float x1, float y1, float z1, float x2, float y2, float z2) {
        return new JElement().from(x1, y1, z1).to(x2, y2, z2);
    }

    @CanIgnoreReturnValue
    @Contract(value="_,_,_ -> this", mutates="this")
    public JElement from(float x, float y, float z) {
        this.from[0] = x;
        this.from[1] = y;
        this.from[2] = z;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_,_,_ -> this", mutates="this")
    public JElement to(float x, float y, float z) {
        this.to[0] = x;
        this.to[1] = y;
        this.to[2] = z;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JElement rotation(JRotation rotation) {
        this.rotation = rotation;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JElement shade(boolean shade) {
        this.shade = shade;
        return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    @Contract(value="-> this", mutates="this")
    public JElement shade() {
        this.shade = false;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JElement faces(JFaces faces) {
        this.faces = faces;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _ -> this", mutates="this")
    public JElement addFace(Direction direction, JFace face) {
        if (this.faces == null) {
            this.faces = new JFaces();
        }
        this.faces.set(direction, face);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JElement addAllFaces(JFace face) {
        if (this.faces == null) {
            this.faces = new JFaces();
        }
        this.faces.setAllFaces(face);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JElement addAllFaces(Function<Direction, JFace> faces) {
        if (this.faces == null) {
            this.faces = new JFaces();
        }
        this.faces.setAllFaces(faces);
        return this;
    }

    public JElement clone() {
        try {
            return (JElement)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }
}

