/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.models;

import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.devtech.arrp.annotations.PreferredEnvironment;
import net.devtech.arrp.json.loot.JCondition;
import net.devtech.arrp.json.models.JDisplay;
import net.devtech.arrp.json.models.JElement;
import net.devtech.arrp.json.models.JFace;
import net.devtech.arrp.json.models.JFaces;
import net.devtech.arrp.json.models.JOverride;
import net.devtech.arrp.json.models.JPosition;
import net.devtech.arrp.json.models.JRotation;
import net.devtech.arrp.json.models.JTextures;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

@PreferredEnvironment(value=Dist.CLIENT)
public class JModel
implements Cloneable {
    public String parent;
    public Boolean ambientocclusion;
    public JDisplay display;
    public JTextures textures;
    public List<JElement> elements;
    public List<JOverride> overrides;

    public JModel() {
    }

    public JModel(String parent) {
        this();
        this.parent = parent;
    }

    public JModel(ResourceLocation parent) {
        this();
        this.parent = parent.toString();
    }

    @ApiStatus.AvailableSince(value="0.8.0")
    @Contract(value="_ -> new", pure=true)
    public static JModel ofGenerated(String layer0) {
        return new JModel("item/generated").textures(JTextures.ofLayer0(layer0));
    }

    @ApiStatus.AvailableSince(value="0.8.0")
    @Contract(value="_ -> new", pure=true)
    public static JModel ofHandheld(String layer0) {
        return new JModel("item/handheld").textures(JTextures.ofLayer0(layer0));
    }

    @Deprecated
    @Contract(value="-> new")
    public static JModel modelKeepElements() {
        JModel model = new JModel();
        model.elements = null;
        return model;
    }

    @Deprecated
    @Contract(value="_ -> new")
    public static JModel modelKeepElements(String parent) {
        JModel model = new JModel();
        model.parent = parent;
        model.elements = null;
        return model;
    }

    @Deprecated
    @Contract(value="_ -> new")
    public static JModel modelKeepElements(ResourceLocation identifier) {
        return JModel.modelKeepElements(identifier.toString());
    }

    @Deprecated
    @Contract(value="-> new")
    public static JModel model() {
        return new JModel();
    }

    @Deprecated
    @Contract(value="_ -> new")
    public static JModel model(String parent) {
        JModel model = new JModel();
        model.parent = parent;
        return model;
    }

    @Deprecated
    public static JOverride override(JCondition predicate, ResourceLocation model) {
        return new JOverride(predicate, model.toString());
    }

    @Deprecated
    @Contract(value="-> new")
    public static JCondition condition() {
        return new JCondition((String)null);
    }

    @Deprecated
    @Contract(value="_ -> new")
    public static JModel model(ResourceLocation identifier) {
        return JModel.model(identifier.toString());
    }

    @Deprecated
    @Contract(value="-> new")
    public static JDisplay display() {
        return new JDisplay();
    }

    @Deprecated
    @Contract(value="-> new")
    public static JElement element() {
        return new JElement();
    }

    @Deprecated
    @Contract(value="_ -> new")
    public static JFace face(String texture) {
        return new JFace(texture);
    }

    @Deprecated
    @Contract(value="-> new")
    public static JFaces faces() {
        return new JFaces();
    }

    @Deprecated
    @Contract(value="-> new")
    public static JPosition position() {
        return new JPosition();
    }

    @Deprecated
    @Contract(value="_ -> new")
    public static JRotation rotation(Direction.Axis axis) {
        return new JRotation(axis);
    }

    @Deprecated
    @Contract(value="-> new")
    public static JTextures textures() {
        return new JTextures();
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JModel addOverride(JOverride override) {
        if (this.overrides == null) {
            this.overrides = Lists.newArrayList((Object[])new JOverride[]{override});
        } else {
            this.overrides.add(override);
        }
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JModel addOverride(JOverride ... overrides) {
        return this.addOverride(Arrays.asList(overrides));
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JModel addOverride(Collection<? extends JOverride> overrides) {
        if (this.overrides == null) {
            this.overrides = new ArrayList<JOverride>(overrides);
        } else {
            this.overrides.addAll(overrides);
        }
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JModel parent(String parent) {
        this.parent = parent;
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JModel parent(ResourceLocation parent) {
        this.parent = parent.toString();
        return this;
    }

    @Contract(value="-> this", mutates="this")
    @CanIgnoreReturnValue
    public JModel noAmbientOcclusion() {
        this.ambientocclusion = false;
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JModel ambientOcclusion(boolean ambientocclusion) {
        this.ambientocclusion = ambientocclusion;
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JModel display(JDisplay display) {
        this.display = display;
        return this;
    }

    @Contract(value="_, _ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JModel addDisplay(JDisplay.DisplayPosition displayPosition, JPosition position) {
        if (this.display == null) {
            this.display = new JDisplay();
        }
        this.display.put(displayPosition, position);
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JModel textures(JTextures textures) {
        this.textures = textures;
        return this;
    }

    @Contract(value="_, _ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JModel addTexture(String name, String val) {
        if (this.textures == null) {
            this.textures = new JTextures();
        }
        this.textures.var(name, val);
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JModel addTextures(String ... strings) {
        if (this.textures == null) {
            this.textures = new JTextures();
        }
        this.textures.vars(strings);
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JModel element(JElement ... elements) {
        return this.element(Arrays.asList(elements));
    }

    @Contract(value="_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JModel element(Collection<? extends JElement> elements) {
        if (this.elements == null) {
            this.elements = new ArrayList<JElement>(elements);
        } else {
            this.elements.addAll(elements);
        }
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JModel setElements(List<JElement> elements) {
        this.elements = elements;
        return this;
    }

    public JModel clone() {
        try {
            return (JModel)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }
}

