/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.models;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import net.devtech.arrp.annotations.PreferredEnvironment;
import net.minecraft.core.Direction;
import net.minecraftforge.api.distmarker.Dist;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

@PreferredEnvironment(value=Dist.CLIENT)
public class JRotation
implements Cloneable {
    public final float[] origin = new float[3];
    @ApiStatus.AvailableSince(value="0.8.0")
    public final String axis;
    public Float angle;
    public Boolean rescale;

    public JRotation(Direction.Axis axis) {
        this.axis = axis.m_7912_();
    }

    public JRotation(Direction.Axis axis, float x, float y, float z, float angle) {
        this(axis);
        this.origin(x, y, z);
        this.angle(Float.valueOf(angle));
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _, _ -> this", mutates="this")
    public JRotation origin(float x, float y, float z) {
        this.origin[0] = x;
        this.origin[1] = y;
        this.origin[2] = z;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JRotation angle(Float angle) {
        this.angle = angle;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JRotation rescale(boolean rescale) {
        this.rescale = rescale;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="-> this", mutates="this")
    public JRotation rescale() {
        this.rescale = true;
        return this;
    }

    public JRotation clone() {
        try {
            return (JRotation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }
}

