/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.recipe;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import net.devtech.arrp.api.JsonSerializable;
import net.devtech.arrp.json.recipe.JStackedResult;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Contract;

public class JResult
implements Cloneable,
JsonSerializable {
    public final String item;
    public Integer count;

    public JResult(String id) {
        this.item = id;
    }

    public JResult(ResourceLocation id) {
        this(id.toString());
    }

    public JResult(ItemLike item) {
        this(Registry.f_122827_.m_7981_((Object)item.m_5456_()));
    }

    @Deprecated
    public static JResult item(Item item) {
        return JResult.result(Registry.f_122827_.m_7981_((Object)item).toString());
    }

    @Deprecated
    public static JResult result(String id) {
        return new JResult(id);
    }

    @Contract(value="_ -> this")
    @CanIgnoreReturnValue
    public JResult count(int count) {
        this.count = count;
        return this;
    }

    @Deprecated
    public static JStackedResult itemStack(Item item, int count) {
        return JResult.stackedResult(Registry.f_122827_.m_7981_((Object)item).toString(), count);
    }

    @Deprecated
    public static JStackedResult stackedResult(String id, int count) {
        JStackedResult stackedResult = new JStackedResult(id);
        stackedResult.count = count;
        return stackedResult;
    }

    public JResult clone() {
        try {
            return (JResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    @Override
    public JsonElement serialize(Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("item", this.item);
        if (this.count != null) {
            jsonObject.addProperty("count", (Number)this.count);
        }
        return jsonObject;
    }
}

