/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.recipe;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.devtech.arrp.json.recipe.JIngredient;
import net.devtech.arrp.json.recipe.JIngredients;
import net.devtech.arrp.json.recipe.JResult;
import net.devtech.arrp.json.recipe.JResultRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.ApiStatus;

public class JShapelessRecipe
extends JResultRecipe {
    private static final String TYPE = "minecraft:crafting_shapeless";
    @ApiStatus.AvailableSince(value="0.8.0")
    public final List<JIngredient> ingredients;

    @ApiStatus.Internal
    public JShapelessRecipe(String result, Collection<String> ingredients) {
        super(TYPE, result);
        this.ingredients = ingredients.stream().map(JIngredient::ofItem).collect(Collectors.toList());
    }

    @ApiStatus.AvailableSince(value="0.6.2")
    public JShapelessRecipe(String result, String ... ingredients) {
        super(TYPE, result);
        this.ingredients = Arrays.stream(ingredients).map(JIngredient::ofItem).collect(Collectors.toList());
    }

    public JShapelessRecipe(ResourceLocation result, ResourceLocation ... ingredients) {
        super(TYPE, result);
        this.ingredients = Arrays.stream(ingredients).map(JIngredient::ofItem).collect(Collectors.toList());
    }

    public JShapelessRecipe(ItemLike result, ItemLike ... ingredients) {
        super(TYPE, result);
        this.ingredients = Arrays.stream(ingredients).map(JIngredient::ofItem).collect(Collectors.toList());
    }

    @ApiStatus.Internal
    public JShapelessRecipe(JResult result, List<JIngredient> ingredients) {
        super(TYPE, result);
        this.ingredients = ingredients;
    }

    @Deprecated
    public JShapelessRecipe(JResult result, JIngredients ingredients) {
        super(TYPE, result);
        this.ingredients = ingredients.ingredients;
    }

    @Override
    public JShapelessRecipe resultCount(int count) {
        return (JShapelessRecipe)super.resultCount(count);
    }

    @Override
    public JShapelessRecipe group(String group) {
        return (JShapelessRecipe)super.group(group);
    }

    @Override
    public JShapelessRecipe clone() {
        return (JShapelessRecipe)super.clone();
    }
}

