/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.no_fog.mixin.client.compat116;

import net.minecraft.client.Camera;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.FluidState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import virtuoel.no_fog.NoFogClient;
import virtuoel.no_fog.util.FogToggleType;
import virtuoel.no_fog.util.ReflectionUtils;

@Mixin(value={FogRenderer.class})
public abstract class BackgroundRendererMixin {
    @Inject(method={"setupFog"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lcom/mojang/blaze3d/systems/RenderSystem;fogDensity(F)V")})
    private static void applyFogModifyDensity(Camera camera, FogRenderer.FogMode fogType, float viewDistance, boolean thickFog, float tickDelta, CallbackInfo info, FluidState fluidState, Entity entity, float density) throws Throwable {
        if (fluidState.m_205070_(FluidTags.f_13131_) && !NoFogClient.isToggleEnabled(FogToggleType.WATER, entity) || fluidState.m_205070_(FluidTags.f_13132_) && !NoFogClient.isToggleEnabled(FogToggleType.LAVA, entity)) {
            ReflectionUtils.setFogDensity(0.0f);
        }
    }

    @Inject(method={"setupFog"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lcom/mojang/blaze3d/systems/RenderSystem;fogStart(F)V")})
    private static void applyFogModifyStart(Camera camera, FogRenderer.FogMode fogType, float viewDistance, boolean thickFog, float tickDelta, CallbackInfo info, FluidState fluidState, Entity entity, float start) throws Throwable {
        float modified = BackgroundRendererMixin.getFogDistance(fogType, viewDistance, thickFog, entity, start, true);
        if (modified != start) {
            ReflectionUtils.setFogStart(modified);
        }
    }

    @Inject(method={"setupFog"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lcom/mojang/blaze3d/systems/RenderSystem;fogEnd(F)V")})
    private static void applyFogModifyEnd(Camera camera, FogRenderer.FogMode fogType, float viewDistance, boolean thickFog, float tickDelta, CallbackInfo info, FluidState fluidState, Entity entity, float start, float end) throws Throwable {
        float modified = BackgroundRendererMixin.getFogDistance(fogType, viewDistance, thickFog, entity, end, false);
        if (modified != end) {
            ReflectionUtils.setFogEnd(modified);
        }
    }

    @Unique
    private static float getFogDistance(FogRenderer.FogMode fogType, float viewDistance, boolean thickFog, Entity entity, float fogDistance, boolean start) {
        FogToggleType type = entity instanceof LivingEntity && ((LivingEntity)entity).m_21023_(MobEffects.f_19610_) ? FogToggleType.BLINDNESS : (thickFog ? FogToggleType.THICK : (fogType == FogRenderer.FogMode.FOG_SKY ? FogToggleType.SKY : FogToggleType.TERRAIN));
        return NoFogClient.getFogDistance(type, entity, fogDistance, start);
    }
}

