/*
 * Decompiled with CFR 0.152.
 */
package dev.limonblaze.oriacs.common.apoli.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.limonblaze.oriacs.common.Oriacs;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredItemCondition;
import io.github.edwinmindcraft.apoli.api.power.factory.EntityCondition;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@ParametersAreNonnullByDefault
public class EquippedCurioCondition
extends EntityCondition<Configuration> {
    public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("curio_slot").forGetter(Configuration::slot), (App)ConfiguredItemCondition.required((String)"item_condition").forGetter(Configuration::condition)).apply((Applicative)instance, Configuration::new));

    public EquippedCurioCondition() {
        super(CODEC);
    }

    protected boolean check(Configuration configuration, Entity entity) {
        LazyOptional optional;
        if (Oriacs.CURIOS_LOADED && (optional = entity.getCapability(CuriosCapability.INVENTORY)).isPresent()) {
            ICuriosItemHandler curiosItemHandler = (ICuriosItemHandler)optional.orElse(null);
            assert (curiosItemHandler != null);
            ICurioStacksHandler curioStacksHandler = (ICurioStacksHandler)curiosItemHandler.getCurios().get(configuration.slot);
            if (curioStacksHandler != null) {
                for (int slot = 0; slot < curioStacksHandler.getSlots(); ++slot) {
                    if (!ConfiguredItemCondition.check(configuration.condition, (Level)entity.f_19853_, (ItemStack)curioStacksHandler.getStacks().getStackInSlot(slot))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public record Configuration(String slot, Holder<ConfiguredItemCondition<?, ?>> condition) implements IDynamicFeatureConfiguration
    {
    }
}

