/*
 * Decompiled with CFR 0.152.
 */
package dev.limonblaze.oriacs.common.item;

import dev.limonblaze.oriacs.common.OriacsServerConfig;
import dev.limonblaze.oriacs.common.registry.OriacsItems;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@Mod.EventBusSubscriber(modid="oriacs")
public class UmbrellaItem
extends Item
implements DyeableLeatherItem,
Vanishable {
    public static final int BAR_COLOR = Mth.m_14159_((float)0.4f, (float)0.4f, (float)1.0f);

    public UmbrellaItem(Item.Properties properties) {
        super(properties.m_41487_(1).setNoRepair());
        CauldronInteraction.f_175607_.put(this, CauldronInteraction.f_175615_);
    }

    public boolean canKeepOutRain(ItemStack stack) {
        return (Boolean)OriacsServerConfig.CONFIG.UMBRELLA_CAN_KEEP_OUT_RAIN.get() != false && stack.m_41773_() < stack.m_41776_();
    }

    public static boolean canKeepOutRain(LivingEntity entity) {
        UmbrellaItem umbrella;
        ItemStack stack = entity.m_21205_();
        Item item = stack.m_41720_();
        if (item instanceof UmbrellaItem && (umbrella = (UmbrellaItem)item).canKeepOutRain(stack)) {
            return true;
        }
        stack = entity.m_21206_();
        item = stack.m_41720_();
        return item instanceof UmbrellaItem && (umbrella = (UmbrellaItem)item).canKeepOutRain(stack);
    }

    public boolean canKeepOutSunlight(ItemStack stack) {
        int max;
        if (!((Boolean)OriacsServerConfig.CONFIG.UMBRELLA_CAN_KEEP_OUT_SUNLIGHT.get()).booleanValue()) {
            return false;
        }
        int color = this.m_41121_(stack);
        return (color >> 16 & 0xFF) <= (max = ((Integer)OriacsServerConfig.CONFIG.UMBRELLA_MAX_KEEP_OUT_SUNLIGHT_COLOR.get()).intValue()) && (color >> 8 & 0xFF) <= max && (color & 0xFF) <= max;
    }

    public static boolean canKeepOutSunlight(LivingEntity entity) {
        UmbrellaItem umbrella;
        ItemStack stack = entity.m_21205_();
        Item item = stack.m_41720_();
        if (item instanceof UmbrellaItem && (umbrella = (UmbrellaItem)item).canKeepOutSunlight(stack)) {
            return true;
        }
        stack = entity.m_21206_();
        item = stack.m_41720_();
        return item instanceof UmbrellaItem && (umbrella = (UmbrellaItem)item).canKeepOutSunlight(stack);
    }

    public int m_41121_(ItemStack pStack) {
        CompoundTag compoundtag = pStack.m_41737_("display");
        return compoundtag != null && compoundtag.m_128425_("color", 99) ? compoundtag.m_128451_("color") : 14473664;
    }

    public int m_142159_(ItemStack pStack) {
        return BAR_COLOR;
    }

    public boolean m_142522_(ItemStack stack) {
        return stack.m_41773_() > 0;
    }

    public boolean m_41465_() {
        return false;
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)OriacsServerConfig.CONFIG.UMBRELLA_MAX_DAMAGE.get();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return ItemStack.m_41758_((ItemStack)oldStack, (ItemStack)newStack);
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.f_19797_ % 20 != 0) {
            return;
        }
        Level level = entity.f_19853_;
        BlockPos pos = entity.m_20183_();
        boolean isInRain = level.m_46758_(pos) || level.m_46758_(new BlockPos((double)pos.m_123341_(), entity.m_20191_().f_82292_, (double)pos.m_123343_()));
        for (ItemStack stack : entity.m_6167_()) {
            if (!(stack.m_41720_() instanceof UmbrellaItem)) continue;
            if (isInRain) {
                stack.m_41721_(Mth.m_14045_((int)(stack.m_41773_() + 1), (int)0, (int)stack.m_41776_()));
                continue;
            }
            if (((Biome)level.m_204166_(pos).m_203334_()).m_198910_(pos)) {
                stack.m_41721_(Mth.m_14045_((int)(stack.m_41773_() - 2), (int)0, (int)stack.m_41776_()));
                continue;
            }
            stack.m_41721_(Mth.m_14045_((int)(stack.m_41773_() - 1), (int)0, (int)stack.m_41776_()));
        }
    }

    @SubscribeEvent
    public static void onLivingSpawn(LivingSpawnEvent.SpecialSpawn event) {
        Mob mob = event.getEntity();
        if (mob instanceof Zombie) {
            Zombie zombie = (Zombie)mob;
            RandomSource random = zombie.m_217043_();
            if (zombie.f_19853_.m_46791_() == Difficulty.HARD && (double)random.m_188501_() < (Double)OriacsServerConfig.CONFIG.UMBRELLA_SPAWN_WITH_ZOMBIE_CHANCE.get() && zombie.m_21120_(InteractionHand.OFF_HAND).m_41619_()) {
                UmbrellaItem umbrella = (UmbrellaItem)((Object)OriacsItems.UMBRELLA.get());
                ItemStack stack = umbrella.m_7968_();
                umbrella.m_41115_(stack, random.m_188503_(0xFFFFFF));
                zombie.m_21008_(InteractionHand.OFF_HAND, stack);
            }
        }
    }
}

