/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.enhancedblockentities.client.model;

import foundationgames.enhancedblockentities.util.DateUtil;
import foundationgames.enhancedblockentities.util.duck.ModelStateHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ModelSelector {
    private static final List<ModelSelector> REGISTRY = new ArrayList<ModelSelector>();
    public static final ModelSelector STATE_HOLDER_SELECTOR;
    public static final ModelSelector CHEST;
    public static final ModelSelector CHEST_WITH_CHRISTMAS;
    public static final ModelSelector BELL;
    public static final ModelSelector SHULKER_BOX;
    public final int id = REGISTRY.size();

    public abstract int getModelIndex(BlockAndTintGetter var1, BlockState var2, BlockPos var3, Supplier<RandomSource> var4, RenderContext var5);

    public ModelSelector() {
        REGISTRY.add(this);
    }

    public static ModelSelector fromId(int id) {
        return REGISTRY.get(id);
    }

    static {
        CHEST = STATE_HOLDER_SELECTOR = new ModelSelector(){

            @Override
            public int getModelIndex(BlockAndTintGetter view, BlockState state, BlockPos pos, Supplier<RandomSource> rand, RenderContext context) {
                BlockEntity blockEntity = view.m_7702_(pos);
                if (blockEntity instanceof ModelStateHolder) {
                    ModelStateHolder stateHolder = (ModelStateHolder)blockEntity;
                    return stateHolder.getModelState();
                }
                return 0;
            }
        };
        CHEST_WITH_CHRISTMAS = new ModelSelector(){

            @Override
            public int getModelIndex(BlockAndTintGetter view, BlockState state, BlockPos pos, Supplier<RandomSource> rand, RenderContext context) {
                int os = DateUtil.isChristmas() ? 2 : 0;
                BlockEntity blockEntity = view.m_7702_(pos);
                if (blockEntity instanceof ModelStateHolder) {
                    ModelStateHolder stateHolder = (ModelStateHolder)blockEntity;
                    return stateHolder.getModelState() + os;
                }
                return os;
            }
        };
        BELL = STATE_HOLDER_SELECTOR;
        SHULKER_BOX = STATE_HOLDER_SELECTOR;
    }
}

