/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.enhancedblockentities.client.render;

import foundationgames.enhancedblockentities.EnhancedBlockEntities;
import foundationgames.enhancedblockentities.client.render.SignRenderManager;
import foundationgames.enhancedblockentities.config.EBEConfig;
import foundationgames.enhancedblockentities.mixin.SignBlockEntityRenderAccessor;
import foundationgames.enhancedblockentities.util.duck.ModelStateHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

@FunctionalInterface
public interface BlockEntityRenderCondition {
    public static final BlockEntityRenderCondition STATE_GREATER_THAN_1;
    public static final BlockEntityRenderCondition CHEST;
    public static final BlockEntityRenderCondition BELL;
    public static final BlockEntityRenderCondition SHULKER_BOX;
    public static final BlockEntityRenderCondition SIGN;
    public static final BlockEntityRenderCondition NEVER;
    public static final BlockEntityRenderCondition ALWAYS;

    public boolean shouldRender(BlockEntity var1);

    static {
        CHEST = STATE_GREATER_THAN_1 = entity -> {
            if (entity instanceof ModelStateHolder) {
                ModelStateHolder stateHolder = (ModelStateHolder)entity;
                return stateHolder.getModelState() > 0;
            }
            return false;
        };
        BELL = STATE_GREATER_THAN_1;
        SHULKER_BOX = STATE_GREATER_THAN_1;
        SIGN = entity -> {
            EBEConfig config = EnhancedBlockEntities.CONFIG;
            if (config.signTextRendering.equals("all")) {
                return true;
            }
            double playerDistance = Minecraft.m_91087_().f_91074_.m_20183_().m_123331_((Vec3i)entity.m_58899_());
            if (config.signTextRendering.equals("smart")) {
                ++SignRenderManager.renderedSigns;
                return playerDistance < 80.0 + Math.max(0.0, 580.0 - (double)SignRenderManager.getRenderedSignAmount() * 0.7);
            }
            double dist = SignBlockEntityRenderAccessor.enhanced_bes$getRenderDistance();
            Vec3 blockPos = Vec3.m_82512_((Vec3i)entity.m_58899_());
            Vec3 playerPos = Minecraft.m_91087_().f_91074_.m_20182_();
            if (config.signTextRendering.equals("most")) {
                return blockPos.m_82509_((Position)playerPos, dist * 0.6);
            }
            if (config.signTextRendering.equals("some")) {
                return blockPos.m_82509_((Position)playerPos, dist * 0.3);
            }
            if (config.signTextRendering.equals("few")) {
                return blockPos.m_82509_((Position)playerPos, dist * 0.15);
            }
            return false;
        };
        NEVER = entity -> false;
        ALWAYS = entity -> true;
    }
}

