/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.enhancedblockentities.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import foundationgames.enhancedblockentities.client.render.BlockEntityRendererOverride;
import foundationgames.enhancedblockentities.util.EBEUtil;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;

public class ChestBlockEntityRendererOverride
extends BlockEntityRendererOverride {
    private BakedModel[] models = null;
    private final Supplier<BakedModel[]> modelGetter;
    private final Function<BlockEntity, Integer> modelSelector;

    public ChestBlockEntityRendererOverride(Supplier<BakedModel[]> modelGetter, Function<BlockEntity, Integer> modelSelector) {
        this.modelGetter = modelGetter;
        this.modelSelector = modelSelector;
    }

    @Override
    public void render(BlockEntity blockEntity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        if (this.models == null) {
            this.models = this.modelGetter.get();
        }
        if (blockEntity instanceof LidBlockEntity) {
            matrices.m_85836_();
            LidBlockEntity chest = ChestBlockEntityRendererOverride.getAnimationProgress(blockEntity, tickDelta);
            matrices.m_85837_(0.5, 0.0, 0.5);
            Direction dir = (Direction)blockEntity.m_58900_().m_61143_((Property)ChestBlock.f_51478_);
            matrices.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - dir.m_122435_()));
            matrices.m_85837_(-0.5, 0.0, -0.5);
            float yPiv = 0.5625f;
            float zPiv = 0.9375f;
            matrices.m_85837_(0.0, (double)yPiv, (double)zPiv);
            float rot = chest.m_6683_(tickDelta);
            rot = 1.0f - rot;
            rot = 1.0f - rot * rot * rot;
            matrices.m_85845_(Vector3f.f_122223_.m_122240_(rot * 90.0f));
            matrices.m_85837_(0.0, (double)(-yPiv), (double)(-zPiv));
            EBEUtil.renderBakedModel(vertexConsumers, blockEntity.m_58900_(), matrices, this.models[this.modelSelector.apply(blockEntity)], light, overlay);
            matrices.m_85849_();
        }
    }

    public static LidBlockEntity getAnimationProgress(BlockEntity blockEntity, float tickDelta) {
        LidBlockEntity chest = (LidBlockEntity)blockEntity;
        BlockState state = blockEntity.m_58900_();
        if (state.m_61138_((Property)ChestBlock.f_51479_) && state.m_61143_((Property)ChestBlock.f_51479_) != ChestType.SINGLE) {
            float nAnim;
            BlockEntity neighbor = null;
            BlockPos pos = blockEntity.m_58899_();
            Direction facing = (Direction)state.m_61143_((Property)ChestBlock.f_51478_);
            switch ((ChestType)state.m_61143_((Property)ChestBlock.f_51479_)) {
                case LEFT: {
                    neighbor = blockEntity.m_58904_().m_7702_(pos.m_121945_(facing.m_122427_()));
                    break;
                }
                case RIGHT: {
                    neighbor = blockEntity.m_58904_().m_7702_(pos.m_121945_(facing.m_122428_()));
                }
            }
            if (neighbor instanceof LidBlockEntity && (nAnim = ((LidBlockEntity)neighbor).m_6683_(tickDelta)) > chest.m_6683_(tickDelta)) {
                chest = (LidBlockEntity)neighbor;
            }
        }
        return chest;
    }

    @Override
    public void onModelsReload() {
        this.models = null;
    }
}

